/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.LanguageTextField;
import org.jetbrains.annotations.NotNull;

public class EditorTextFieldProviderImpl
implements EditorTextFieldProvider {
    @Override
    @NotNull
    public EditorTextField getEditorField(@NotNull Language language, @NotNull Project project, @NotNull Iterable<EditorCustomization> features) {
        return new MyEditorTextField(language, project, features);
    }

    private static class MyEditorTextField
    extends LanguageTextField {
        @NotNull
        private final Iterable<? extends EditorCustomization> myCustomizations;

        MyEditorTextField(@NotNull Language language, @NotNull Project project, @NotNull Iterable<? extends EditorCustomization> customizations) {
            super(language, project, "", false);
            this.myCustomizations = customizations;
        }

        @Override
        protected EditorEx createEditor() {
            EditorEx ex = super.createEditor();
            ex.getScrollPane().setVerticalScrollBarPolicy(20);
            ex.setHorizontalScrollbarVisible(true);
            MyEditorTextField.applyDefaultSettings(ex);
            this.applyCustomizations(ex);
            return ex;
        }

        private static void applyDefaultSettings(EditorEx ex) {
            EditorSettings settings = ex.getSettings();
            settings.setAdditionalColumnsCount(3);
            settings.setVirtualSpace(false);
        }

        private void applyCustomizations(@NotNull EditorEx editor) {
            for (EditorCustomization editorCustomization : this.myCustomizations) {
                editorCustomization.customize(editor);
            }
        }

        @Override
        protected boolean isOneLineMode() {
            return false;
        }
    }
}

