/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Expandable;
import com.intellij.ui.ExtendableEditorSupport;
import com.intellij.ui.components.fields.ExpandableSupport;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class ExpandableEditorSupport
extends ExpandableSupport<EditorTextField> {
    public ExpandableEditorSupport(@NotNull EditorTextField field) {
        super((JComponent)((Object)field), null, null);
        field.addSettingsProvider(editor -> {
            this.initFieldEditor(editor, field.getBackground());
            this.updateFieldFolding(editor);
        });
    }

    public ExpandableEditorSupport(@NotNull EditorTextField field, @NotNull Function<? super String, ? extends List<String>> parser, @NotNull Function<? super List<String>, String> joiner) {
        super((JComponent)((Object)field), text -> StringUtil.join((Collection)((Collection)parser.fun(text)), (String)"\n"), text -> (String)joiner.fun(Arrays.asList(StringUtil.splitByLines((String)text))));
        field.addSettingsProvider(editor -> {
            this.initFieldEditor(editor, field.getBackground());
            this.updateFieldFolding(editor);
        });
    }

    protected void initPopupEditor(@NotNull EditorEx editor, Color background) {
        JLabel label2 = ExpandableSupport.createLabel((ExtendableTextComponent.Extension)this.createCollapseExtension());
        label2.setBorder((Border)JBUI.Borders.empty((int)5, (int)3, (int)5, (int)7));
        editor.getContentComponent().putClientProperty(Expandable.class, (Object)this);
        editor.getScrollPane().setHorizontalScrollBarPolicy(30);
        editor.getScrollPane().setVerticalScrollBarPolicy(20);
        editor.getScrollPane().getVerticalScrollBar().setBackground(background);
        editor.getScrollPane().getVerticalScrollBar().add("JB_SCROLL_BAR_LEADING_COMPONENT", label2);
        editor.getScrollPane().setViewportBorder((Border)JBUI.Borders.empty((int)4, (int)6));
        label2.setOpaque(true);
    }

    protected void initFieldEditor(@NotNull EditorEx editor, Color background) {
        editor.getContentComponent().putClientProperty(Expandable.class, (Object)this);
        ExtendableTextComponent.Extension extension = this.createExpandExtension();
        ExtendableEditorSupport.setupExtension(editor, background, extension);
    }

    protected void updateFieldFolding(@NotNull EditorEx editor) {
        FoldingModelEx model = editor.getFoldingModel();
        CharSequence text = editor.getDocument().getCharsSequence();
        model.runBatchFoldingOperation(() -> {
            model.clearFoldRegions();
            for (int i = 0; i < text.length(); ++i) {
                FoldRegion region;
                if (text.charAt(i) != '\n' || (region = model.createFoldRegion(i, i + 1, " \u23ce ", null, true)) == null) continue;
                region.setExpanded(false);
            }
        });
    }

    @NotNull
    protected ExpandableSupport.Content prepare(final @NotNull EditorTextField field, @NotNull Function<? super String, String> onShow) {
        final EditorTextField popup2 = this.createPopupEditor(field, (String)onShow.fun((Object)field.getText()));
        Color background = field.getBackground();
        popup2.setBackground(background);
        popup2.setOneLineMode(false);
        popup2.setPreferredSize(new Dimension(field.getWidth(), 5 * field.getHeight()));
        popup2.addSettingsProvider(editor -> {
            this.initPopupEditor(editor, background);
            ExpandableEditorSupport.copyCaretPosition(editor, field.getEditor());
        });
        return new ExpandableSupport.Content(){

            @NotNull
            public JComponent getContentComponent() {
                return popup2;
            }

            public JComponent getFocusableComponent() {
                return popup2;
            }

            public void cancel(@NotNull Function<? super String, String> onHide) {
                field.setText((String)onHide.fun((Object)popup2.getText()));
                Editor editor = field.getEditor();
                if (editor != null) {
                    ExpandableEditorSupport.copyCaretPosition(editor, popup2.getEditor());
                }
                if (editor instanceof EditorEx) {
                    ExpandableEditorSupport.this.updateFieldFolding((EditorEx)editor);
                }
            }
        };
    }

    @NotNull
    protected EditorTextField createPopupEditor(@NotNull EditorTextField field, @NotNull String text) {
        Document document = Comparing.equal((String)text, (String)field.getDocument().getText()) ? field.getDocument() : EditorFactory.getInstance().createDocument((CharSequence)text);
        return new EditorTextField(document, field.getProject(), field.getFileType());
    }

    private static void copyCaretPosition(@NotNull Editor destination, Editor source) {
        if (source == null) {
            return;
        }
        try {
            destination.getCaretModel().setCaretsAndSelections(source.getCaretModel().getCaretsAndSelections());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

