/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.IdeFrameEx;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.peer.FramePeer;
import org.jetbrains.annotations.NotNull;
import sun.awt.AWTAccessor;

public class FrameState {
    private Rectangle myBounds;
    private boolean myMaximized;
    private boolean myFullScreen;

    public Point getLocation() {
        return this.myBounds == null ? null : this.myBounds.getLocation();
    }

    public Dimension getSize() {
        return this.myBounds == null ? null : this.myBounds.getSize();
    }

    public Rectangle getBounds() {
        return this.myBounds == null ? null : new Rectangle(this.myBounds);
    }

    public boolean isMaximized() {
        return this.myMaximized;
    }

    public boolean isFullScreen() {
        return this.myFullScreen;
    }

    public static int getExtendedState(Component component) {
        int state = 0;
        if (component instanceof Frame) {
            Object peer;
            state = ((Frame)component).getExtendedState();
            if (SystemInfo.isMacOSLion && (peer = AWTAccessor.getComponentAccessor().getPeer(component)) instanceof FramePeer) {
                state = ((FramePeer)peer).getState();
            }
        }
        return state;
    }

    public static boolean isFullScreen(Component component) {
        return component instanceof IdeFrameEx && WindowManager.getInstance().isFullScreenSupportedInCurrentOS() && ((IdeFrameEx)((Object)component)).isInFullScreen();
    }

    public static boolean isMaximized(int state) {
        return (state & 6) == 6;
    }

    private static FrameState findFrameState(@NotNull Component component) {
        for (ComponentListener listener2 : component.getComponentListeners()) {
            if (!(listener2 instanceof FrameState)) continue;
            return (FrameState)((Object)listener2);
        }
        return null;
    }

    public static FrameState getFrameState(@NotNull Component component) {
        FrameState state = FrameState.findFrameState(component);
        if (state == null) {
            state = new FrameState();
        }
        if (state.myBounds == null) {
            state.update(component);
        }
        return state;
    }

    public static void setFrameStateListener(@NotNull Component component) {
        FrameState state;
        if (component instanceof Frame && (state = FrameState.findFrameState(component)) == null) {
            component.addComponentListener(new Listener());
        }
    }

    final void update(Component component) {
        Rectangle bounds2 = component.getBounds();
        this.myFullScreen = FrameState.isFullScreen(component);
        this.myMaximized = FrameState.isMaximized(FrameState.getExtendedState(component));
        if (this.myBounds != null && (this.myFullScreen || this.myMaximized) && bounds2.contains(this.myBounds.x + this.myBounds.width / 2, this.myBounds.y + this.myBounds.height / 2)) {
            return;
        }
        this.myBounds = bounds2;
    }

    private static final class Listener
    extends FrameState
    implements ComponentListener {
        private Listener() {
        }

        @Override
        public void componentMoved(ComponentEvent event) {
            this.update(event.getComponent());
        }

        @Override
        public void componentResized(ComponentEvent event) {
            this.update(event.getComponent());
        }

        @Override
        public void componentShown(ComponentEvent event) {
        }

        @Override
        public void componentHidden(ComponentEvent event) {
        }
    }
}

