/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.GotItPanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotItMessage {
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myMessage;
    private Disposable myDisposable;
    private Runnable myCallback;
    private HyperlinkListener myHyperlinkListener = BrowserHyperlinkListener.INSTANCE;
    private boolean myShowCallout = true;

    private GotItMessage(@NotNull String title, @NotNull String message) {
        this.myTitle = title;
        this.myMessage = "<html><body><div align='center' style='font-family: " + UIUtil.getLabelFont().getFontName() + "; font-size: " + JBUI.scale((int)12) + "pt;'>" + StringUtil.replace((String)message, (String)"\n", (String)"<br>") + "</div></body></html>";
    }

    public static GotItMessage createMessage(@NotNull String title, @NotNull String message) {
        return new GotItMessage(title, message);
    }

    public GotItMessage setDisposable(Disposable disposable) {
        this.myDisposable = disposable;
        return this;
    }

    public GotItMessage setCallback(@Nullable Runnable callback2) {
        this.myCallback = callback2;
        return this;
    }

    public GotItMessage setHyperlinkListener(@Nullable HyperlinkListener hyperlinkListener) {
        this.myHyperlinkListener = hyperlinkListener;
        return this;
    }

    public GotItMessage setShowCallout(boolean showCallout) {
        this.myShowCallout = showCallout;
        return this;
    }

    public void show(@NotNull RelativePoint point, @NotNull Balloon.Position position) {
        this.show((PositionTracker<Balloon>)new PositionTracker.Static(point), position);
    }

    public void show(@NotNull PositionTracker<Balloon> tracker, @NotNull Balloon.Position position) {
        if (this.myDisposable != null && Disposer.isDisposed((Disposable)this.myDisposable)) {
            return;
        }
        GotItPanel panel2 = new GotItPanel();
        panel2.myTitle.setText(this.myTitle);
        panel2.myMessage.setText(this.myMessage);
        if (this.myHyperlinkListener != null) {
            panel2.myMessage.addHyperlinkListener(this.myHyperlinkListener);
        }
        panel2.myButton.setCursor(Cursor.getPredefinedCursor(12));
        BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)panel2.myRoot);
        if (this.myDisposable != null) {
            builder2.setDisposable(this.myDisposable);
        }
        final Balloon balloon = builder2.setFillColor(UIUtil.getListBackground()).setHideOnClickOutside(false).setHideOnAction(false).setHideOnFrameResize(false).setHideOnKeyOutside(false).setShowCallout(this.myShowCallout).setBlockClicksThroughBalloon(true).createBalloon();
        panel2.myButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                balloon.hide();
                if (GotItMessage.this.myCallback != null) {
                    GotItMessage.this.myCallback.run();
                }
            }
        });
        balloon.show(tracker, position);
    }
}

