/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.SystemNotificationsImpl;
import com.intellij.ui.mac.growl.Growl;
import com.intellij.util.ArrayUtil;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

class GrowlNotifications
implements SystemNotificationsImpl.Notifier {
    private static final Logger LOG = Logger.getInstance(GrowlNotifications.class);
    private static GrowlNotifications ourNotifications;
    private final Growl myGrowl = new Growl(ApplicationNamesInfo.getInstance().getFullProductName());
    private final Set<String> myNotifications = new TreeSet<String>();

    public static synchronized GrowlNotifications getInstance() {
        if (ourNotifications == null) {
            ourNotifications = new GrowlNotifications();
        }
        return ourNotifications;
    }

    private GrowlNotifications() {
        this.register();
    }

    private void register() {
        this.myGrowl.setAllowedNotifications(ArrayUtil.toStringArray(this.myNotifications));
        this.myGrowl.setDefaultNotifications(ArrayUtil.toStringArray(this.myNotifications));
        this.myGrowl.register();
    }

    @Override
    public void notify(@NotNull String name, @NotNull String title, @NotNull String description) {
        try {
            if (this.myNotifications.add(name)) {
                this.register();
            }
            this.myGrowl.notifyGrowlOf(name, title, description);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }
}

