/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.Function;
import com.intellij.util.containers.FixedHashMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class IconDeferrerImpl
extends IconDeferrer {
    private final Object LOCK = new Object();
    private final Map<Object, Icon> myIconsCache = new FixedHashMap(Registry.intValue((String)"ide.icons.deferrerCacheSize"));
    private long myLastClearTimestamp;
    private static final ThreadLocal<Boolean> myEvaluationIsInProgress = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public IconDeferrerImpl(@NotNull MessageBus bus) {
        MessageBusConnection connection = bus.connect();
        connection.subscribe(PsiModificationTracker.TOPIC, this::clear);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                IconDeferrerImpl.this.clear();
            }
        });
        connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener(){

            public void afterProjectClosed(@NotNull Project project) {
                IconDeferrerImpl.this.clear();
            }
        });
        LowMemoryWatcher.register(this::clear, (Disposable)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myIconsCache.clear();
            ++this.myLastClearTimestamp;
        }
    }

    public <T> Icon defer(Icon base, T param, @NotNull Function<T, Icon> evaluator) {
        return this.deferImpl(base, param, evaluator, false);
    }

    public <T> Icon deferAutoUpdatable(Icon base, T param, @NotNull Function<? super T, ? extends Icon> evaluator) {
        return this.deferImpl(base, param, evaluator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Icon deferImpl(Icon base, T param, @NotNull Function<? super T, ? extends Icon> evaluator, boolean autoUpdatable) {
        if (myEvaluationIsInProgress.get().booleanValue()) {
            return (Icon)evaluator.fun(param);
        }
        Object object = this.LOCK;
        synchronized (object) {
            Icon cached = this.myIconsCache.get(param);
            if (cached != null) {
                return cached;
            }
            long started = this.myLastClearTimestamp;
            DeferredIconImpl<Object> result2 = new DeferredIconImpl<Object>(base, param, evaluator, (source, key, r) -> {
                Object object = this.LOCK;
                synchronized (object) {
                    if (started == this.myLastClearTimestamp) {
                        this.myIconsCache.put(key, (Icon)(autoUpdatable ? source : r));
                    }
                }
            }, autoUpdatable);
            this.myIconsCache.put(param, (Icon)((Object)result2));
            return result2;
        }
    }

    static void evaluateDeferred(@NotNull Runnable runnable2) {
        try {
            myEvaluationIsInProgress.set(Boolean.TRUE);
            runnable2.run();
        }
        finally {
            myEvaluationIsInProgress.set(Boolean.FALSE);
        }
    }

    public boolean equalIcons(Icon icon1, Icon icon2) {
        return DeferredIconImpl.equalIcons(icon1, icon2);
    }
}

