/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LicensingFacade {
    public String licensedTo;
    public List<String> restrictions;
    public boolean isEvaluation;
    public Date expirationDate;
    public Date perpetualFallbackDate;
    public Map<String, String> confirmationStamps;
    public static volatile LicensingFacade INSTANCE;

    @Nullable
    public static LicensingFacade getInstance() {
        return INSTANCE;
    }

    @Nullable
    public String getLicensedToMessage() {
        return this.licensedTo;
    }

    @NotNull
    public List<String> getLicenseRestrictionsMessages() {
        return this.restrictions == null ? Collections.emptyList() : Collections.unmodifiableList(this.restrictions);
    }

    public boolean isEvaluationLicense() {
        return this.isEvaluation;
    }

    public boolean isApplicableForProduct(@NotNull Date releaseDate) {
        return this.isPerpetualForProduct(releaseDate) || this.expirationDate == null || releaseDate.before(this.expirationDate);
    }

    public boolean isPerpetualForProduct(@NotNull Date releaseDate) {
        return this.perpetualFallbackDate != null && releaseDate.before(this.perpetualFallbackDate);
    }

    @Nullable
    public Date getLicenseExpirationDate() {
        return this.expirationDate;
    }

    @Nullable
    public String getConfirmationStamp(String productCode) {
        return this.confirmationStamps == null ? null : this.confirmationStamps.get(productCode);
    }
}

