/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListSpeedSearch<T>
extends SpeedSearchBase<JList<T>> {
    @Nullable
    private final Function<? super T, String> myToStringConvertor;

    public ListSpeedSearch(JList<T> list2) {
        super(list2);
        this.myToStringConvertor = null;
        this.registerSelectAll(list2);
    }

    public ListSpeedSearch(JList<T> list2, @NotNull Function<? super T, String> convertor) {
        super(list2);
        this.myToStringConvertor = convertor;
        this.registerSelectAll(list2);
    }

    @Deprecated
    public ListSpeedSearch(JList<T> list2, @Nullable Convertor<? super T, String> convertor) {
        super(list2);
        this.myToStringConvertor = convertor == null ? null : arg_0 -> convertor.convert(arg_0);
        this.registerSelectAll(list2);
    }

    private void registerSelectAll(JList<T> list2) {
        new MySelectAllAction(list2, this).registerCustomShortcutSet(list2, null);
    }

    @Override
    protected void selectElement(Object element, String selectedText) {
        if (element != null) {
            ScrollingUtil.selectItem((JList)((JList)this.myComponent), (Object)element);
        } else {
            ((JList)this.myComponent).clearSelection();
        }
    }

    @Override
    protected int getSelectedIndex() {
        return ((JList)this.myComponent).getSelectedIndex();
    }

    @Override
    @NotNull
    protected Object[] getAllElements() {
        return ListSpeedSearch.getAllListElements((JList)this.myComponent);
    }

    public static Object[] getAllListElements(JList list2) {
        ListModel model = list2.getModel();
        if (model instanceof DefaultListModel) {
            return ((DefaultListModel)model).toArray();
        }
        Object[] elements = new Object[model.getSize()];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = model.getElementAt(i);
        }
        return elements;
    }

    @Override
    protected String getElementText(Object element) {
        if (this.myToStringConvertor != null) {
            return (String)this.myToStringConvertor.fun(element);
        }
        return element == null ? null : element.toString();
    }

    @NotNull
    private TIntArrayList findAllFilteredElements(String s) {
        TIntArrayList indices = new TIntArrayList();
        String _s = s.trim();
        Object[] elements = ListSpeedSearch.getAllListElements((JList)this.myComponent);
        for (int i = 0; i < elements.length; ++i) {
            Object element = elements[i];
            if (!this.isMatchingElement(element, _s)) continue;
            indices.add(i);
        }
        return indices;
    }

    private static class MySelectAllAction
    extends DumbAwareAction {
        @NotNull
        private final JList myList;
        @NotNull
        private final ListSpeedSearch mySearch;

        MySelectAllAction(@NotNull JList list2, @NotNull ListSpeedSearch search2) {
            this.myList = list2;
            this.mySearch = search2;
            AnAction action = ActionManager.getInstance().getAction("$SelectAll");
            if (action != null) {
                this.copyShortcutFrom(action);
            }
            this.setEnabledInModalContext(true);
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(this.mySearch.isPopupActive() && this.myList.getSelectionModel().getSelectionMode() == 2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            ListSelectionModel sm = this.myList.getSelectionModel();
            String query = this.mySearch.getEnteredPrefix();
            if (query == null) {
                return;
            }
            TIntArrayList filtered = this.mySearch.findAllFilteredElements(query);
            if (filtered.isEmpty()) {
                return;
            }
            boolean alreadySelected = Arrays.equals(filtered.toNativeArray(), this.myList.getSelectedIndices());
            if (alreadySelected) {
                int anchor2 = this.myList.getAnchorSelectionIndex();
                this.myList.setSelectedIndex(anchor2);
                sm.setAnchorSelectionIndex(anchor2);
                this.mySearch.findAndSelectElement(query);
            } else {
                int anchor3 = -1;
                Object currentElement = this.mySearch.findElement(query);
                if (currentElement != null) {
                    List<Object> elements = Arrays.asList(ListSpeedSearch.getAllListElements(this.myList));
                    anchor3 = ContainerUtil.indexOfIdentity(elements, (Object)currentElement);
                }
                if (anchor3 == -1) {
                    anchor3 = filtered.get(0);
                }
                this.myList.setSelectedIndices(filtered.toNativeArray());
                sm.setAnchorSelectionIndex(anchor3);
            }
        }
    }
}

