/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Divider;
import com.intellij.openapi.ui.PseudoSplitter;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.ui.AbstractTitledSeparatorWithIcon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventHandler;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class SplitterWithSecondHideable {
    @NotNull
    private final PseudoSplitter mySplitter;
    @NotNull
    private final AbstractTitledSeparatorWithIcon myTitledSeparator;
    @NotNull
    private final OnOffListener<Integer> myListener;
    @NotNull
    private final JPanel myFictivePanel;
    private float myPreviousProportion;

    public SplitterWithSecondHideable(boolean vertical, @NotNull String separatorText, @NotNull JComponent firstComponent, @NotNull OnOffListener<Integer> listener2) {
        this.myListener = listener2;
        this.myFictivePanel = JBUI.Panels.simplePanel();
        this.myTitledSeparator = new MyTitledSeparator(separatorText, vertical);
        this.mySplitter = new MySplitter(vertical);
        this.mySplitter.setDoubleBuffered(true);
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.mySplitter.setFirstComponent(firstComponent);
        this.mySplitter.setSecondComponent((JComponent)this.myFictivePanel);
        this.mySplitter.setProportion(1.0f);
    }

    public void setText(String value) {
        this.myTitledSeparator.setText(value);
    }

    @NotNull
    public Splitter getComponent() {
        return this.mySplitter;
    }

    protected abstract RefreshablePanel createDetails();

    protected abstract float getSplitterInitialProportion();

    public float getUsedProportion() {
        return this.isOn() ? this.mySplitter.getProportion() : this.myPreviousProportion;
    }

    public void initOn() {
        this.myTitledSeparator.initOn();
    }

    public void on() {
        this.myTitledSeparator.on();
    }

    public void off() {
        this.myTitledSeparator.off();
    }

    public boolean isOn() {
        return this.myTitledSeparator.myOn;
    }

    private class MySplitter
    extends PseudoSplitter {
        @NotNull
        private final MouseEventHandler myMouseListener;

        MySplitter(boolean vertical) {
            super(vertical);
            this.myMouseListener = new MouseEventHandler(){

                public void mouseEntered(MouseEvent event) {
                    ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.setCursor(new Cursor(SplitterWithSecondHideable.this.isOn() ? 9 : 0));
                    super.mouseEntered(event);
                }

                public void mouseExited(MouseEvent event) {
                    ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.setCursor(new Cursor(0));
                    super.mouseExited(event);
                }

                protected void handle(MouseEvent event) {
                    if (event.getID() == 506 || event.getID() == 503) {
                        ((MyDivider)MySplitter.this.myDivider).processMouseMotionEvent(event);
                    } else {
                        ((MyDivider)MySplitter.this.myDivider).processMouseEvent(event);
                    }
                }
            };
            ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.addMouseListener((MouseListener)this.myMouseListener);
            ((SplitterWithSecondHideable)SplitterWithSecondHideable.this).myTitledSeparator.mySeparator.addMouseMotionListener((MouseMotionListener)this.myMouseListener);
        }

        protected Divider createDivider() {
            MyDivider divider = new MyDivider();
            divider.add(SplitterWithSecondHideable.this.myTitledSeparator, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
            return divider;
        }

        public int getDividerWidth() {
            return this.isVertical() ? SplitterWithSecondHideable.this.myTitledSeparator.getHeight() : SplitterWithSecondHideable.this.myTitledSeparator.getWidth();
        }

        private class MyDivider
        extends Splitter.DividerImpl {
            private MyDivider() {
                super((Splitter)MySplitter.this);
            }

            public void processMouseMotionEvent(MouseEvent e) {
                super.processMouseMotionEvent(e);
            }

            public void processMouseEvent(MouseEvent e) {
                super.processMouseEvent(e);
            }
        }
    }

    private class MyTitledSeparator
    extends AbstractTitledSeparatorWithIcon {
        MyTitledSeparator(String separatorText, boolean vertical) {
            super(AllIcons.General.ArrowRight, vertical ? AllIcons.General.ArrowDownSmall : (Icon)ObjectUtils.assertNotNull((Object)IconLoader.getDisabledIcon((Icon)AllIcons.General.ArrowRight)), separatorText);
        }

        @Override
        protected RefreshablePanel createPanel() {
            return SplitterWithSecondHideable.this.createDetails();
        }

        @Override
        protected void initOnImpl() {
            float proportion = SplitterWithSecondHideable.this.myPreviousProportion > 0.0f ? SplitterWithSecondHideable.this.myPreviousProportion : SplitterWithSecondHideable.this.getSplitterInitialProportion();
            SplitterWithSecondHideable.this.mySplitter.setSecondComponent((JComponent)this.myDetailsComponent.getPanel());
            SplitterWithSecondHideable.this.mySplitter.setResizeEnabled(true);
            SwingUtilities.invokeLater(() -> {
                SplitterWithSecondHideable.this.mySplitter.fixFirst(proportion);
                SplitterWithSecondHideable.this.mySplitter.invalidate();
                SplitterWithSecondHideable.this.mySplitter.validate();
                SplitterWithSecondHideable.this.mySplitter.repaint();
            });
        }

        @Override
        protected void onImpl() {
            float proportion = SplitterWithSecondHideable.this.myPreviousProportion > 0.0f ? SplitterWithSecondHideable.this.myPreviousProportion : SplitterWithSecondHideable.this.getSplitterInitialProportion();
            int firstSize = SplitterWithSecondHideable.this.mySplitter.isVertical() ? SplitterWithSecondHideable.this.mySplitter.getFirstComponent().getHeight() : SplitterWithSecondHideable.this.mySplitter.getFirstComponent().getWidth();
            SplitterWithSecondHideable.this.mySplitter.fixFirst();
            SplitterWithSecondHideable.this.myListener.on((int)((1.0f - proportion) * (float)firstSize / proportion));
            SplitterWithSecondHideable.this.mySplitter.setSecondComponent((JComponent)this.myDetailsComponent.getPanel());
            SplitterWithSecondHideable.this.mySplitter.revalidate();
            SplitterWithSecondHideable.this.mySplitter.repaint();
            SplitterWithSecondHideable.this.mySplitter.setResizeEnabled(true);
        }

        @Override
        protected void offImpl() {
            int previousSize = SplitterWithSecondHideable.this.mySplitter.isVertical() ? SplitterWithSecondHideable.this.mySplitter.getSecondComponent().getHeight() : SplitterWithSecondHideable.this.mySplitter.getSecondComponent().getWidth();
            SplitterWithSecondHideable.this.mySplitter.setSecondComponent((JComponent)SplitterWithSecondHideable.this.myFictivePanel);
            SplitterWithSecondHideable.this.myPreviousProportion = SplitterWithSecondHideable.this.mySplitter.getProportion();
            SplitterWithSecondHideable.this.mySplitter.freeAll();
            SplitterWithSecondHideable.this.mySplitter.setProportion(1.0f);
            SplitterWithSecondHideable.this.mySplitter.revalidate();
            SplitterWithSecondHideable.this.mySplitter.repaint();
            SplitterWithSecondHideable.this.myListener.off(previousSize);
            SplitterWithSecondHideable.this.mySplitter.setResizeEnabled(false);
        }
    }

    public static interface OnOffListener<T> {
        public void on(T var1);

        public void off(T var1);
    }
}

