/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.function.Function;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwingActionDelegate
extends AnAction
implements DumbAware {
    private static final Key<Function<String, JComponent>> FUNCTION = Key.create((String)"SwingActionsMapping");
    private final String mySwingActionId;

    protected SwingActionDelegate(String actionId) {
        this.setEnabledInModalContext(true);
        this.mySwingActionId = actionId;
    }

    protected JComponent getComponent(AnActionEvent event) {
        JComponent component = (JComponent)UIUtil.getParentOfType(JComponent.class, (Component)((Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT)));
        Function function = (Function)UIUtil.getClientProperty((Object)component, FUNCTION);
        return function == null ? component : (JComponent)function.apply(this.mySwingActionId);
    }

    public final void update(@NotNull AnActionEvent event) {
        event.getPresentation().setEnabled(null != this.getSwingAction(this.getComponent(event)));
    }

    public final void actionPerformed(@NotNull AnActionEvent event) {
        JComponent component = this.getComponent(event);
        Action action = this.getSwingAction(component);
        if (action != null) {
            action.actionPerformed(new ActionEvent(component, 1001, this.mySwingActionId));
        }
    }

    private Action getSwingAction(JComponent component) {
        if (component == null) {
            return null;
        }
        ActionMap map2 = component.getActionMap();
        return map2 == null ? null : map2.get(this.mySwingActionId);
    }

    @ApiStatus.Experimental
    public static void configureMapping(@NotNull JComponent component, @Nullable Function<String, JComponent> mapping) {
        component.putClientProperty(FUNCTION, mapping);
    }

    @ApiStatus.Experimental
    public static void configureMapping(@NotNull JComponent base, @NotNull JComponent dependant, String ... actions) {
        HashMap<String, JComponent> map2 = new HashMap<String, JComponent>();
        for (String action : actions) {
            map2.put(action, dependant);
        }
        SwingActionDelegate.configureMapping(base, map2::get);
    }

    @ApiStatus.Experimental
    public static void disableFor(@NotNull JComponent component) {
        SwingActionDelegate.configureMapping(component, action -> null);
    }
}

