/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SystemNotificationsImpl;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SystemTrayNotifications
implements SystemNotificationsImpl.Notifier {
    private static SystemTrayNotifications ourWin10Instance;
    private final TrayIcon myTrayIcon;
    private final TrayIcon.MessageType myType;

    private SystemTrayNotifications(@NotNull Image image, @NotNull TrayIcon.MessageType type) throws AWTException {
        this.myType = type;
        this.myTrayIcon = new TrayIcon(image);
        SystemTray.getSystemTray().add(this.myTrayIcon);
    }

    @Nullable
    static synchronized SystemTrayNotifications getWin10Instance() throws AWTException {
        if (ourWin10Instance != null) {
            return ourWin10Instance;
        }
        if (SystemTray.isSupported()) {
            ourWin10Instance = new SystemTrayNotifications(new BufferedImage(16, 16, 2), TrayIcon.MessageType.INFO);
            return ourWin10Instance;
        }
        return null;
    }

    @Override
    public void notify(@NotNull String name, @NotNull String title, @NotNull String description) {
        this.myTrayIcon.displayMessage(title, description, this.myType);
    }
}

