/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.textCompletion.TextCompletionUtil;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithAutoCompletion<T>
extends TextFieldWithCompletion {
    public static final TextFieldWithAutoCompletionListProvider EMPTY_COMPLETION = new StringsCompletionProvider(null, null);
    @NotNull
    private final TextFieldWithAutoCompletionListProvider<T> myProvider;

    public TextFieldWithAutoCompletion(@Nullable Project project, @NotNull TextFieldWithAutoCompletionListProvider<T> provider, boolean showCompletionHint, @Nullable String text) {
        super(project, provider, text == null ? "" : text, true, true, false, showCompletionHint);
        this.myProvider = provider;
    }

    @NotNull
    public static TextFieldWithAutoCompletion<String> create(@Nullable Project project, @NotNull Collection<String> items, boolean showCompletionHint, @Nullable String text) {
        return TextFieldWithAutoCompletion.create(project, items, null, showCompletionHint, text);
    }

    @NotNull
    public static TextFieldWithAutoCompletion<String> create(@Nullable Project project, @NotNull Collection<String> items, @Nullable Icon icon, boolean showCompletionHint, @Nullable String text) {
        return new TextFieldWithAutoCompletion<String>(project, new StringsCompletionProvider(items, icon), showCompletionHint, text);
    }

    public void setVariants(@NotNull Collection<T> variants) {
        this.myProvider.setItems(variants);
    }

    public <T> void installProvider(@NotNull TextFieldWithAutoCompletionListProvider<T> provider) {
        TextFieldWithAutoCompletion.installCompletion(this.getDocument(), this.getProject(), provider, true);
    }

    public static void installCompletion(@NotNull Document document, @NotNull Project project, @NotNull TextFieldWithAutoCompletionListProvider provider, boolean autoPopup) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile != null) {
            TextCompletionUtil.installProvider(psiFile, provider, autoPopup);
        }
    }

    public static class StringsCompletionProvider
    extends TextFieldWithAutoCompletionListProvider<String>
    implements DumbAware {
        @Nullable
        private final Icon myIcon;

        public StringsCompletionProvider(@Nullable Collection<String> variants, @Nullable Icon icon) {
            super(variants);
            this.myIcon = icon;
        }

        @Override
        public int compare(String item1, String item2) {
            return StringUtil.compare((String)item1, (String)item2, (boolean)false);
        }

        @Override
        protected Icon getIcon(@NotNull String item) {
            return this.myIcon;
        }

        @Override
        @NotNull
        protected String getLookupString(@NotNull String item) {
            return item;
        }
    }
}

