/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SliderSelectorAction
extends DumbAwareAction {
    @NotNull
    private final Configuration myConfiguration;

    public SliderSelectorAction(@Nullable String text, @Nullable String description, @Nullable Icon icon, @NotNull Configuration configuration2) {
        super(text, description, icon);
        this.myConfiguration = configuration2;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        String tooltip = this.myConfiguration.getTooltip();
        if (tooltip != null) {
            e.getPresentation().setText(this.getTemplatePresentation().getText() + " (" + tooltip + ")");
            e.getPresentation().setDescription(this.getTemplatePresentation().getDescription() + " (" + tooltip + ")");
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        JPanel result2 = new JPanel(new BorderLayout());
        JLabel label2 = new JLabel(this.myConfiguration.getSelectText());
        label2.setBorder(BorderFactory.createEmptyBorder(4, 4, 0, 0));
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)label2, "North");
        Dictionary dictionary = this.myConfiguration.getDictionary();
        final Enumeration elements = dictionary.elements();
        JSlider slider = new JSlider(0, this.myConfiguration.getMin(), this.myConfiguration.getMax(), this.myConfiguration.getSelected()){
            Integer myWidth;
            {
                super(x0, x1, x2, x3);
                this.myWidth = null;
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                if (this.myWidth == null) {
                    this.myWidth = 10;
                    FontMetrics fm = this.getFontMetrics(this.getFont());
                    while (elements.hasMoreElements()) {
                        String text = ((JLabel)elements.nextElement()).getText();
                        this.myWidth = this.myWidth + fm.stringWidth(text + "W");
                    }
                }
                return new Dimension(this.myWidth, size.height);
            }
        };
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        slider.setSnapToTicks(true);
        UIUtil.setSliderIsFilled((JSlider)slider, (boolean)true);
        slider.setPaintLabels(true);
        slider.setLabelTable(dictionary);
        if (!this.myConfiguration.isShowOk()) {
            result2.add((Component)wrapper2, "West");
            result2.add((Component)slider, "Center");
        } else {
            result2.add((Component)wrapper2, "West");
            result2.add((Component)slider, "Center");
        }
        final Runnable saveSelection = () -> {
            int value = slider.getModel().getValue();
            this.myConfiguration.getResultConsumer().consume((Object)value);
        };
        final Ref popupRef = new Ref(null);
        final JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)result2, (JComponent)slider).setMovable(true).setCancelOnWindowDeactivation(true).setCancelKeyEnabled(this.myConfiguration.isShowOk()).setKeyboardActions(Collections.singletonList(Pair.create((Object)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                saveSelection.run();
                ((JBPopup)popupRef.get()).closeOk(null);
            }
        }, (Object)KeyStroke.getKeyStroke(10, 0)))).createPopup();
        popupRef.set((Object)popup2);
        if (this.myConfiguration.isShowOk()) {
            JButton done = new JButton("Done");
            JBPanel doneWrapper = new JBPanel((LayoutManager)new BorderLayout());
            doneWrapper.add((Component)done, (Object)"North");
            result2.add((Component)doneWrapper, "East");
            done.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    saveSelection.run();
                    popup2.closeOk(null);
                }
            });
        } else {
            popup2.setFinalRunnable(saveSelection);
        }
        InputEvent inputEvent = e.getInputEvent();
        this.show(e, result2, popup2, inputEvent);
    }

    protected void show(AnActionEvent e, JPanel result2, JBPopup popup2, InputEvent inputEvent) {
        if (inputEvent instanceof MouseEvent) {
            int width = result2.getPreferredSize().width;
            MouseEvent inputEvent1 = (MouseEvent)inputEvent;
            Point point1 = new Point(inputEvent1.getX() - width / 2, inputEvent1.getY());
            RelativePoint point = new RelativePoint(inputEvent1.getComponent(), point1);
            popup2.show(point);
        } else {
            popup2.showInBestPositionFor(e.getDataContext());
        }
    }

    public static class Configuration {
        @NotNull
        private final String mySelectText;
        @NotNull
        private final Dictionary myDictionary;
        private final int mySelected;
        private final int myMin;
        private final int myMax;
        @NotNull
        private final Consumer<Integer> myResultConsumer;
        private boolean showOk = false;

        public Configuration(int selected, @NotNull Dictionary dictionary, @NotNull String selectText, @NotNull Consumer<Integer> consumer) {
            this.mySelected = selected;
            this.myDictionary = new Hashtable();
            this.mySelectText = selectText;
            this.myResultConsumer = consumer;
            int min = 1;
            int max = 0;
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                Integer key = (Integer)keys.nextElement();
                String value = (String)dictionary.get(key);
                this.myDictionary.put(key, Configuration.markLabel(value));
                min = Math.min(min, key);
                max = Math.max(max, key);
            }
            this.myMin = min;
            this.myMax = max;
        }

        private static JLabel markLabel(String text) {
            JLabel label2 = new JLabel(text);
            label2.setFont(UIUtil.getLabelFont());
            return label2;
        }

        @NotNull
        public String getSelectText() {
            return this.mySelectText;
        }

        @NotNull
        public Dictionary getDictionary() {
            return this.myDictionary;
        }

        @NotNull
        public Consumer<Integer> getResultConsumer() {
            return this.myResultConsumer;
        }

        public int getSelected() {
            return this.mySelected;
        }

        public int getMin() {
            return this.myMin;
        }

        public int getMax() {
            return this.myMax;
        }

        public boolean isShowOk() {
            return this.showOk;
        }

        public void setShowOk(boolean showOk) {
            this.showOk = showOk;
        }

        public String getTooltip() {
            return null;
        }
    }
}

