/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class TabbedContentImpl
extends ContentImpl
implements TabbedContent {
    private final List<Pair<String, JComponent>> myTabs = new ArrayList<Pair<String, JComponent>>();
    @NotNull
    private String myPrefix;

    public TabbedContentImpl(JComponent component, @NotNull String displayName, boolean isPinnable, @NotNull String titlePrefix) {
        super(component, displayName, isPinnable);
        this.myPrefix = titlePrefix;
        this.addContent(component, displayName, true);
    }

    public void addContent(@NotNull JComponent content, @NotNull String name, boolean selectTab) {
        Pair tab = Pair.create((Object)name, (Object)content);
        if (!this.myTabs.contains(tab)) {
            this.myTabs.add((Pair<String, JComponent>)tab);
        }
        if (selectTab && this.getComponent() != content) {
            this.setComponent(content);
        }
    }

    @Override
    public void setComponent(JComponent component) {
        Container parent;
        JComponent currentComponent = this.getComponent();
        Container container = parent = currentComponent == null ? null : currentComponent.getParent();
        if (parent != null) {
            parent.remove(currentComponent);
            parent.add(component);
        }
        super.setComponent(component);
    }

    public void removeContent(@NotNull JComponent content) {
        int index;
        Pair<String, JComponent> toRemove2 = null;
        for (Pair<String, JComponent> tab : this.myTabs) {
            if (tab.second != content) continue;
            toRemove2 = tab;
            break;
        }
        if ((index = this.myTabs.indexOf(toRemove2)) != -1) {
            this.myTabs.remove(index);
            int n = index = index > 0 ? index - 1 : index;
            if (index < this.myTabs.size()) {
                this.selectContent(index);
            }
        }
    }

    @Override
    public String getDisplayName() {
        return this.getTabName();
    }

    public void selectContent(int index) {
        Pair<String, JComponent> tab = this.myTabs.get(index);
        this.setDisplayName((String)tab.first);
        this.setComponent((JComponent)tab.second);
    }

    public int getSelectedIndex() {
        JComponent selected = this.getComponent();
        for (int i = 0; i < this.myTabs.size(); ++i) {
            if (this.myTabs.get((int)i).second != selected) continue;
            return i;
        }
        return -1;
    }

    public boolean findAndSelectContent(@NotNull JComponent contentComponent) {
        String tabName = this.findTabNameByComponent(contentComponent);
        if (tabName != null) {
            this.setDisplayName(tabName);
            this.setComponent(contentComponent);
            return true;
        }
        return false;
    }

    @Override
    public String getTabName() {
        return this.myPrefix + ": " + this.findTabNameByComponent(this.getComponent());
    }

    private String findTabNameByComponent(JComponent c) {
        for (Pair<String, JComponent> tab : this.myTabs) {
            if (tab.second != c) continue;
            return (String)tab.first;
        }
        return null;
    }

    @NotNull
    public List<Pair<String, JComponent>> getTabs() {
        return Collections.unmodifiableList(this.myTabs);
    }

    public String getTitlePrefix() {
        return this.myPrefix;
    }

    public void setTitlePrefix(String titlePrefix) {
        this.myPrefix = titlePrefix;
    }

    public void split() {
        ArrayList<Pair<String, JComponent>> copy = new ArrayList<Pair<String, JComponent>>(this.myTabs);
        int selectedTab = ContentUtilEx.getSelectedTab(this);
        ContentManager manager = this.getManager();
        String prefix = this.getTitlePrefix();
        manager.removeContent((Content)this, false);
        PropertiesComponent.getInstance().setValue("tabbed.toolwindow.expanded." + prefix, Boolean.TRUE.toString());
        for (int i = 0; i < copy.size(); ++i) {
            boolean select = i == selectedTab;
            JComponent component = (JComponent)((Pair)copy.get((int)i)).second;
            String tabName = (String)((Pair)copy.get((int)i)).first;
            ContentUtilEx.addTabbedContent(manager, component, prefix, tabName, select);
        }
        Disposer.dispose((Disposable)this);
    }

    public boolean rename(@NotNull JComponent component, @NotNull String newName) {
        Pair tab = (Pair)ContainerUtil.find(this.myTabs, pair -> pair.second == component);
        if (tab == null) {
            return false;
        }
        if (newName.equals(tab.first)) {
            return true;
        }
        int index = this.myTabs.indexOf(tab);
        this.myTabs.set(index, (Pair<String, JComponent>)new Pair((Object)newName, (Object)component));
        if (this.getComponent() == component) {
            this.setDisplayName(newName);
        }
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myTabs.clear();
    }
}

