/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.tabs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.ShadowAction;
import com.intellij.ui.UIBundle;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import org.jetbrains.annotations.NotNull;

public abstract class TabbedContentAction
extends AnAction
implements DumbAware {
    protected final ContentManager myManager;
    protected final ShadowAction myShadow;

    protected TabbedContentAction(@NotNull ContentManager manager, @NotNull AnAction shortcutTemplate, @NotNull String text, @NotNull Disposable parentDisposable) {
        super(text);
        this.myManager = manager;
        this.myShadow = new ShadowAction((AnAction)this, shortcutTemplate, manager.getComponent(), new Presentation(text), parentDisposable);
    }

    protected TabbedContentAction(@NotNull ContentManager manager, @NotNull AnAction template, @NotNull Disposable parentDisposable) {
        this.myManager = manager;
        this.myShadow = new ShadowAction((AnAction)this, template, manager.getComponent(), parentDisposable);
    }

    public static class MyPreviousTabAction
    extends TabbedContentAction {
        public MyPreviousTabAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("PreviousTab"), (Disposable)manager);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myManager.selectPreviousContent();
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(this.myManager.getContentCount() > 1);
            e.getPresentation().setText(this.myManager.getPreviousContentActionName());
        }
    }

    public static class MyNextTabAction
    extends TabbedContentAction {
        public MyNextTabAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("NextTab"), (Disposable)manager);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myManager.selectNextContent();
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabledAndVisible(this.myManager.getContentCount() > 1);
            e.getPresentation().setText(this.myManager.getNextContentActionName());
        }
    }

    public static class CloseAllAction
    extends TabbedContentAction {
        public CloseAllAction(ContentManager manager) {
            super(manager, ActionManager.getInstance().getAction("CloseAllEditors"), UIBundle.message((String)"tabbed.pane.close.all.action.name", (Object[])new Object[0]), (Disposable)manager);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Content[] contents;
            for (Content content : contents = this.myManager.getContents()) {
                if (!content.isCloseable()) continue;
                this.myManager.removeContent(content, true);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(this.myManager.getContentCount() > 1 && this.myManager.canCloseAllContents());
        }
    }

    public static class CloseAllButThisAction
    extends ForContent {
        public CloseAllButThisAction(@NotNull Content content) {
            super(content, ActionManager.getInstance().getAction("CloseAllEditorsButActive"), UIBundle.message((String)"tabbed.pane.close.all.but.this.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Content[] contents;
            for (Content content : contents = this.myManager.getContents()) {
                if (this.myContent == content || !content.isCloseable()) continue;
                this.myManager.removeContent(content, true);
            }
            this.myManager.setSelectedContent(this.myContent);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setText(this.myManager.getCloseAllButThisActionName());
            presentation.setEnabledAndVisible(this.myManager.canCloseContents() && this.hasOtherCloseableContents());
        }

        private boolean hasOtherCloseableContents() {
            Content[] contents;
            for (Content content : contents = this.myManager.getContents()) {
                if (this.myContent == content || !content.isCloseable()) continue;
                return true;
            }
            return false;
        }
    }

    public static class CloseAction
    extends ForContent {
        public CloseAction(@NotNull Content content) {
            super(content, ActionManager.getInstance().getAction("CloseActiveTab"));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myManager.removeContent(this.myContent, true);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabledAndVisible(this.myManager.canCloseContents() && this.myContent.isCloseable());
            presentation.setText(this.myManager.getCloseActionName());
        }
    }

    public static abstract class ForContent
    extends TabbedContentAction {
        @NotNull
        protected final Content myContent;

        public ForContent(@NotNull Content content, @NotNull AnAction shortcutTemplate, String text) {
            super(content.getManager(), shortcutTemplate, text, (Disposable)content);
            this.myContent = content;
        }

        public ForContent(@NotNull Content content, AnAction template) {
            super(content.getManager(), template, (Disposable)content);
            this.myContent = content;
        }

        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setEnabled(this.myManager.getIndexOfContent(this.myContent) >= 0);
        }
    }
}

