/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.ui.mac.touchbar.BarType;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import java.awt.Component;
import java.awt.Container;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BarContainer {
    @NotNull
    private final BarType myType;
    private final Container myParentComponent;
    private Map<Long, TouchBar> myKeyMask2Alt;
    @NotNull
    private TouchBar myMain;
    private TouchBar myCurrent;
    private Runnable myOnHideCallback;

    BarContainer(@NotNull BarType type, @NotNull TouchBar main, Map<Long, TouchBar> alts, Container parentComponent) {
        this.myParentComponent = parentComponent;
        this.myMain = main;
        this.myType = type;
        this.myKeyMask2Alt = alts;
        this._updateTouchBarsParents();
    }

    public String toString() {
        return this.myMain.toString();
    }

    void set(@NotNull TouchBar main, Map<Long, TouchBar> alts) {
        this.myMain = main;
        this.myKeyMask2Alt = alts;
        this.myCurrent = null;
        this._updateTouchBarsParents();
    }

    void selectBarByKeyMask(long keyMask) {
        TouchBar alt;
        if (keyMask == 0L) {
            this.myCurrent = this.myMain;
            return;
        }
        TouchBar touchBar = alt = this.myKeyMask2Alt == null ? null : this.myKeyMask2Alt.get(keyMask);
        if (alt != null) {
            this.myCurrent = alt;
        }
    }

    @NotNull
    TouchBar getMain() {
        return this.myMain;
    }

    TouchBar get() {
        if (this.myCurrent == null) {
            this.myCurrent = this.myMain;
        }
        return this.myCurrent;
    }

    void show() {
        TouchBarsManager.showContainer(this);
    }

    void hide() {
        TouchBarsManager.hideContainer(this);
    }

    @NotNull
    BarType getType() {
        return this.myType;
    }

    boolean isPopup() {
        return this.myType == BarType.POPUP;
    }

    boolean isDialog() {
        return this.myType == BarType.DIALOG || this.myType == BarType.MODAL_DIALOG;
    }

    boolean isNonModalDialog() {
        return this.myType == BarType.DIALOG;
    }

    boolean isModalDialog() {
        return this.myType == BarType.MODAL_DIALOG;
    }

    void setOnHideCallback(Runnable onHideCallback) {
        this.myOnHideCallback = onHideCallback;
    }

    void onHide() {
        if (this.myOnHideCallback != null) {
            this.myOnHideCallback.run();
        }
    }

    void setComponent(Component component) {
        this.myMain.setComponent(component);
        if (this.myKeyMask2Alt != null) {
            this.myKeyMask2Alt.values().forEach(tb -> tb.setComponent(component));
        }
    }

    void setOptionalContextActions(@Nullable ActionGroup actions, @NotNull String contextName) {
        if (actions == null) {
            this.myMain.removeOptionalContextItems(contextName);
        } else {
            this.myMain.setOptionalContextItems(actions, contextName);
        }
    }

    void setOptionalContextVisible(@Nullable String contextName) {
        this.myMain.setOptionalContextVisible(contextName);
    }

    Container getParentComponent() {
        return this.myParentComponent;
    }

    void release() {
        this.myMain.release();
        if (this.myKeyMask2Alt != null) {
            this.myKeyMask2Alt.forEach((mask, bar) -> bar.release());
        }
        this.myKeyMask2Alt = null;
        this.myMain = TouchBar.EMPTY;
    }

    private void _updateTouchBarsParents() {
        this.myMain.setBarContainer(this);
        if (this.myKeyMask2Alt != null && !this.myKeyMask2Alt.isEmpty()) {
            this.myKeyMask2Alt.values().forEach(tb -> tb.setBarContainer(this));
        }
    }
}

