/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import com.intellij.ui.mac.touchbar.SpacingItem;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBItemButton;
import com.intellij.ui.mac.touchbar.TBItemGroup;
import com.intellij.ui.mac.touchbar.TBItemPopover;
import com.intellij.ui.mac.touchbar.TBItemScrubber;
import com.intellij.ui.mac.touchbar.TouchBar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ItemsContainer {
    @NotNull
    private final String myName;
    @Nullable
    private final ItemListener myListener;
    @NotNull
    private final List<TBItem> myItems = new ArrayList<TBItem>();
    private long myCounter = 0L;

    ItemsContainer(@NotNull String name, @Nullable ItemListener listener2) {
        this.myName = name;
        this.myListener = listener2;
    }

    boolean isEmpty() {
        return this.myItems.isEmpty();
    }

    boolean hasAnActionItems() {
        return this.anyMatchDeep(item -> item instanceof TBItemAnActionButton);
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    TBItemButton addButton() {
        TBItemButton butt = new TBItemButton(this._genNewID("button"), this.myListener);
        this.myItems.add(butt);
        return butt;
    }

    @NotNull
    TBItemAnActionButton addAnActionButton(@NotNull AnAction act, @Nullable TBItem positionAnchor) {
        String actId = ApplicationManager.getApplication() != null ? ActionManager.getInstance().getId(act) : act.toString();
        String uid = String.format("%s.anActionButton.%d.%s", this.myName, this.myCounter++, actId);
        TBItemAnActionButton butt = new TBItemAnActionButton(uid, this.myListener, act);
        if (positionAnchor != null) {
            int index = this.myItems.indexOf(positionAnchor);
            if (index >= 0 && index < this.myItems.size()) {
                this.myItems.add(index, butt);
            } else {
                this.myItems.add(butt);
            }
        } else {
            this.myItems.add(butt);
        }
        return butt;
    }

    @NotNull
    TBItemAnActionButton addAnActionButton(@NotNull AnAction act) {
        return this.addAnActionButton(act, null);
    }

    @NotNull
    TBItemGroup addGroup() {
        TBItemGroup group = new TBItemGroup(this._genNewID("group"), this.myListener);
        this.myItems.add(group);
        return group;
    }

    @NotNull
    TBItemPopover addPopover(Icon icon, String text, int width, TouchBar expandTB, TouchBar tapAndHoldTB) {
        TBItemPopover popover = new TBItemPopover(this._genNewID("popover"), this.myListener, icon, text, width, expandTB, tapAndHoldTB);
        this.myItems.add(popover);
        return popover;
    }

    @NotNull
    TBItemScrubber addScrubber() {
        int defaultScrubberWidth = 500;
        TBItemScrubber scrubber = new TBItemScrubber(this._genNewID("scrubber"), this.myListener, 500);
        this.myItems.add(scrubber);
        return scrubber;
    }

    void addSpacing(boolean large) {
        SpacingItem spacing = new SpacingItem(large ? "static_touchbar_item_large_space" : "static_touchbar_item_small_space");
        this.myItems.add(spacing);
    }

    void addFlexibleSpacing() {
        SpacingItem spacing = new SpacingItem("static_touchbar_item_flexible_space");
        this.myItems.add(spacing);
    }

    void releaseAll() {
        this.myItems.forEach(item -> item.releaseNativePeer());
        this.myItems.clear();
    }

    void remove(@Nullable Predicate<TBItem> filter) {
        if (filter == null) {
            this.releaseAll();
            return;
        }
        Iterator<TBItem> i = this.myItems.iterator();
        while (i.hasNext()) {
            TBItem item = i.next();
            boolean removeGroup = false;
            if (item instanceof TBItemGroup) {
                ItemsContainer group = ((TBItemGroup)item).getContainer();
                group.remove(filter);
                if (group.isEmpty()) {
                    removeGroup = true;
                }
            }
            if (!removeGroup && !filter.test(item)) continue;
            item.releaseNativePeer();
            i.remove();
        }
    }

    @NotNull
    String[] getVisibleIds() {
        String[] ids = new String[this.myItems.size()];
        int c = 0;
        for (TBItem item : this.myItems) {
            if (!item.myIsVisible) continue;
            ids[c++] = item.myUid;
        }
        return c == this.myItems.size() ? ids : Arrays.copyOf(ids, c);
    }

    @NotNull
    ID[] getVisibleNativePeers() {
        ID[] ids = new ID[this.myItems.size()];
        int c = 0;
        for (TBItem item : this.myItems) {
            if (!item.myIsVisible || ID.NIL.equals((Object)item.getNativePeer())) continue;
            ids[c++] = item.getNativePeer();
        }
        return c == this.myItems.size() ? ids : Arrays.copyOf(ids, c);
    }

    void forEachDeep(Consumer<? super TBItem> proc) {
        this.myItems.forEach(item -> {
            if (item instanceof TBItemGroup) {
                ((TBItemGroup)item).getContainer().forEachDeep(proc);
                return;
            }
            proc.accept((TBItem)item);
        });
    }

    boolean anyMatchDeep(Predicate<? super TBItem> proc) {
        return this.myItems.stream().anyMatch(item -> {
            if (item instanceof TBItemGroup) {
                return ((TBItemGroup)item).getContainer().anyMatchDeep(proc);
            }
            return proc.test((TBItem)item);
        });
    }

    int releaseItems(Predicate<? super TBItem> proc) {
        Iterator<TBItem> i = this.myItems.iterator();
        int count = 0;
        while (i.hasNext()) {
            TBItem tbi = i.next();
            if (!proc.test(tbi)) continue;
            ++count;
            i.remove();
            tbi.releaseNativePeer();
        }
        return count;
    }

    @Nullable
    TBItem findItem(String uid) {
        for (TBItem item : this.myItems) {
            if (!item.myUid.equals(uid)) continue;
            return item;
        }
        return null;
    }

    @NotNull
    private String _genNewID(String desc) {
        return String.format("%s.%s.%d", this.myName, desc, this.myCounter++);
    }
}

