/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.ItemListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TBItem {
    @NotNull
    final String myUid;
    @Nullable
    final ItemListener myListener;
    @NotNull
    ID myNativePeer = ID.NIL;
    boolean myIsVisible = true;
    @Nullable
    String myOptionalContextName;

    TBItem(@NotNull String uid, ItemListener listener2) {
        this.myUid = uid;
        this.myListener = listener2;
    }

    public String toString() {
        return this.myUid;
    }

    ID getNativePeer() {
        if (this.myNativePeer == ID.NIL) {
            this.myNativePeer = this._createNativePeer();
        }
        return this.myNativePeer;
    }

    final void updateNativePeer() {
        if (this.myNativePeer == ID.NIL) {
            return;
        }
        this._updateNativePeer();
    }

    void releaseNativePeer() {
        if (this.myNativePeer == ID.NIL) {
            return;
        }
        Foundation.invoke((ID)this.myNativePeer, (String)"release", (Object[])new Object[0]);
        this.myNativePeer = ID.NIL;
    }

    protected abstract void _updateNativePeer();

    protected abstract ID _createNativePeer();
}

