/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.touchbar.BarContainer;
import com.intellij.ui.mac.touchbar.BarType;
import com.intellij.ui.mac.touchbar.BuildUtils;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.ProjectData;
import com.intellij.ui.mac.touchbar.StackTouchBars;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.Utils;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.InputEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TouchBarsManager {
    private static final Logger LOG = Logger.getInstance(TouchBarsManager.class);
    private static final StackTouchBars ourStack = new StackTouchBars();
    private static final Map<Project, ProjectData> ourProjectData = new HashMap<Project, ProjectData>();
    private static final Map<Container, BarContainer> ourTemporaryBars = new HashMap<Container, BarContainer>();
    private static final String RUNNERS_GROUP_TOUCHBAR = "RunnerActionsTouchbar";

    public static void onApplicationInitialized() {
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectOpened(final @NotNull Project project) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                final ProjectData pd = new ProjectData(project);
                Map map2 = ourProjectData;
                synchronized (map2) {
                    ProjectData prev2 = ourProjectData.put(project, pd);
                    if (prev2 != null) {
                        LOG.error("previous project data wasn't removed: " + project);
                        prev2.releaseAll();
                    }
                }
                StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> pd.get(BarType.DEFAULT).show());
                project.getMessageBus().connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

                    public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                        ApplicationManager.getApplication().invokeLater(() -> TouchBarsManager._updateCurrentTouchbar());
                    }

                    public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                        String twid = env.getExecutor().getToolWindowId();
                        ourStack.pop((Condition<BarContainer>)((Condition)topContainer -> {
                            if (topContainer.getType() != BarType.DEBUGGER) {
                                return false;
                            }
                            if (!ToolWindowId.DEBUG.equals(twid) && !ToolWindowId.RUN_DASHBOARD.equals(twid)) {
                                return false;
                            }
                            return !TouchBarsManager._hasAnyActiveSession(project, handler2) || pd.getDbgSessions() <= 0;
                        }));
                        ApplicationManager.getApplication().invokeLater(() -> TouchBarsManager._updateCurrentTouchbar());
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosed(@NotNull Project project) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                Map map2 = ourProjectData;
                synchronized (map2) {
                    ProjectData pd = (ProjectData)ourProjectData.remove(project);
                    if (pd == null) {
                        LOG.error("project data already was removed: " + project);
                        return;
                    }
                    ourStack.removeAll(pd.getAllContainers());
                    pd.releaseAll();
                }
            }
        });
        TouchBarsManager._initExecutorsGroup();
    }

    public static boolean isTouchBarAvailable() {
        return NST.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadAll() {
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            ourProjectData.forEach((p, pd) -> pd.reloadAll());
        }
        ourStack.setTouchBarFromTopContainer();
    }

    public static void onInputEvent(InputEvent e) {
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        if (e instanceof MouseWheelEvent) {
            return;
        }
        ourStack.updateKeyMask((long)e.getModifiersEx() & ProjectData.getUsedKeyMask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onFocusEvent(AWTEvent e) {
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        if (!(e.getSource() instanceof Container)) {
            return;
        }
        Container src = (Container)e.getSource();
        if (e.getID() == 1004) {
            Object barForParent;
            if (TouchBarsManager._hasPopup()) {
                return;
            }
            if (TouchBarsManager._hasNonModalDialog() && (barForParent = TouchBarsManager._findByParentComponent(src, ourTemporaryBars.values(), null)) != null) {
                ((BarContainer)barForParent).show();
                return;
            }
            barForParent = ourProjectData;
            synchronized (barForParent) {
                for (ProjectData pd : ourProjectData.values()) {
                    if (pd.isDisposed()) continue;
                    if (pd.checkToolWindowContents(src)) {
                        return;
                    }
                    ProjectData.EditorData ed = pd.findEditorDataByComponent(src);
                    if (ed != null && ed.containerSearch != null) {
                        ourStack.showContainer(ed.containerSearch);
                        return;
                    }
                    BarContainer twbc = pd.findDebugToolWindowByComponent(src);
                    if (twbc == null) continue;
                    ourStack.showContainer(twbc);
                    return;
                }
            }
        }
        if (e.getID() == 1005) {
            BarContainer nonModalDialogParent = TouchBarsManager._findByParentComponent(src, ourTemporaryBars.values(), (Predicate<? super BarContainer>)((Predicate)bc -> bc.isNonModalDialog()));
            if (nonModalDialogParent != null) {
                nonModalDialogParent.hide();
                return;
            }
            Map<Project, ProjectData> map2 = ourProjectData;
            synchronized (map2) {
                for (ProjectData pd : ourProjectData.values()) {
                    ProjectData.EditorData ed;
                    if (pd.isDisposed() || (ed = pd.findEditorDataByComponent(src)) == null || ed.containerSearch == null) continue;
                    ourStack.removeContainer(ed.containerSearch);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEditor(@NotNull Editor editor) {
        ProjectData pd;
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        Project proj = editor.getProject();
        if (proj == null || proj.isDisposed()) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            pd = ourProjectData.get(proj);
            if (pd == null) {
                return;
            }
            pd.registerEditor(editor);
        }
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).addFocusListener(new FocusChangeListener(){

                @Override
                public void focusGained(@NotNull Editor editor) {
                    boolean hasDebugSession;
                    pd.get(BarType.DEFAULT).setOptionalContextVisible(null);
                    boolean bl = hasDebugSession = pd.getDbgSessions() > 0;
                    if (!hasDebugSession) {
                        ourStack.elevateContainer(pd.get(BarType.DEFAULT));
                    }
                }

                @Override
                public void focusLost(@NotNull Editor editor) {
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseEditor(@NotNull Editor editor) {
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        Project proj = editor.getProject();
        if (proj == null) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            ProjectData pd = ourProjectData.get(proj);
            if (pd == null) {
                return;
            }
            pd.removeEditor(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onUpdateEditorHeader(@NotNull Editor editor, JComponent header) {
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return;
        }
        Project proj = editor.getProject();
        if (proj == null) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            ActionGroup actions;
            ProjectData pd = ourProjectData.get(proj);
            if (pd == null) {
                LOG.error("can't find project data to update header of editor: " + editor + ", project: " + proj);
                return;
            }
            ProjectData.EditorData ed = pd.getEditorData(editor);
            if (ed == null) {
                LOG.error("can't find editor-data to update header of editor: " + editor + ", project: " + proj);
                return;
            }
            ActionGroup actionGroup = actions = header instanceof DataProvider ? (ActionGroup)TouchbarDataKeys.ACTIONS_KEY.getData((DataProvider)header) : null;
            if (header == null) {
                ed.editorHeader = null;
                if (ed.containerSearch != null) {
                    ourStack.removeContainer(ed.containerSearch);
                }
            } else {
                ed.editorHeader = header;
                if (ed.containerSearch == null || ed.actionsSearch != actions) {
                    if (ed.containerSearch != null) {
                        ourStack.removeContainer(ed.containerSearch);
                        ed.containerSearch.release();
                    }
                    if (actions != null) {
                        ed.containerSearch = new BarContainer(BarType.EDITOR_SEARCH, TouchBar.buildFromGroup("editor_search_" + header, actions, true, true), null, header);
                        ourStack.showContainer(ed.containerSearch);
                    }
                }
            }
        }
    }

    @Nullable
    public static Disposable showPopupBar(@NotNull JBPopup popup2, @NotNull JComponent popupComponent) {
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return null;
        }
        if (!(popup2 instanceof ListPopupImpl)) {
            return null;
        }
        ListPopupImpl listPopup = (ListPopupImpl)popup2;
        TouchBar tb = BuildUtils.createScrubberBarFromPopup(listPopup);
        BarContainer container = new BarContainer(BarType.POPUP, tb, null, popupComponent);
        ourTemporaryBars.put(popupComponent, container);
        ourStack.showContainer(container);
        return () -> {
            ourStack.removeContainer(container);
            ourTemporaryBars.remove(popupComponent);
            container.release();
        };
    }

    @Nullable
    public static Disposable showDialogWrapperButtons(@NotNull Container contentPane) {
        if (!TouchBarsManager.isTouchBarAvailable()) {
            return null;
        }
        ModalityState ms = Utils.getCurrentModalityState();
        BarType btype = ModalityState.NON_MODAL.equals(ms) ? BarType.DIALOG : BarType.MODAL_DIALOG;
        BarContainer bc = null;
        TouchBar tb = null;
        HashMap<TouchbarDataKeys.DlgButtonDesc, JButton> jbuttons = new HashMap<TouchbarDataKeys.DlgButtonDesc, JButton>();
        HashMap<Component, ActionGroup> actions = new HashMap<Component, ActionGroup>();
        TouchBarsManager._findAllTouchbarProviders(actions, jbuttons, contentPane);
        if (jbuttons.isEmpty() && actions.isEmpty()) {
            return null;
        }
        boolean replaceEsc = false;
        boolean emulateEsc = false;
        if (!actions.isEmpty()) {
            ActionGroup ag = (ActionGroup)actions.values().iterator().next();
            TouchbarDataKeys.ActionDesc groupDesc = (TouchbarDataKeys.ActionDesc)ag.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
            replaceEsc = groupDesc == null || groupDesc.isReplaceEsc();
            emulateEsc = true;
        }
        tb = new TouchBar("dialog_buttons", replaceEsc, false, emulateEsc);
        BuildUtils.addDialogButtons(tb, jbuttons, actions);
        bc = new BarContainer(btype, tb, null, contentPane);
        ourTemporaryBars.put(contentPane, bc);
        ourStack.showContainer(bc);
        BarContainer fbc = bc;
        return () -> {
            ourTemporaryBars.remove(contentPane);
            ourStack.removeContainer(fbc);
            fbc.release();
        };
    }

    public static void showStopRunningBar(List<? extends Pair<RunContentDescriptor, Runnable>> stoppableDescriptors) {
        TouchBar tb = BuildUtils.createStopRunningBar(stoppableDescriptors);
        BarContainer container = new BarContainer(BarType.DIALOG, tb, null, null);
        container.setOnHideCallback(() -> container.release());
        ourStack.showContainer(container);
    }

    static void showContainer(@NotNull BarContainer container) {
        ourStack.showContainer(container);
    }

    static void hideContainer(@NotNull BarContainer container) {
        ourStack.removeContainer(container);
    }

    private static boolean _hasAnyActiveSession(Project proj, ProcessHandler handler2) {
        ProcessHandler[] processes = ExecutionManager.getInstance((Project)proj).getRunningProcesses();
        return Arrays.stream(processes).anyMatch(h -> h != null && h != handler2 && !h.isProcessTerminated() && !h.isProcessTerminating());
    }

    private static boolean _hasPopup() {
        return ourTemporaryBars.values().stream().anyMatch(bc -> bc.isPopup());
    }

    private static boolean _hasNonModalDialog() {
        return ourTemporaryBars.values().stream().anyMatch(bc -> bc.isNonModalDialog());
    }

    private static BarContainer _findByParentComponent(Container child2, Collection<? extends BarContainer> candidates, Predicate<? super BarContainer> filter) {
        for (BarContainer barContainer : candidates) {
            if (filter != null && !filter.apply((Object)barContainer) || barContainer.getParentComponent() == null || !SwingUtilities.isDescendingFrom(child2, barContainer.getParentComponent())) continue;
            return barContainer;
        }
        return null;
    }

    private static void _findAllTouchbarProviders(@NotNull Map<Component, ActionGroup> out, @NotNull Map<TouchbarDataKeys.DlgButtonDesc, JButton> out2, @NotNull Container root) {
        JBIterable iter = ((JBTreeTraverser)UIUtil.uiTraverser((Component)root).expandAndFilter(c -> c.isVisible())).traverse();
        for (Component component : iter) {
            ActionGroup actions;
            TouchbarDataKeys.DlgButtonDesc desc;
            if (component instanceof JButton && (desc = (TouchbarDataKeys.DlgButtonDesc)UIUtil.getClientProperty((Object)component, (Key)TouchbarDataKeys.DIALOG_BUTTON_DESCRIPTOR_KEY)) != null) {
                out2.put(desc, (JButton)component);
            }
            DataProvider dp = null;
            if (component instanceof DataProvider) {
                dp = (DataProvider)component;
            } else if (component instanceof JComponent) {
                dp = DataManager.getDataProvider((JComponent)((JComponent)component));
            }
            if (dp == null || (actions = (ActionGroup)TouchbarDataKeys.ACTIONS_KEY.getData(dp)) == null) continue;
            out.put(component, actions);
        }
    }

    private static void _updateCurrentTouchbar() {
        TouchBar top = ourStack.getTopTouchBar();
        if (top != null) {
            top.updateActionItems();
        }
    }

    private static void _initExecutorsGroup() {
        ActionManager am = ActionManager.getInstance();
        AnAction runButtons = am.getAction(RUNNERS_GROUP_TOUCHBAR);
        if (runButtons == null) {
            return;
        }
        if (!(runButtons instanceof ActionGroup)) {
            return;
        }
        ActionGroup g = (ActionGroup)runButtons;
        for (Executor exec : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
            if (exec == null || !exec.getId().equals(ToolWindowId.RUN) && !exec.getId().equals(ToolWindowId.DEBUG)) continue;
            AnAction action = am.getAction(exec.getId());
            ((DefaultActionGroup)g).add(action);
        }
    }
}

