/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MoreInfoMessageDialog
extends MessageDialog {
    @Nullable
    private final String myInfoText;

    MoreInfoMessageDialog(Project project, String message, @Nls(capitalization=Nls.Capitalization.Title) String title, @Nullable String moreInfo, @NotNull String[] options, int defaultOptionIndex, int focusedOptionIndex, Icon icon) {
        super(project);
        this.myInfoText = moreInfo;
        this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, null);
    }

    protected JComponent createNorthPanel() {
        return this.doCreateCenterPanel();
    }

    protected JComponent createCenterPanel() {
        if (this.myInfoText == null) {
            return null;
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        JTextArea area = new JTextArea(this.myInfoText);
        area.setEditable(false);
        JBScrollPane scrollPane = new JBScrollPane(area){

            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                Container parent = this.getParent();
                if (parent != null) {
                    return new Dimension(preferredSize.width, Math.min(150, preferredSize.height));
                }
                return preferredSize;
            }
        };
        panel2.add((Component)scrollPane);
        return panel2;
    }
}

