/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListPopupStepEx;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MnemonicNavigationFilter;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.SpeedSearchFilter;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.popup.ActionStepBuilder;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.StatusText;
import java.awt.event.InputEvent;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionPopupStep
implements ListPopupStepEx<PopupFactoryImpl.ActionItem>,
MnemonicNavigationFilter<PopupFactoryImpl.ActionItem>,
SpeedSearchFilter<PopupFactoryImpl.ActionItem> {
    private final List<PopupFactoryImpl.ActionItem> myItems;
    private final String myTitle;
    private final Supplier<DataContext> myContext;
    private final String myActionPlace;
    private final boolean myEnableMnemonics;
    private final int myDefaultOptionIndex;
    private final boolean myAutoSelectionEnabled;
    private final boolean myShowDisabledActions;
    private Runnable myFinalRunnable;
    private final Condition<AnAction> myPreselectActionCondition;

    public ActionPopupStep(@NotNull List<PopupFactoryImpl.ActionItem> items, String title, @NotNull Supplier<DataContext> context, @Nullable String actionPlace, boolean enableMnemonics, @Nullable Condition<AnAction> preselectActionCondition, boolean autoSelection, boolean showDisabledActions) {
        this.myItems = items;
        this.myTitle = title;
        this.myContext = context;
        this.myActionPlace = (String)ObjectUtils.notNull((Object)actionPlace, (Object)"unknown");
        this.myEnableMnemonics = enableMnemonics;
        this.myDefaultOptionIndex = ActionPopupStep.getDefaultOptionIndexFromSelectCondition(preselectActionCondition, items);
        this.myPreselectActionCondition = preselectActionCondition;
        this.myAutoSelectionEnabled = autoSelection;
        this.myShowDisabledActions = showDisabledActions;
    }

    private static int getDefaultOptionIndexFromSelectCondition(@Nullable Condition<? super AnAction> preselectActionCondition, @NotNull List<? extends PopupFactoryImpl.ActionItem> items) {
        int defaultOptionIndex = 0;
        if (preselectActionCondition != null) {
            for (int i = 0; i < items.size(); ++i) {
                AnAction action = items.get(i).getAction();
                if (!preselectActionCondition.value((Object)action)) continue;
                defaultOptionIndex = i;
                break;
            }
        }
        return defaultOptionIndex;
    }

    public static ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, String title, boolean honorActionMnemonics, boolean autoSelectionEnabled, Supplier<DataContext> contextSupplier, @Nullable String actionPlace, Condition<AnAction> preselectCondition, int defaultOptionIndex) {
        ActionStepBuilder builder2 = new ActionStepBuilder(dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
        builder2.buildGroup(actionGroup);
        List<PopupFactoryImpl.ActionItem> items = builder2.getItems();
        boolean enableMnemonics = showNumbers || honorActionMnemonics && items.stream().anyMatch(actionItem -> actionItem.getAction().getTemplatePresentation().getMnemonic() != 0);
        return new ActionPopupStep(items, title, contextSupplier, actionPlace, enableMnemonics, (Condition<AnAction>)(preselectCondition != null ? preselectCondition : action -> defaultOptionIndex >= 0 && defaultOptionIndex < items.size() && ((PopupFactoryImpl.ActionItem)items.get(defaultOptionIndex)).getAction().equals(action)), autoSelectionEnabled, showDisabledActions);
    }

    @NotNull
    public List<PopupFactoryImpl.ActionItem> getValues() {
        return this.myItems;
    }

    public boolean isSelectable(PopupFactoryImpl.ActionItem value) {
        return value.isEnabled();
    }

    public int getMnemonicPos(PopupFactoryImpl.ActionItem value) {
        String text = this.getTextFor(value);
        int i = text.indexOf(27);
        if (i < 0) {
            i = text.indexOf(38);
        }
        if (i < 0) {
            i = text.indexOf(95);
        }
        return i;
    }

    public Icon getIconFor(PopupFactoryImpl.ActionItem aValue) {
        return aValue.getIcon(false);
    }

    public Icon getSelectedIconFor(PopupFactoryImpl.ActionItem value) {
        return value.getIcon(true);
    }

    @NotNull
    public String getTextFor(PopupFactoryImpl.ActionItem value) {
        return value.getText();
    }

    @Nullable
    public String getTooltipTextFor(PopupFactoryImpl.ActionItem value) {
        return value.getDescription();
    }

    public void setEmptyText(@NotNull StatusText emptyText) {
    }

    public ListSeparator getSeparatorAbove(PopupFactoryImpl.ActionItem value) {
        return value.isPrependWithSeparator() ? new ListSeparator(value.getSeparatorText()) : null;
    }

    public int getDefaultOptionIndex() {
        return this.myDefaultOptionIndex;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public PopupStep onChosen(PopupFactoryImpl.ActionItem actionChoice, boolean finalChoice) {
        return this.onChosen(actionChoice, finalChoice, 0);
    }

    public PopupStep onChosen(PopupFactoryImpl.ActionItem actionChoice, boolean finalChoice, int eventModifiers) {
        if (!actionChoice.isEnabled()) {
            return FINAL_CHOICE;
        }
        AnAction action = actionChoice.getAction();
        DataContext dataContext = this.myContext.get();
        if (!(!(action instanceof ActionGroup) || finalChoice && ((ActionGroup)action).canBePerformed(dataContext))) {
            return ActionPopupStep.createActionsStep((ActionGroup)action, dataContext, this.myEnableMnemonics, true, this.myShowDisabledActions, null, false, false, this.myContext, this.myActionPlace, this.myPreselectActionCondition, -1);
        }
        this.myFinalRunnable = () -> this.performAction(action, eventModifiers);
        return FINAL_CHOICE;
    }

    public void performAction(@NotNull AnAction action, int modifiers) {
        this.performAction(action, modifiers, null);
    }

    public void performAction(@NotNull AnAction action, int modifiers, InputEvent inputEvent) {
        DataContext dataContext = this.myContext.get();
        AnActionEvent event = new AnActionEvent(inputEvent, dataContext, this.myActionPlace, action.getTemplatePresentation().clone(), ActionManager.getInstance(), modifiers);
        event.setInjectedContext(action.isInInjectedContext());
        if (ActionUtil.lastUpdateAndCheckDumb((AnAction)action, (AnActionEvent)event, (boolean)false)) {
            ActionUtil.performActionDumbAwareWithCallbacks((AnAction)action, (AnActionEvent)event, (DataContext)dataContext);
        }
    }

    public Runnable getFinalRunnable() {
        return this.myFinalRunnable;
    }

    public boolean hasSubstep(PopupFactoryImpl.ActionItem selectedValue) {
        return selectedValue != null && selectedValue.isEnabled() && selectedValue.getAction() instanceof ActionGroup;
    }

    public void canceled() {
    }

    public boolean isMnemonicsNavigationEnabled() {
        return this.myEnableMnemonics;
    }

    public MnemonicNavigationFilter<PopupFactoryImpl.ActionItem> getMnemonicNavigationFilter() {
        return this;
    }

    public String getIndexedString(PopupFactoryImpl.ActionItem value) {
        return this.getTextFor(value);
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public boolean isAutoSelectionEnabled() {
        return this.myAutoSelectionEnabled;
    }

    public SpeedSearchFilter<PopupFactoryImpl.ActionItem> getSpeedSearchFilter() {
        return this;
    }
}

