/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.LafIconLookup;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ActionStepBuilder
extends PresentationFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.PopupFactoryImpl");
    private final List<PopupFactoryImpl.ActionItem> myListModel;
    private final DataContext myDataContext;
    private final boolean myShowNumbers;
    private final boolean myUseAlphaAsNumbers;
    private final boolean myShowDisabled;
    private int myCurrentNumber;
    private boolean myPrependWithSeparator;
    private String mySeparatorText;
    private final boolean myHonorActionMnemonics;
    private Icon myEmptyIcon;
    private int myMaxIconWidth = -1;
    private int myMaxIconHeight = -1;
    @NotNull
    private String myActionPlace;

    public ActionStepBuilder(@NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabled, boolean honorActionMnemonics) {
        this.myUseAlphaAsNumbers = useAlphaAsNumbers;
        this.myListModel = new ArrayList<PopupFactoryImpl.ActionItem>();
        this.myDataContext = dataContext;
        this.myShowNumbers = showNumbers;
        this.myShowDisabled = showDisabled;
        this.myCurrentNumber = 0;
        this.myPrependWithSeparator = false;
        this.mySeparatorText = null;
        this.myHonorActionMnemonics = honorActionMnemonics;
        this.myActionPlace = "unknown";
    }

    public void setActionPlace(@NotNull String actionPlace) {
        this.myActionPlace = actionPlace;
    }

    @NotNull
    public List<PopupFactoryImpl.ActionItem> getItems() {
        return this.myListModel;
    }

    public void buildGroup(@NotNull ActionGroup actionGroup) {
        this.calcMaxIconSize(actionGroup);
        this.myEmptyIcon = this.myMaxIconHeight != -1 && this.myMaxIconWidth != -1 ? EmptyIcon.create((int)this.myMaxIconWidth, (int)this.myMaxIconHeight) : null;
        this.appendActionsFromGroup(actionGroup);
        if (this.myListModel.isEmpty()) {
            this.myListModel.add(new PopupFactoryImpl.ActionItem(Utils.EMPTY_MENU_FILLER, "Nothing here", null, false, null, null, false, null));
        }
    }

    private void calcMaxIconSize(ActionGroup actionGroup) {
        AnAction[] actions;
        for (AnAction action : actions = actionGroup.getChildren(this.createActionEvent((AnAction)actionGroup))) {
            ActionGroup group;
            if (action == null) continue;
            if (action instanceof ActionGroup && !(group = (ActionGroup)action).isPopup()) {
                this.calcMaxIconSize(group);
                continue;
            }
            Icon icon = action.getTemplatePresentation().getIcon();
            if (icon == null && action instanceof Toggleable) {
                icon = EmptyIcon.ICON_16;
            }
            if (icon == null) continue;
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            if (this.myMaxIconWidth < width) {
                this.myMaxIconWidth = width;
            }
            if (this.myMaxIconHeight >= height) continue;
            this.myMaxIconHeight = height;
        }
    }

    @NotNull
    private AnActionEvent createActionEvent(@NotNull AnAction actionGroup) {
        AnActionEvent actionEvent = new AnActionEvent(null, this.myDataContext, this.myActionPlace, this.getPresentation(actionGroup), ActionManager.getInstance(), 0);
        actionEvent.setInjectedContext(actionGroup.isInInjectedContext());
        return actionEvent;
    }

    private void appendActionsFromGroup(@NotNull ActionGroup actionGroup) {
        List<AnAction> newVisibleActions = Utils.expandActionGroup(false, actionGroup, this, this.myDataContext, this.myActionPlace);
        for (AnAction action : newVisibleActions) {
            if (action instanceof Separator) {
                this.myPrependWithSeparator = true;
                this.mySeparatorText = ((Separator)action).getText();
                continue;
            }
            this.appendAction(action);
        }
    }

    private void appendAction(@NotNull AnAction action) {
        Presentation presentation = this.getPresentation(action);
        boolean enabled = presentation.isEnabled();
        if ((this.myShowDisabled || enabled) && presentation.isVisible()) {
            boolean prependSeparator;
            String text = presentation.getText();
            if (this.myShowNumbers) {
                if (this.myCurrentNumber < 9) {
                    text = "&" + (this.myCurrentNumber + 1) + ". " + text;
                } else if (this.myCurrentNumber == 9) {
                    text = "&0. " + text;
                } else if (this.myUseAlphaAsNumbers) {
                    text = "&" + (char)(65 + this.myCurrentNumber - 10) + ". " + text;
                }
                ++this.myCurrentNumber;
            } else if (this.myHonorActionMnemonics) {
                text = Presentation.restoreTextWithMnemonic((String)text, (int)action.getTemplatePresentation().getMnemonic());
            }
            Icon icon = presentation.getIcon();
            Icon selectedIcon = presentation.getSelectedIcon();
            Icon disabledIcon = presentation.getDisabledIcon();
            if (icon == null && selectedIcon == null) {
                String actionId = ActionManager.getInstance().getId(action);
                if (actionId != null && actionId.startsWith("QuickList.")) {
                    icon = null;
                } else if (action instanceof Toggleable && Boolean.TRUE.equals(presentation.getClientProperty("selected"))) {
                    icon = LafIconLookup.getIcon((String)"checkmark");
                    selectedIcon = LafIconLookup.getSelectedIcon((String)"checkmark");
                    disabledIcon = LafIconLookup.getDisabledIcon((String)"checkmark");
                }
            }
            if (!enabled) {
                icon = disabledIcon != null ? disabledIcon : IconLoader.getDisabledIcon((Icon)icon);
                Icon icon2 = selectedIcon = disabledIcon != null ? disabledIcon : IconLoader.getDisabledIcon((Icon)selectedIcon);
            }
            if (this.myMaxIconWidth != -1 && this.myMaxIconHeight != -1) {
                if (icon != null) {
                    icon = new SizedIcon(icon, this.myMaxIconWidth, this.myMaxIconHeight);
                }
                if (selectedIcon != null) {
                    selectedIcon = new SizedIcon(selectedIcon, this.myMaxIconWidth, this.myMaxIconHeight);
                }
            }
            if (icon == null) {
                icon = selectedIcon != null ? selectedIcon : this.myEmptyIcon;
            }
            boolean bl = prependSeparator = (!this.myListModel.isEmpty() || this.mySeparatorText != null) && this.myPrependWithSeparator;
            assert (text != null) : action + " has no presentation";
            this.myListModel.add(new PopupFactoryImpl.ActionItem(action, text, (String)presentation.getClientProperty("ToolTipText"), enabled, icon, selectedIcon, prependSeparator, this.mySeparatorText));
            this.myPrependWithSeparator = false;
            this.mySeparatorText = null;
        }
    }
}

