/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.BalloonImpl;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalloonPopupBuilderImpl
implements BalloonBuilder {
    @Nullable
    private final Map<Disposable, List<Balloon>> myStorage;
    @Nullable
    private Disposable myAnchor;
    private final JComponent myContent;
    private Color myBorder = IdeTooltipManager.getInstance().getBorderColor(true);
    @Nullable
    private Insets myBorderInsets = null;
    private Color myFill = MessageType.INFO.getPopupBackground();
    private boolean myHideOnMouseOutside = true;
    private boolean myHideOnKeyOutside = true;
    private long myFadeoutTime = -1L;
    private boolean myShowCallout = true;
    private boolean myCloseButtonEnabled = false;
    private boolean myHideOnFrameResize = true;
    private boolean myHideOnLinkClick = false;
    private ActionListener myClickHandler;
    private boolean myCloseOnClick;
    private int myAnimationCycle = 500;
    private int myCalloutShift;
    private int myPositionChangeXShift;
    private int myPositionChangeYShift;
    private boolean myHideOnAction = true;
    private boolean myHideOnCloseClick = true;
    private boolean myDialogMode;
    private String myTitle;
    private Insets myContentInsets = JBUI.insets((int)2);
    private boolean myShadow = true;
    private boolean mySmallVariant = false;
    private Balloon.Layer myLayer;
    private boolean myBlockClicks = false;
    private boolean myRequestFocus = false;
    private Dimension myPointerSize;
    private int myCornerToPointerDistance = -1;

    public BalloonPopupBuilderImpl(@Nullable Map<Disposable, List<Balloon>> storage2, @NotNull JComponent content) {
        this.myStorage = storage2;
        this.myContent = content;
        if (UIUtil.isClientPropertyTrue((Object)this.myContent, BalloonImpl.FORCED_NO_SHADOW)) {
            this.myShadow = false;
        }
    }

    @NotNull
    public BalloonBuilder setHideOnAction(boolean hideOnAction) {
        this.myHideOnAction = hideOnAction;
        return this;
    }

    @NotNull
    public BalloonBuilder setDialogMode(boolean dialogMode) {
        this.myDialogMode = dialogMode;
        return this;
    }

    @NotNull
    public BalloonBuilder setBorderColor(@NotNull Color color) {
        this.myBorder = color;
        return this;
    }

    @NotNull
    public BalloonBuilder setBorderInsets(@Nullable Insets insets) {
        this.myBorderInsets = insets;
        return this;
    }

    @NotNull
    public BalloonBuilder setFillColor(@NotNull Color color) {
        this.myFill = color;
        return this;
    }

    @NotNull
    public BalloonBuilder setHideOnClickOutside(boolean hide) {
        this.myHideOnMouseOutside = hide;
        return this;
    }

    @NotNull
    public BalloonBuilder setHideOnKeyOutside(boolean hide) {
        this.myHideOnKeyOutside = hide;
        return this;
    }

    @NotNull
    public BalloonBuilder setShowCallout(boolean show) {
        this.myShowCallout = show;
        return this;
    }

    @NotNull
    public BalloonBuilder setFadeoutTime(long fadeoutTime) {
        this.myFadeoutTime = fadeoutTime;
        return this;
    }

    @NotNull
    public BalloonBuilder setBlockClicksThroughBalloon(boolean block) {
        this.myBlockClicks = block;
        return this;
    }

    @NotNull
    public BalloonBuilder setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        return this;
    }

    public BalloonBuilder setHideOnCloseClick(boolean hideOnCloseClick) {
        this.myHideOnCloseClick = hideOnCloseClick;
        return this;
    }

    @NotNull
    public BalloonBuilder setAnimationCycle(int time) {
        this.myAnimationCycle = time;
        return this;
    }

    @NotNull
    public BalloonBuilder setHideOnFrameResize(boolean hide) {
        this.myHideOnFrameResize = hide;
        return this;
    }

    @NotNull
    public BalloonBuilder setHideOnLinkClick(boolean hide) {
        this.myHideOnLinkClick = hide;
        return this;
    }

    @NotNull
    public BalloonBuilder setPositionChangeXShift(int positionChangeXShift) {
        this.myPositionChangeXShift = positionChangeXShift;
        return this;
    }

    @NotNull
    public BalloonBuilder setPositionChangeYShift(int positionChangeYShift) {
        this.myPositionChangeYShift = positionChangeYShift;
        return this;
    }

    @NotNull
    public BalloonBuilder setCloseButtonEnabled(boolean enabled) {
        this.myCloseButtonEnabled = enabled;
        return this;
    }

    @NotNull
    public BalloonBuilder setClickHandler(ActionListener listener2, boolean closeOnClick) {
        this.myClickHandler = listener2;
        this.myCloseOnClick = closeOnClick;
        return this;
    }

    @NotNull
    public BalloonBuilder setCalloutShift(int length) {
        this.myCalloutShift = length;
        return this;
    }

    @NotNull
    public BalloonBuilder setTitle(@Nullable String title) {
        this.myTitle = title;
        return this;
    }

    @NotNull
    public BalloonBuilder setContentInsets(Insets insets) {
        this.myContentInsets = insets;
        return this;
    }

    @NotNull
    public BalloonBuilder setShadow(boolean shadow) {
        this.myShadow = shadow;
        return this;
    }

    @NotNull
    public BalloonBuilder setSmallVariant(boolean smallVariant) {
        this.mySmallVariant = smallVariant;
        return this;
    }

    @NotNull
    public BalloonBuilder setLayer(Balloon.Layer layer) {
        this.myLayer = layer;
        return this;
    }

    @NotNull
    public BalloonBuilder setDisposable(@NotNull Disposable anchor2) {
        this.myAnchor = anchor2;
        return this;
    }

    @NotNull
    public BalloonBuilder setPointerSize(Dimension size) {
        this.myPointerSize = size;
        return this;
    }

    @NotNull
    public BalloonBuilder setCornerToPointerDistance(int distance2) {
        this.myCornerToPointerDistance = distance2;
        return this;
    }

    @NotNull
    public Balloon createBalloon() {
        final BalloonImpl result2 = new BalloonImpl(this.myContent, this.myBorder, this.myBorderInsets, this.myFill, this.myHideOnMouseOutside, this.myHideOnKeyOutside, this.myHideOnAction, this.myHideOnCloseClick, this.myShowCallout, this.myCloseButtonEnabled, this.myFadeoutTime, this.myHideOnFrameResize, this.myHideOnLinkClick, this.myClickHandler, this.myCloseOnClick, this.myAnimationCycle, this.myCalloutShift, this.myPositionChangeXShift, this.myPositionChangeYShift, this.myDialogMode, this.myTitle, this.myContentInsets, this.myShadow, this.mySmallVariant, this.myBlockClicks, this.myLayer, this.myRequestFocus, this.myPointerSize, this.myCornerToPointerDistance);
        if (this.myStorage != null && this.myAnchor != null) {
            List<Balloon> balloons = this.myStorage.get(this.myAnchor);
            if (balloons == null) {
                balloons = new ArrayList<Balloon>();
                this.myStorage.put(this.myAnchor, balloons);
                Disposer.register((Disposable)this.myAnchor, (Disposable)new Disposable(){

                    public void dispose() {
                        List toDispose = (List)BalloonPopupBuilderImpl.this.myStorage.remove(BalloonPopupBuilderImpl.this.myAnchor);
                        if (toDispose != null) {
                            for (Balloon balloon : toDispose) {
                                if (balloon.isDisposed()) continue;
                                Disposer.dispose((Disposable)balloon);
                            }
                        }
                    }
                });
            }
            balloons.add(result2);
            result2.addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (!result2.isDisposed()) {
                        Disposer.dispose((Disposable)result2);
                    }
                }
            });
        }
        return result2;
    }
}

