/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.CommonBundle;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.TreePopup;
import com.intellij.openapi.ui.popup.TreePopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.HintHint;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.ActionPopupStep;
import com.intellij.ui.popup.ActionStepBuilder;
import com.intellij.ui.popup.BalloonPopupBuilderImpl;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.popup.KeepingPopupOpenAction;
import com.intellij.ui.popup.PopupListAdapter;
import com.intellij.ui.popup.PopupOwner;
import com.intellij.ui.popup.PopupTableAdapter;
import com.intellij.ui.popup.PopupTreeAdapter;
import com.intellij.ui.popup.WizardPopup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.mock.MockConfirmation;
import com.intellij.ui.popup.tree.TreePopupImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopupFactoryImpl
extends JBPopupFactory {
    public static final Key<VisualPosition> ANCHOR_POPUP_POSITION = Key.create((String)"popup.anchor.position");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.popup.PopupFactoryImpl");
    private final Map<Disposable, List<Balloon>> myStorage = ContainerUtil.createWeakMap();

    @NotNull
    public <T> IPopupChooserBuilder<T> createPopupChooserBuilder(@NotNull List<T> list2) {
        return new PopupChooserBuilder((JList)new JBList((ListModel)new CollectionListModel(list2)));
    }

    @NotNull
    public ListPopup createConfirmation(String title, Runnable onYes, int defaultOptionIndex) {
        return this.createConfirmation(title, CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), onYes, defaultOptionIndex);
    }

    @NotNull
    public ListPopup createConfirmation(String title, String yesText, String noText, Runnable onYes, int defaultOptionIndex) {
        return this.createConfirmation(title, yesText, noText, onYes, EmptyRunnable.getInstance(), defaultOptionIndex);
    }

    @NotNull
    public JBPopup createMessage(String text) {
        return this.createListPopup((ListPopupStep)new BaseListPopupStep(null, (Object[])new String[]{text}));
    }

    public Balloon getParentBalloonFor(@Nullable Component c) {
        if (c == null) {
            return null;
        }
        for (Component eachParent = c; eachParent != null; eachParent = eachParent.getParent()) {
            Object balloon;
            if (!(eachParent instanceof JComponent) || !((balloon = ((JComponent)eachParent).getClientProperty("Balloon.property")) instanceof Balloon)) continue;
            return (Balloon)balloon;
        }
        return null;
    }

    protected PopupChooserBuilder.PopupComponentAdapter createPopupComponentAdapter(PopupChooserBuilder builder2, JList list2) {
        return new PopupListAdapter(builder2, list2);
    }

    protected PopupChooserBuilder.PopupComponentAdapter createPopupComponentAdapter(PopupChooserBuilder builder2, JTree tree) {
        return new PopupTreeAdapter(builder2, tree);
    }

    protected PopupChooserBuilder.PopupComponentAdapter createPopupComponentAdapter(PopupChooserBuilder builder2, JTable table) {
        return new PopupTableAdapter(builder2, table);
    }

    @NotNull
    public ListPopup createConfirmation(String title, final String yesText, String noText, final Runnable onYes, final Runnable onNo, int defaultOptionIndex) {
        BaseListPopupStep<String> step = new BaseListPopupStep<String>(title, new String[]{yesText, noText}){

            public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                return this.doFinalStep(selectedValue.equals(yesText) ? onYes : onNo);
            }

            public void canceled() {
                onNo.run();
            }

            public boolean isMnemonicsNavigationEnabled() {
                return true;
            }
        };
        step.setDefaultOptionIndex(defaultOptionIndex);
        ApplicationEx app = ApplicationManagerEx.getApplicationEx();
        return app == null || !app.isUnitTestMode() ? new ListPopupImpl((ListPopupStep)step) : new MockConfirmation((ListPopupStep)step, yesText);
    }

    @NotNull
    private static Supplier<DataContext> getComponentContextSupplier(Component component) {
        return () -> DataManager.getInstance().getDataContext(component);
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, JBPopupFactory.ActionSelectionAid aid, boolean showDisabledActions, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace) {
        return new ActionGroupPopup(title, actionGroup, dataContext, aid == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING || aid == JBPopupFactory.ActionSelectionAid.NUMBERING, aid == JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, showDisabledActions, aid == JBPopupFactory.ActionSelectionAid.MNEMONICS, disposeCallback, maxRowCount, preselectActionCondition, actionPlace);
    }

    @NotNull
    public ListPopup createActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition) {
        return new ActionGroupPopup(title, actionGroup, dataContext, showNumbers, true, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, null);
    }

    @NotNull
    public ListPopupStep createActionsStep(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, @Nullable String actionPlace, boolean showNumbers, boolean showDisabledActions, String title, Component component, boolean honorActionMnemonics, int defaultOptionIndex, boolean autoSelectionEnabled) {
        return ActionPopupStep.createActionsStep(actionGroup, dataContext, showNumbers, true, showDisabledActions, title, honorActionMnemonics, autoSelectionEnabled, PopupFactoryImpl.getComponentContextSupplier(component), actionPlace, null, defaultOptionIndex);
    }

    private static boolean itemsHaveMnemonics(List<? extends ActionItem> items) {
        for (ActionItem actionItem : items) {
            if (actionItem.getAction().getTemplatePresentation().getMnemonic() == 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step) {
        return new ListPopupImpl(step);
    }

    @NotNull
    public ListPopup createListPopup(@NotNull ListPopupStep step, int maxRowCount) {
        return new ListPopupImpl(step, maxRowCount);
    }

    @NotNull
    public TreePopup createTree(JBPopup parent, @NotNull TreePopupStep aStep, Object parentValue) {
        return new TreePopupImpl(parent, aStep, parentValue);
    }

    @NotNull
    public TreePopup createTree(@NotNull TreePopupStep aStep) {
        return new TreePopupImpl(aStep);
    }

    @NotNull
    public ComponentPopupBuilder createComponentPopupBuilder(@NotNull JComponent content, JComponent preferableFocusComponent) {
        return new ComponentPopupBuilderImpl(content, preferableFocusComponent);
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull DataContext dataContext) {
        Point point;
        JComponent focusOwner;
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        JComponent jComponent = focusOwner = component instanceof JComponent ? (JComponent)component : null;
        if (focusOwner == null) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            IdeFrameImpl frame = project == null ? null : ((WindowManagerEx)WindowManager.getInstance()).getFrame(project);
            JComponent jComponent2 = focusOwner = frame == null ? null : frame.getRootPane();
            if (focusOwner == null) {
                throw new IllegalArgumentException("focusOwner cannot be null");
            }
        }
        if ((point = (Point)PlatformDataKeys.CONTEXT_MENU_POINT.getData(dataContext)) != null) {
            return new RelativePoint((Component)focusOwner, point);
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && focusOwner == editor.getContentComponent()) {
            return this.guessBestPopupLocation(editor);
        }
        return this.guessBestPopupLocation(focusOwner);
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull JComponent component) {
        Point popupMenuPoint = null;
        Rectangle visibleRect = component.getVisibleRect();
        if (component instanceof JList) {
            int[] selectedIndices;
            JList list2 = (JList)component;
            int firstVisibleIndex = list2.getFirstVisibleIndex();
            int lastVisibleIndex = list2.getLastVisibleIndex();
            for (int index : selectedIndices = list2.getSelectedIndices()) {
                if (firstVisibleIndex > index || index > lastVisibleIndex) continue;
                Rectangle cellBounds = list2.getCellBounds(index, index);
                popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y + cellBounds.height - 1);
                break;
            }
        } else if (component instanceof JTree) {
            JTree tree = (JTree)component;
            int[] selectionRows = tree.getSelectionRows();
            if (selectionRows != null) {
                Object rowBounds;
                Arrays.sort(selectionRows);
                for (int row2 : selectionRows) {
                    rowBounds = tree.getRowBounds(row2);
                    if (!visibleRect.contains((Rectangle)rowBounds)) continue;
                    popupMenuPoint = new Point(((Rectangle)rowBounds).x + 2, ((Rectangle)rowBounds).y + ((Rectangle)rowBounds).height - 1);
                    break;
                }
                if (popupMenuPoint == null) {
                    Point visibleCenter = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
                    double minDistance = Double.POSITIVE_INFINITY;
                    Object bestRow = -1;
                    for (Object row3 : (Object)selectionRows) {
                        Rectangle rowBounds2 = tree.getRowBounds((int)row3);
                        Point rowCenter = new Point(rowBounds2.x + rowBounds2.width / 2, rowBounds2.y + rowBounds2.height / 2);
                        double distance2 = visibleCenter.distance(rowCenter);
                        if (!(minDistance > distance2)) continue;
                        minDistance = distance2;
                        bestRow = row3;
                    }
                    if (bestRow != -1) {
                        rowBounds = tree.getRowBounds((int)bestRow);
                        tree.scrollRectToVisible(new Rectangle(((Rectangle)rowBounds).x, ((Rectangle)rowBounds).y, Math.min(visibleRect.width, ((Rectangle)rowBounds).width), ((Rectangle)rowBounds).height));
                        popupMenuPoint = new Point(((Rectangle)rowBounds).x + 2, ((Rectangle)rowBounds).y + ((Rectangle)rowBounds).height - 1);
                    }
                }
            }
        } else if (component instanceof JTable) {
            JTable table = (JTable)component;
            int column = table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            int row4 = Math.max(table.getSelectionModel().getLeadSelectionIndex(), table.getSelectionModel().getAnchorSelectionIndex());
            Rectangle rect = table.getCellRect(row4, column, false);
            if (!visibleRect.intersects(rect)) {
                table.scrollRectToVisible(rect);
            }
            popupMenuPoint = new Point(rect.x, rect.y + rect.height - 1);
        } else if (component instanceof PopupOwner) {
            popupMenuPoint = ((PopupOwner)((Object)component)).getBestPopupPosition();
        }
        if (popupMenuPoint == null) {
            popupMenuPoint = new Point(visibleRect.x + visibleRect.width / 2, visibleRect.y + visibleRect.height / 2);
        }
        return new RelativePoint((Component)component, popupMenuPoint);
    }

    public boolean isBestPopupLocationVisible(@NotNull Editor editor) {
        return PopupFactoryImpl.getVisibleBestPopupLocation(editor) != null;
    }

    @NotNull
    public RelativePoint guessBestPopupLocation(@NotNull Editor editor) {
        Point p = PopupFactoryImpl.getVisibleBestPopupLocation(editor);
        if (p == null) {
            Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
            p = new Point(visibleArea.x + visibleArea.width / 3, visibleArea.y + visibleArea.height / 2);
        }
        return new RelativePoint((Component)editor.getContentComponent(), p);
    }

    @Nullable
    private static Point getVisibleBestPopupLocation(@NotNull Editor editor) {
        VisualPosition visualPosition = (VisualPosition)editor.getUserData(ANCHOR_POPUP_POSITION);
        if (visualPosition == null) {
            CaretModel caretModel = editor.getCaretModel();
            visualPosition = caretModel.isUpToDate() ? caretModel.getVisualPosition() : editor.offsetToVisualPosition(caretModel.getOffset());
        }
        int lineHeight = editor.getLineHeight();
        Point p = editor.visualPositionToXY(visualPosition);
        p.y += lineHeight;
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        return !visibleArea.contains(p) && !visibleArea.contains(p.x, p.y - lineHeight) ? null : p;
    }

    public Point getCenterOf(JComponent container, JComponent content) {
        return AbstractPopup.getCenterOf((Component)container, content);
    }

    @NotNull
    public List<JBPopup> getChildPopups(@NotNull Component component) {
        return AbstractPopup.getChildPopups(component);
    }

    public boolean isPopupActive() {
        return IdeEventQueue.getInstance().isPopupActive();
    }

    @NotNull
    public BalloonBuilder createBalloonBuilder(@NotNull JComponent content) {
        return new BalloonPopupBuilderImpl(this.myStorage, content);
    }

    @NotNull
    public BalloonBuilder createDialogBalloonBuilder(@NotNull JComponent content, String title) {
        BalloonPopupBuilderImpl builder2 = new BalloonPopupBuilderImpl(this.myStorage, content);
        Color bg = UIManager.getColor("Panel.background");
        Color borderOriginal = Color.darkGray;
        Color border = ColorUtil.toAlpha((Color)borderOriginal, (int)75);
        builder2.setDialogMode(true).setTitle(title).setAnimationCycle(200).setFillColor(bg).setBorderColor(border).setHideOnClickOutside(false).setHideOnKeyOutside(false).setHideOnAction(false).setCloseButtonEnabled(true).setShadow(true);
        return builder2;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, @Nullable Icon icon, Color textColor, Color fillColor, @Nullable HyperlinkListener listener2) {
        JEditorPane text = IdeTooltipManager.initPane(htmlContent, new HintHint().setTextFg(textColor).setAwtTooltip(true), null);
        if (listener2 != null) {
            text.addHyperlinkListener(listener2);
        }
        text.setEditable(false);
        NonOpaquePanel.setTransparent((JComponent)text);
        text.setBorder(null);
        JLabel label2 = new JLabel();
        NonOpaquePanel content = new NonOpaquePanel((LayoutManager)new BorderLayout((int)((double)label2.getIconTextGap() * 1.5), (int)((double)label2.getIconTextGap() * 1.5)));
        NonOpaquePanel textWrapper = new NonOpaquePanel((LayoutManager)new GridBagLayout());
        JScrollPane scrolledText = ScrollPaneFactory.createScrollPane((Component)text, (boolean)true);
        scrolledText.setBackground(fillColor);
        scrolledText.getViewport().setBackground(fillColor);
        textWrapper.add((Component)scrolledText);
        content.add((Component)textWrapper, "Center");
        if (icon != null) {
            NonOpaquePanel north = new NonOpaquePanel((LayoutManager)new BorderLayout());
            north.add((Component)new JLabel(icon), (Object)"North");
            content.add((Component)north, "West");
        }
        content.setBorder(new EmptyBorder(2, 4, 2, 4));
        BalloonBuilder builder2 = this.createBalloonBuilder((JComponent)content);
        builder2.setFillColor(fillColor);
        return builder2;
    }

    @NotNull
    public BalloonBuilder createHtmlTextBalloonBuilder(@NotNull String htmlContent, MessageType messageType, @Nullable HyperlinkListener listener2) {
        return this.createHtmlTextBalloonBuilder(htmlContent, messageType.getDefaultIcon(), messageType.getPopupBackground(), listener2);
    }

    public static class ActionItem
    implements ShortcutProvider {
        private final AnAction myAction;
        private String myText;
        private final boolean myIsEnabled;
        private final Icon myIcon;
        private final Icon mySelectedIcon;
        private final boolean myPrependWithSeparator;
        private final String mySeparatorText;
        private final String myDescription;

        ActionItem(@NotNull AnAction action, @NotNull String text, @Nullable String description, boolean enabled, @Nullable Icon icon, @Nullable Icon selectedIcon, boolean prependWithSeparator, String separatorText) {
            this.myAction = action;
            this.myText = text;
            this.myIsEnabled = enabled;
            this.myIcon = icon;
            this.mySelectedIcon = selectedIcon;
            this.myPrependWithSeparator = prependWithSeparator;
            this.mySeparatorText = separatorText;
            this.myDescription = description;
            this.myAction.getTemplatePresentation().addPropertyChangeListener(evt -> {
                if (evt.getPropertyName() == "text") {
                    this.myText = this.myAction.getTemplatePresentation().getText();
                }
            });
        }

        @NotNull
        public AnAction getAction() {
            return this.myAction;
        }

        @NotNull
        public String getText() {
            return this.myText;
        }

        @Nullable
        public Icon getIcon(boolean selected) {
            return selected && this.mySelectedIcon != null ? this.mySelectedIcon : this.myIcon;
        }

        public boolean isPrependWithSeparator() {
            return this.myPrependWithSeparator;
        }

        public String getSeparatorText() {
            return this.mySeparatorText;
        }

        public boolean isEnabled() {
            return this.myIsEnabled;
        }

        public String getDescription() {
            return this.myDescription;
        }

        @Nullable
        public ShortcutSet getShortcut() {
            return this.myAction.getShortcutSet();
        }

        public String toString() {
            return this.myText;
        }
    }

    public static class ActionGroupPopup
    extends ListPopupImpl {
        private final Runnable myDisposeCallback;
        private final Component myComponent;
        private final String myActionPlace;

        public ActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace) {
            this(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, disposeCallback, maxRowCount, preselectActionCondition, actionPlace, false);
        }

        public ActionGroupPopup(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Runnable disposeCallback, int maxRowCount, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace, boolean autoSelection) {
            this(null, ActionGroupPopup.createStep(title, actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, preselectActionCondition, actionPlace, autoSelection), disposeCallback, dataContext, actionPlace, maxRowCount);
        }

        protected ActionGroupPopup(@Nullable WizardPopup aParent, @NotNull ListPopupStep step, @Nullable Runnable disposeCallback, @NotNull DataContext dataContext, @Nullable String actionPlace, int maxRowCount) {
            super(aParent, step, null, maxRowCount);
            this.myDisposeCallback = disposeCallback;
            this.myComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            this.myActionPlace = actionPlace == null ? "unknown" : actionPlace;
            this.registerAction("handleActionToggle1", 32, 0, new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.handleToggleAction();
                }
            });
            this.addListSelectionListener(e -> {
                JList list2 = (JList)e.getSource();
                ActionItem actionItem = (ActionItem)list2.getSelectedValue();
                if (actionItem == null) {
                    return;
                }
                Presentation presentation = this.updateActionItem(actionItem);
                ActionMenu.showDescriptionInStatusBar(true, this.myComponent, presentation.getDescription());
            });
        }

        @NotNull
        private Presentation updateActionItem(@NotNull ActionItem actionItem) {
            AnAction action = actionItem.getAction();
            Presentation presentation = new Presentation();
            presentation.setDescription(action.getTemplatePresentation().getDescription());
            AnActionEvent actionEvent = new AnActionEvent(null, DataManager.getInstance().getDataContext(this.myComponent), this.myActionPlace, presentation, ActionManager.getInstance(), 0);
            actionEvent.setInjectedContext(action.isInInjectedContext());
            ActionUtil.performDumbAwareUpdate((boolean)LaterInvocator.isInModalContext(), (AnAction)action, (AnActionEvent)actionEvent, (boolean)false);
            return presentation;
        }

        private static ListPopupStep createStep(String title, @NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, Condition<AnAction> preselectActionCondition, @Nullable String actionPlace, boolean autoSelection) {
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            LOG.assertTrue(component != null, (Object)"dataContext has no component for new ListPopupStep");
            List<ActionItem> items = ActionGroupPopup.getActionItems(actionGroup, dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics, actionPlace);
            return new ActionPopupStep(items, title, PopupFactoryImpl.getComponentContextSupplier(component), actionPlace, showNumbers || honorActionMnemonics && PopupFactoryImpl.itemsHaveMnemonics(items), preselectActionCondition, autoSelection, showDisabledActions);
        }

        @NotNull
        public static List<ActionItem> getActionItems(@NotNull ActionGroup actionGroup, @NotNull DataContext dataContext, boolean showNumbers, boolean useAlphaAsNumbers, boolean showDisabledActions, boolean honorActionMnemonics, @Nullable String actionPlace) {
            ActionStepBuilder builder2 = new ActionStepBuilder(dataContext, showNumbers, useAlphaAsNumbers, showDisabledActions, honorActionMnemonics);
            if (actionPlace != null) {
                builder2.setActionPlace(actionPlace);
            }
            builder2.buildGroup(actionGroup);
            return builder2.getItems();
        }

        @Override
        public void dispose() {
            if (this.myDisposeCallback != null) {
                this.myDisposeCallback.run();
            }
            ActionMenu.showDescriptionInStatusBar(true, this.myComponent, null);
            super.dispose();
        }

        @Override
        public void handleSelect(boolean handleFinalChoices, InputEvent e) {
            KeepingPopupOpenAction dontClosePopupAction;
            Object selectedValue = this.getList().getSelectedValue();
            ActionPopupStep actionPopupStep = (ActionPopupStep)ObjectUtils.tryCast(this.getListStep(), ActionPopupStep.class);
            if (actionPopupStep != null && (dontClosePopupAction = ActionGroupPopup.getActionByClass(selectedValue, actionPopupStep, KeepingPopupOpenAction.class)) != null) {
                actionPopupStep.performAction((AnAction)dontClosePopupAction, e != null ? e.getModifiers() : 0, e);
                for (ActionItem item : actionPopupStep.getValues()) {
                    this.updateActionItem(item);
                }
                this.getList().repaint();
                return;
            }
            super.handleSelect(handleFinalChoices, e);
        }

        protected void handleToggleAction() {
            Object[] selectedValues = this.getList().getSelectedValues();
            ListPopupStep<Object> listStep = this.getListStep();
            ActionPopupStep actionPopupStep = (ActionPopupStep)ObjectUtils.tryCast(listStep, ActionPopupStep.class);
            if (actionPopupStep == null) {
                return;
            }
            List filtered = ContainerUtil.mapNotNull((Object[])selectedValues, o -> ActionGroupPopup.getActionByClass(o, actionPopupStep, ToggleAction.class));
            for (ToggleAction action : filtered) {
                actionPopupStep.performAction((AnAction)action, 0);
            }
            for (ActionItem item : actionPopupStep.getValues()) {
                this.updateActionItem(item);
            }
            this.getList().repaint();
        }

        @Nullable
        private static <T> T getActionByClass(@Nullable Object value, @NotNull ActionPopupStep actionPopupStep, @NotNull Class<T> actionClass) {
            ActionItem item;
            ActionItem actionItem = item = value instanceof ActionItem ? (ActionItem)value : null;
            if (item == null) {
                return null;
            }
            if (!actionPopupStep.isSelectable(item)) {
                return null;
            }
            return actionClass.isInstance(item.getAction()) ? (T)actionClass.cast(item.getAction()) : null;
        }
    }
}

