/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.ide.util.gotoByName.QuickSearchComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.PopupUpdateProcessorBase;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public abstract class PopupUpdateProcessor
extends PopupUpdateProcessorBase {
    private final Project myProject;

    protected PopupUpdateProcessor(Project project) {
        this.myProject = project;
    }

    public void beforeShown(final @NotNull LightweightWindowEvent windowEvent) {
        final LookupEx activeLookup = LookupManager.getInstance(this.myProject).getActiveLookup();
        if (activeLookup != null) {
            activeLookup.addLookupListener(new LookupListener(){

                public void currentItemChanged(@NotNull LookupEvent event) {
                    if (windowEvent.asPopup().isVisible()) {
                        LookupElement item = event.getItem();
                        if (item != null) {
                            PsiElement targetElement = DocumentationManager.getInstance(PopupUpdateProcessor.this.myProject).getElementFromLookup(activeLookup.getEditor(), activeLookup.getPsiFile());
                            PopupUpdateProcessor.this.updatePopup(targetElement);
                        }
                    } else {
                        activeLookup.removeLookupListener((LookupListener)this);
                    }
                }
            });
        } else {
            HintUpdateSupply supply;
            Component focusedComponent = WindowManagerEx.getInstanceEx().getFocusedComponent(this.myProject);
            QuickSearchComponent quickSearch = PopupUpdateProcessor.findQuickSearchComponent(focusedComponent);
            if (quickSearch != null) {
                quickSearch.registerHint(windowEvent.asPopup());
            } else if (focusedComponent instanceof JComponent && (supply = HintUpdateSupply.getSupply((JComponent)((JComponent)focusedComponent))) != null) {
                supply.registerHint(windowEvent.asPopup());
            }
        }
    }

    private static QuickSearchComponent findQuickSearchComponent(Component c) {
        while (c != null) {
            if (c instanceof QuickSearchComponent) {
                return (QuickSearchComponent)c;
            }
            c = c.getParent();
        }
        return null;
    }
}

