/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorProjectLevelConfigurationManager;
import com.intellij.ui.tabs.FileColorsModel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileColors", storages={@Storage(value="$WORKSPACE_FILE$")})
public class FileColorManagerImpl
extends FileColorManager
implements PersistentStateComponent<Element> {
    public static final String FC_ENABLED = "FileColorsEnabled";
    public static final String FC_TABS_ENABLED = "FileColorsForTabsEnabled";
    public static final String FC_PROJECT_VIEW_ENABLED = "FileColorsForProjectViewEnabled";
    private final Project myProject;
    private final FileColorsModel myModel;
    private FileColorProjectLevelConfigurationManager myProjectLevelConfigurationManager;
    private static final Map<String, Color> ourDefaultColors = ContainerUtil.immutableMapBuilder().put((Object)"Blue", (Object)JBColor.namedColor((String)"FileColor.Blue", (Color)new JBColor(15398655, 5199211))).put((Object)"Green", (Object)JBColor.namedColor((String)"FileColor.Green", (Color)new JBColor(15727335, 4805706))).put((Object)"Orange", (Object)JBColor.namedColor((String)"FileColor.Orange", (Color)new JBColor(16181724, 8413266))).put((Object)"Rose", (Object)JBColor.namedColor((String)"FileColor.Rose", (Color)new JBColor(15916250, 7230299))).put((Object)"Violet", (Object)JBColor.namedColor((String)"FileColor.Violet", (Color)new JBColor(15130865, 5458519))).put((Object)"Yellow", (Object)JBColor.namedColor((String)"FileColor.Yellow", (Color)new JBColor(0xFFFFE4, 5196609))).build();

    public FileColorManagerImpl(@NotNull Project project) {
        this.myProject = project;
        this.myModel = new FileColorsModel(project);
    }

    private void initProjectLevelConfigurations() {
        if (this.myProjectLevelConfigurationManager == null) {
            this.myProjectLevelConfigurationManager = (FileColorProjectLevelConfigurationManager)ServiceManager.getService((Project)this.myProject, FileColorProjectLevelConfigurationManager.class);
        }
    }

    public boolean isEnabled() {
        return FileColorManagerImpl._isEnabled();
    }

    public static boolean _isEnabled() {
        return PropertiesComponent.getInstance().getBoolean(FC_ENABLED, true);
    }

    public void setEnabled(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_ENABLED, enabled, true);
    }

    public void setEnabledForTabs(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_TABS_ENABLED, Boolean.toString(enabled));
    }

    public boolean isEnabledForTabs() {
        return FileColorManagerImpl._isEnabledForTabs();
    }

    public static boolean _isEnabledForTabs() {
        return PropertiesComponent.getInstance().getBoolean(FC_TABS_ENABLED, true);
    }

    public boolean isEnabledForProjectView() {
        return FileColorManagerImpl._isEnabledForProjectView();
    }

    public static boolean _isEnabledForProjectView() {
        return PropertiesComponent.getInstance().getBoolean(FC_PROJECT_VIEW_ENABLED, true);
    }

    public static void setEnabledForProjectView(boolean enabled) {
        PropertiesComponent.getInstance().setValue(FC_PROJECT_VIEW_ENABLED, Boolean.toString(enabled));
    }

    public Element getState(boolean shared) {
        Element element = new Element("state");
        this.myModel.save(element, shared);
        return element;
    }

    @Nullable
    public Color getColor(@NotNull String name) {
        Color color = ourDefaultColors.get(name);
        if (color != null) {
            return color;
        }
        return ColorUtil.fromHex((String)name, null);
    }

    public Element getState() {
        this.initProjectLevelConfigurations();
        return this.getState(false);
    }

    void loadState(Element state, boolean shared) {
        this.myModel.load(state, shared);
    }

    public Collection<String> getColorNames() {
        ArrayList sorted = ContainerUtil.newArrayList(ourDefaultColors.keySet());
        Collections.sort(sorted);
        return sorted;
    }

    public void loadState(@NotNull Element state) {
        this.initProjectLevelConfigurations();
        this.loadState(state, false);
    }

    public boolean isColored(@NotNull String scopeName, boolean shared) {
        return this.myModel.isColored(scopeName, shared);
    }

    @Nullable
    public Color getRendererBackground(VirtualFile vFile) {
        Color fileColor;
        if (vFile == null) {
            return null;
        }
        if (this.isEnabled() && (fileColor = this.getFileColor(vFile)) != null) {
            return fileColor;
        }
        return null;
    }

    @Nullable
    public Color getRendererBackground(PsiFile file2) {
        if (file2 == null) {
            return null;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        return this.getRendererBackground(vFile);
    }

    public void addScopeColor(@NotNull String scopeName, @NotNull String colorName, boolean isProjectLevel) {
        this.myModel.add(scopeName, colorName, isProjectLevel);
    }

    @Nullable
    public Color getFileColor(@NotNull PsiFile file2) {
        this.initProjectLevelConfigurations();
        String colorName = this.myModel.getColor(file2);
        return colorName == null ? null : this.getColor(colorName);
    }

    @Nullable
    public Color getFileColor(@NotNull VirtualFile file2) {
        this.initProjectLevelConfigurations();
        String colorName = this.myModel.getColor(file2, this.getProject());
        return colorName == null ? null : this.getColor(colorName);
    }

    @Nullable
    public Color getScopeColor(@NotNull String scopeName) {
        this.initProjectLevelConfigurations();
        String colorName = this.myModel.getScopeColor(scopeName, this.getProject());
        return colorName == null ? null : this.getColor(colorName);
    }

    public boolean isShared(@NotNull String scopeName) {
        return this.myModel.isProjectLevel(scopeName);
    }

    @NotNull
    FileColorsModel getModel() {
        return this.myModel;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public List<FileColorConfiguration> getApplicationLevelConfigurations() {
        return this.myModel.getLocalConfigurations();
    }

    public List<FileColorConfiguration> getProjectLevelConfigurations() {
        return this.myModel.getProjectLevelConfigurations();
    }

    @Nullable
    public static String getColorName(@NotNull Color color) {
        for (String name : ourDefaultColors.keySet()) {
            if (!color.equals(ourDefaultColors.get(name))) continue;
            return name;
        }
        return null;
    }

    static String getAlias(String text) {
        return UIUtil.isUnderDarcula() && text.equals("Yellow") ? "Brown" : text;
    }
}

