/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.TestsScope;
import com.intellij.psi.search.scope.impl.CustomScopesAggregator;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorName;
import com.intellij.ui.tabs.FileColorConfiguration;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileColorsModel
implements Cloneable {
    public static final String FILE_COLOR = "fileColor";
    private final List<FileColorConfiguration> myApplicationLevelConfigurations = new ArrayList<FileColorConfiguration>();
    private final List<FileColorConfiguration> myProjectLevelConfigurations = new ArrayList<FileColorConfiguration>();
    private final Map<String, String> myPredefinedScopeNameToPropertyKey = new THashMap();
    private final Map<String, String> myPredefinedScopeNameToColor = new THashMap();
    @NotNull
    private final Project myProject;

    FileColorsModel(@NotNull Project project) {
        this.myProject = project;
        this.initPredefinedAndGlobalScopes();
    }

    private FileColorsModel(@NotNull Project project, @NotNull List<FileColorConfiguration> applicationLevel, @NotNull List<FileColorConfiguration> projectLevel) {
        this.myProject = project;
        this.myApplicationLevelConfigurations.addAll(applicationLevel);
        this.myProjectLevelConfigurations.addAll(projectLevel);
        this.initPredefinedAndGlobalScopes();
    }

    private void initPredefinedAndGlobalScopes() {
        String colorName;
        for (NamedScope scope : CustomScopesAggregator.getAllCustomScopes(this.myProject)) {
            String scopeName = scope.getName();
            String string = colorName = scope instanceof FileColorName ? ((FileColorName)scope).colorName() : null;
            if (StringUtil.isEmpty((String)colorName)) continue;
            this.myPredefinedScopeNameToColor.put(scopeName, colorName);
            String propertyKey = NonProjectFilesScope.NAME.equals(scopeName) ? "file.colors.enable.non.project" : (TestsScope.NAME.equals(scopeName) ? "file.colors.enable.tests" : "file.colors.enable.custom." + scopeName);
            this.myPredefinedScopeNameToPropertyKey.put(scopeName, propertyKey);
        }
        PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
        for (String scopeName : this.myPredefinedScopeNameToPropertyKey.keySet()) {
            if (this.findConfiguration(scopeName, false) != null || (colorName = this.getColorNameForScope(propertyComponent, scopeName, this.myPredefinedScopeNameToPropertyKey)).isEmpty()) continue;
            Color color = ColorUtil.fromHex((String)colorName, null);
            String name = color == null ? null : FileColorManagerImpl.getColorName(color);
            this.myApplicationLevelConfigurations.add(new FileColorConfiguration(scopeName, name == null ? colorName : name));
        }
    }

    private String getColorNameForScope(PropertiesComponent propertyComponent, String scopeName, Map<String, String> scopeNameMap) {
        String colorName = propertyComponent.getValue(scopeNameMap.get(scopeName));
        if (colorName == null && (colorName = propertyComponent.getValue(scopeName)) == null) {
            colorName = this.myPredefinedScopeNameToColor.get(scopeName);
        }
        return colorName;
    }

    public void save(@NotNull Element e, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        for (FileColorConfiguration configuration2 : configurations) {
            String propertyKey;
            String scopeName = configuration2.getScopeName();
            String string = propertyKey = isProjectLevel ? null : this.myPredefinedScopeNameToPropertyKey.get(scopeName);
            if (propertyKey == null) {
                configuration2.save(e);
                continue;
            }
            PropertiesComponent propertyComponent = PropertiesComponent.getInstance();
            propertyComponent.setValue(propertyKey, configuration2.getColorName(), this.myPredefinedScopeNameToColor.get(scopeName));
            PropertiesComponent.getInstance().setValue(scopeName, null);
        }
    }

    public void load(@NotNull Element e, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        configurations.clear();
        THashMap predefinedScopeNameToPropertyKey = new THashMap(this.myPredefinedScopeNameToPropertyKey);
        for (Element child2 : e.getChildren(FILE_COLOR)) {
            FileColorConfiguration configuration2 = FileColorConfiguration.load(child2);
            if (configuration2 == null) continue;
            if (!isProjectLevel) {
                predefinedScopeNameToPropertyKey.remove(configuration2.getScopeName());
            }
            configurations.add(configuration2);
        }
        if (!isProjectLevel) {
            PropertiesComponent properties = PropertiesComponent.getInstance();
            for (String scopeName : predefinedScopeNameToPropertyKey.keySet()) {
                String colorName = this.getColorNameForScope(properties, scopeName, (Map<String, String>)predefinedScopeNameToPropertyKey);
                if (StringUtil.isEmpty((String)colorName)) continue;
                configurations.add(new FileColorConfiguration(scopeName, colorName));
            }
        }
    }

    public FileColorsModel clone() throws CloneNotSupportedException {
        ArrayList<FileColorConfiguration> applicationLevel = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration2 : this.myApplicationLevelConfigurations) {
            applicationLevel.add(configuration2.clone());
        }
        ArrayList<FileColorConfiguration> projectLevel = new ArrayList<FileColorConfiguration>();
        for (FileColorConfiguration configuration3 : this.myProjectLevelConfigurations) {
            projectLevel.add(configuration3.clone());
        }
        return new FileColorsModel(this.myProject, applicationLevel, projectLevel);
    }

    public void add(@NotNull FileColorConfiguration configuration2, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations;
        List<FileColorConfiguration> list2 = configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        if (!configurations.contains(configuration2)) {
            configurations.add(configuration2);
        }
    }

    public void add(@NotNull String scopeName, @NotNull String colorName, boolean isProjectLevel) {
        this.add(new FileColorConfiguration(scopeName, colorName), isProjectLevel);
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull String scopeName, boolean isProjectLevel) {
        List<FileColorConfiguration> configurations = isProjectLevel ? this.myProjectLevelConfigurations : this.myApplicationLevelConfigurations;
        for (FileColorConfiguration configuration2 : configurations) {
            if (!scopeName.equals(configuration2.getScopeName())) continue;
            return configuration2;
        }
        return null;
    }

    public boolean isProjectLevel(@NotNull String scopeName) {
        return this.findConfiguration(scopeName, true) != null;
    }

    @Nullable
    public String getColor(@NotNull PsiFile psiFile) {
        if (!psiFile.isValid()) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        return virtualFile == null ? null : this.getColor(virtualFile, psiFile.getProject());
    }

    @Nullable
    public String getColor(@NotNull VirtualFile file2, Project project) {
        if (!file2.isValid()) {
            return null;
        }
        FileColorConfiguration configuration2 = this.findConfiguration(file2);
        if (configuration2 != null && configuration2.isValid(project)) {
            return configuration2.getColorName();
        }
        return null;
    }

    @Nullable
    public String getScopeColor(@NotNull String scopeName, Project project) {
        FileColorConfiguration configuration2 = null;
        for (FileColorConfiguration each : this.getConfigurations()) {
            if (!scopeName.equals(each.getScopeName())) continue;
            configuration2 = each;
            break;
        }
        if (configuration2 != null && configuration2.isValid(project)) {
            return configuration2.getColorName();
        }
        return null;
    }

    @Nullable
    private FileColorConfiguration findConfiguration(@NotNull VirtualFile colored) {
        for (FileColorConfiguration configuration2 : this.getConfigurations()) {
            NamedScope scope = NamedScopesHolder.getScope((Project)this.myProject, (String)configuration2.getScopeName());
            if (scope == null) continue;
            NamedScopesHolder namedScopesHolder = NamedScopesHolder.getHolder((Project)this.myProject, (String)configuration2.getScopeName(), null);
            PackageSet packageSet = scope.getValue();
            if (!(packageSet instanceof PackageSetBase) || namedScopesHolder == null || !((PackageSetBase)packageSet).contains(colored, this.myProject, namedScopesHolder)) continue;
            return configuration2;
        }
        return null;
    }

    @NotNull
    private List<FileColorConfiguration> getConfigurations() {
        return ContainerUtil.concat(this.myApplicationLevelConfigurations, this.myProjectLevelConfigurations);
    }

    public boolean isProjectLevel(@NotNull FileColorConfiguration configuration2) {
        return this.myProjectLevelConfigurations.contains(configuration2);
    }

    public void setConfigurations(@NotNull List<FileColorConfiguration> configurations, boolean isProjectLevel) {
        if (isProjectLevel) {
            this.myProjectLevelConfigurations.clear();
            this.myProjectLevelConfigurations.addAll(configurations);
        } else {
            this.myApplicationLevelConfigurations.clear();
            THashMap predefinedScopeNameToPropertyKey = new THashMap(this.myPredefinedScopeNameToPropertyKey);
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            for (FileColorConfiguration configuration2 : configurations) {
                this.myApplicationLevelConfigurations.add(configuration2);
                String propertyKey = (String)predefinedScopeNameToPropertyKey.remove(configuration2.getScopeName());
                if (propertyKey == null) continue;
                propertiesComponent.setValue(propertyKey, configuration2.getColorName());
            }
            for (String scopeName : predefinedScopeNameToPropertyKey.keySet()) {
                propertiesComponent.setValue((String)predefinedScopeNameToPropertyKey.get(scopeName), "");
                propertiesComponent.setValue(scopeName, null);
            }
        }
    }

    public boolean isColored(@NotNull String scopeName, boolean isProjectLevel) {
        return this.findConfiguration(scopeName, isProjectLevel) != null;
    }

    public List<FileColorConfiguration> getLocalConfigurations() {
        return this.myApplicationLevelConfigurations;
    }

    @NotNull
    public List<FileColorConfiguration> getProjectLevelConfigurations() {
        return this.myProjectLevelConfigurations;
    }
}

