/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tree.TreeVisitor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeNodeVisitor<T>
implements TreeVisitor {
    protected static final Logger LOG = Logger.getInstance(AbstractTreeNodeVisitor.class);
    private final Supplier<? extends T> supplier;
    private final Predicate<? super TreePath> predicate;

    public AbstractTreeNodeVisitor(@NotNull Supplier<? extends T> supplier, @Nullable Predicate<? super TreePath> predicate) {
        this.supplier = supplier;
        this.predicate = predicate;
    }

    @Nullable
    public final T getElement() {
        return this.supplier.get();
    }

    @NotNull
    public TreeVisitor.Action visit(@NotNull TreePath path) {
        T element;
        if (LOG.isTraceEnabled()) {
            LOG.debug("process ", new Object[]{path});
        }
        if ((element = this.getElement()) == null) {
            return TreeVisitor.Action.SKIP_SIBLINGS;
        }
        Object component = path.getLastPathComponent();
        if (component instanceof AbstractTreeNode) {
            return this.visit(path, (AbstractTreeNode)component, element);
        }
        if (component instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)component;
            Object object = node.getUserObject();
            if (object instanceof AbstractTreeNode) {
                return this.visit(path, (AbstractTreeNode)object, element);
            }
            if (object instanceof String) {
                LOG.debug("ignore children: ", new Object[]{object});
            } else {
                LOG.warn(object == null ? "no object" : "unexpected object " + object.getClass());
            }
        } else if (component instanceof String) {
            LOG.debug("ignore children: ", new Object[]{component});
        } else {
            LOG.warn(component == null ? "no component" : "unexpected component " + component.getClass());
        }
        return TreeVisitor.Action.SKIP_CHILDREN;
    }

    @NotNull
    protected TreeVisitor.Action visit(@NotNull TreePath path, @NotNull AbstractTreeNode node, @NotNull T element) {
        if (this.matches(node, element)) {
            LOG.debug("found ", new Object[]{path});
            if (this.predicate == null) {
                return TreeVisitor.Action.INTERRUPT;
            }
            if (this.predicate.test(path)) {
                return TreeVisitor.Action.CONTINUE;
            }
        } else if (this.contains(node, element)) {
            LOG.debug("visit ", new Object[]{path});
            return TreeVisitor.Action.CONTINUE;
        }
        return TreeVisitor.Action.SKIP_CHILDREN;
    }

    protected boolean matches(@NotNull AbstractTreeNode node, @NotNull T element) {
        return node.canRepresent(element);
    }

    protected boolean contains(@NotNull AbstractTreeNode node, @NotNull T element) {
        T content = this.getContent(node);
        return content != null && this.isAncestor(content, element);
    }

    protected T getContent(@NotNull AbstractTreeNode node) {
        return null;
    }

    protected boolean isAncestor(@NotNull T content, @NotNull T element) {
        return false;
    }
}

