/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Invoker;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class TreeCollector<T> {
    private final AtomicReference<List<T>> reference = new AtomicReference();
    private final AtomicLong counter = new AtomicLong();
    private final BiPredicate<? super T, ? super T> predicate;

    private TreeCollector(@NotNull BiPredicate<? super T, ? super T> predicate) {
        this.predicate = predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<T> get() {
        AtomicReference<List<T>> atomicReference = this.reference;
        synchronized (atomicReference) {
            List list2 = this.reference.getAndSet(null);
            return list2 != null ? list2 : Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(@NotNull T object) {
        AtomicReference<List<T>> atomicReference = this.reference;
        synchronized (atomicReference) {
            List<T> list2 = this.reference.get();
            if (list2 == null) {
                this.reference.set((List<T>)new SmartList(object));
            } else {
                for (T parent : list2) {
                    if (!this.predicate.test(parent, object)) continue;
                    return false;
                }
                list2.removeIf(t -> this.predicate.test(object, t));
                list2.add(object);
            }
            return true;
        }
    }

    public void processLater(@NotNull Invoker invoker, @NotNull Consumer<? super List<T>> consumer) {
        long count = this.counter.incrementAndGet();
        invoker.invokeLater(() -> {
            if (count == this.counter.get()) {
                consumer.accept(this.get());
            }
        }, 10);
    }

    public static TreeCollector<VirtualFile> createFileLeafsCollector() {
        return new TreeCollector<VirtualFile>((child2, parent) -> VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child2, (boolean)false));
    }

    public static TreeCollector<VirtualFile> createFileRootsCollector() {
        return new TreeCollector<VirtualFile>((parent, child2) -> VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child2, (boolean)false));
    }

    public static TreeCollector<TreePath> createPathLeafsCollector() {
        return new TreeCollector<TreePath>((child2, parent) -> parent.isDescendant((TreePath)child2));
    }

    public static TreeCollector<TreePath> createPathRootsCollector() {
        return new TreeCollector<TreePath>((parent, child2) -> parent.isDescendant((TreePath)child2));
    }
}

