/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class TreePathUtil {
    @NotNull
    public static TreePath createTreePath(TreePath parent, @NotNull Object component) {
        return parent != null ? parent.pathByAddingChild(component) : new TreePath(component);
    }

    public static String[] convertTreePathToStrings(@NotNull TreePath path) {
        return TreePathUtil.convertTreePathToArray(path, Object::toString, String.class);
    }

    public static Object[] convertTreePathToArray(@NotNull TreePath path) {
        return TreePathUtil.convertTreePathToArray(path, object -> object, Object.class);
    }

    public static Object[] convertTreePathToArray(@NotNull TreePath path, @NotNull Function<Object, Object> converter) {
        return TreePathUtil.convertTreePathToArray(path, converter, Object.class);
    }

    private static <T> T[] convertTreePathToArray(@NotNull TreePath path, @NotNull Function<Object, ? extends T> converter, @NotNull Class<T> type) {
        int count = path.getPathCount();
        if (count <= 0) {
            return null;
        }
        Object[] array = (Object[])Array.newInstance(type, count);
        while (path != null && count > 0) {
            Object component = path.getLastPathComponent();
            if (component == null) {
                return null;
            }
            T object = TreePathUtil.convert(component, converter);
            if (object == null) {
                return null;
            }
            array[--count] = object;
            path = path.getParentPath();
        }
        return path != null || count > 0 ? null : array;
    }

    @SafeVarargs
    public static <T> TreePath convertArrayToTreePath(T ... array) {
        return TreePathUtil.convertArrayToTreePath(array, object -> object);
    }

    public static <T> TreePath convertArrayToTreePath(@NotNull T[] array, @NotNull Function<? super T, Object> converter) {
        return array.length == 0 ? null : TreePathUtil.convertCollectionToTreePath(Arrays.asList(array), converter);
    }

    private static <T> TreePath convertCollectionToTreePath(@NotNull List<? extends T> collection, @NotNull Function<? super T, Object> converter) {
        TreePath path = null;
        for (T object : collection) {
            Object component = TreePathUtil.convert(object, converter);
            if (component == null) {
                return null;
            }
            path = TreePathUtil.createTreePath(path, component);
        }
        return path;
    }

    private static <T> TreePath convertReversedToTreePath(@NotNull List<? extends T> collection, @NotNull Function<? super T, Object> converter) {
        TreePath path = null;
        for (int i = collection.size() - 1; i >= 0; --i) {
            T object = collection.get(i);
            Object component = TreePathUtil.convert(object, converter);
            if (component == null) {
                return null;
            }
            path = TreePathUtil.createTreePath(path, component);
        }
        return path;
    }

    public static TreePath pathToTreeNode(@NotNull TreeNode node) {
        return TreePathUtil.pathToTreeNode(node, object -> object);
    }

    public static TreePath pathToTreeNode(@NotNull TreeNode node, @NotNull Function<? super TreeNode, Object> converter) {
        return TreePathUtil.pathToCustomNode(node, TreeNode::getParent, converter);
    }

    public static <T> TreePath pathToCustomNode(@NotNull T node, @NotNull Function<? super T, ? extends T> getParent) {
        return TreePathUtil.pathToCustomNode(node, getParent, object -> object);
    }

    public static <T> TreePath pathToCustomNode(@NotNull T node, @NotNull Function<? super T, ? extends T> getParent, @NotNull Function<? super T, Object> converter) {
        ArrayList<T> deque = new ArrayList<T>();
        while (node != null) {
            deque.add(node);
            node = getParent.apply(node);
        }
        return TreePathUtil.convertReversedToTreePath(deque, converter);
    }

    private static <I, O> O convert(I object, @NotNull Function<I, O> converter) {
        return object == null ? null : (O)converter.apply(object);
    }

    public static TreeNode toTreeNode(TreePath path) {
        Object component = path == null ? null : path.getLastPathComponent();
        return component instanceof TreeNode ? (TreeNode)component : null;
    }

    @Contract(value="!null->!null")
    public static TreeNode[] toTreeNodes(TreePath ... paths) {
        return paths == null ? null : (TreeNode[])Stream.of(paths).map(TreePathUtil::toTreeNode).filter(Objects::nonNull).toArray(TreeNode[]::new);
    }

    public static TreePath toTreePath(TreeNode node) {
        return node == null ? null : TreePathUtil.pathToTreeNode(node);
    }

    public static TreePath[] toTreePaths(TreeNode ... nodes) {
        return nodes == null ? null : (TreePath[])Stream.of(nodes).map(TreePathUtil::toTreePath).filter(Objects::nonNull).toArray(TreePath[]::new);
    }
}

