/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.project;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProjectFileNode {
    @NotNull
    public Object getRootID();

    @NotNull
    public VirtualFile getVirtualFile();

    default public boolean contains(@NotNull VirtualFile file2, @NotNull AreaInstance area, boolean strict) {
        Object id = this.getRootID();
        if (id instanceof AreaInstance && !id.equals(area)) {
            return false;
        }
        return VfsUtilCore.isAncestor((VirtualFile)this.getVirtualFile(), (VirtualFile)file2, (boolean)strict);
    }

    @Nullable
    public static AreaInstance findArea(@NotNull VirtualFile file2, @Nullable Project project) {
        if (project == null || project.isDisposed() || !file2.isValid()) {
            return null;
        }
        Module module = ProjectFileIndex.getInstance((Project)project).getModuleForFile(file2, false);
        if (module != null) {
            return module.isDisposed() ? null : module;
        }
        if (!Registry.is((String)"projectView.show.base.dir")) {
            return null;
        }
        VirtualFile ancestor = ProjectFileNode.findBaseDir(project);
        return ancestor == null || FileTypeRegistry.getInstance().isFileIgnored(file2) || !VfsUtilCore.isAncestor((VirtualFile)ancestor, (VirtualFile)file2, (boolean)false) ? null : project;
    }

    @Nullable
    public static VirtualFile findBaseDir(@Nullable Project project) {
        if (project == null || project.isDisposed()) {
            return null;
        }
        String path = project.getBasePath();
        return path == null ? null : LocalFileSystem.getInstance().findFileByPath(path);
    }
}

