/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.project;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectFileNodeUpdater {
    private static final Logger LOG = Logger.getInstance(ProjectFileNodeUpdater.class);
    private final Ref<Set<VirtualFile>> reference = new Ref();
    private final Invoker invoker;
    private volatile boolean root;
    private volatile long time;
    private volatile int size;

    public ProjectFileNodeUpdater(@NotNull Project project, @NotNull Invoker invoker) {
        this.invoker = invoker;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)invoker);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                ProjectFileNodeUpdater.this.updateFromRoot();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    VirtualFile parent;
                    if (vFileEvent instanceof VFileCreateEvent) {
                        VFileCreateEvent create2 = (VFileCreateEvent)vFileEvent;
                        ProjectFileNodeUpdater.this.updateFromFile(create2.getParent());
                        continue;
                    }
                    if (vFileEvent instanceof VFileCopyEvent) {
                        VFileCopyEvent copy = (VFileCopyEvent)vFileEvent;
                        ProjectFileNodeUpdater.this.updateFromFile(copy.getNewParent());
                        continue;
                    }
                    if (vFileEvent instanceof VFileMoveEvent) {
                        VFileMoveEvent move = (VFileMoveEvent)vFileEvent;
                        ProjectFileNodeUpdater.this.updateFromFile(move.getNewParent());
                        ProjectFileNodeUpdater.this.updateFromFile(move.getOldParent());
                        ProjectFileNodeUpdater.this.updateFromFile(move.getFile());
                        continue;
                    }
                    VirtualFile file2 = vFileEvent.getFile();
                    if (file2 == null) continue;
                    if (vFileEvent instanceof VFileDeleteEvent && (parent = file2.getParent()) != null) {
                        ProjectFileNodeUpdater.this.updateFromFile(parent);
                    }
                    ProjectFileNodeUpdater.this.updateFromFile(file2);
                }
            }
        });
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event.getNewChild() instanceof PsiWhiteSpace) {
                    return;
                }
                this.childrenChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event.getOldChild() instanceof PsiWhiteSpace) {
                    return;
                }
                this.childrenChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event.getOldChild() instanceof PsiWhiteSpace && event.getNewChild() instanceof PsiWhiteSpace) {
                    return;
                }
                this.childrenChanged(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                ProjectFileNodeUpdater.this.updateFromElement(event.getParent());
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                ProjectFileNodeUpdater.this.updateFromElement(event.getOldParent());
                ProjectFileNodeUpdater.this.updateFromElement(event.getNewParent());
            }

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
            }
        }, (Disposable)invoker);
    }

    public void updateFromRoot() {
        this.updateLater(null);
    }

    public void updateFromFile(@Nullable VirtualFile file2) {
        if (file2 != null) {
            this.updateLater(file2);
        }
    }

    public void updateFromElement(@Nullable PsiElement element) {
        this.updateFromFile(PsiUtilCore.getVirtualFile((PsiElement)element));
    }

    public void updateImmediately(@NotNull Runnable onDone) {
        this.invoker.runOrInvokeLater(() -> this.onInvokerThread(true)).onProcessed(o -> EdtExecutorService.getInstance().execute(onDone));
    }

    protected int getUpdatingDelay() {
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLater(@Nullable VirtualFile file2) {
        boolean start2 = false;
        Ref<Set<VirtualFile>> ref = this.reference;
        synchronized (ref) {
            Set files2 = (Set)this.reference.get();
            if (files2 == null) {
                files2 = new SmartHashSet();
                this.time = System.currentTimeMillis();
                this.reference.set((Object)files2);
                start2 = true;
            }
            if (file2 == null) {
                this.root = true;
            } else if (files2.add(file2) && LOG.isTraceEnabled()) {
                LOG.debug("mark file ", new Object[]{file2, " to update @ ", this.invoker});
            }
            this.size = files2.size();
        }
        if (start2) {
            LOG.debug("start collecting files to update @ ", new Object[]{this.invoker});
            this.invoker.invokeLater(() -> this.onInvokerThread(false), this.getUpdatingDelay());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onInvokerThread(boolean now) {
        boolean fromRoot;
        long startedAt;
        Set files2;
        boolean restart2 = false;
        Ref<Set<VirtualFile>> ref = this.reference;
        synchronized (ref) {
            files2 = (Set)this.reference.get();
            if (files2 == null) {
                LOG.debug("updating queue was already flushed @ ", new Object[]{this.invoker});
                return;
            }
            startedAt = this.time;
            fromRoot = this.root;
            if (fromRoot) {
                this.root = false;
                this.reference.set(null);
            } else if (now || this.size == files2.size()) {
                this.reference.set(null);
            } else {
                restart2 = true;
            }
        }
        if (restart2) {
            LOG.debug("continue collecting files to update @ ", new Object[]{this.invoker});
            this.invoker.invokeLater(() -> this.onInvokerThread(false), this.getUpdatingDelay());
        } else {
            LOG.debug("spent ", new Object[]{System.currentTimeMillis() - startedAt, "ms to collect ", this.size, " files to update @ ", this.invoker});
            this.invoker.runOrInvokeLater(() -> this.updateStructure(fromRoot, files2));
        }
    }

    protected abstract void updateStructure(boolean var1, @NotNull Set<? extends VirtualFile> var2);
}

