/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.ui.tree.BaseTreeModel;
import com.intellij.ui.tree.TreeCollector;
import com.intellij.ui.tree.TreePathUtil;
import com.intellij.ui.tree.project.ProjectFileNode;
import com.intellij.ui.tree.project.ProjectFileNodeUpdater;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectFileTreeModel
extends BaseTreeModel<ProjectFileNode>
implements InvokerSupplier {
    private final Invoker invoker = new Invoker.BackgroundThread((Disposable)this);
    private final ProjectFileNodeUpdater updater;
    private final ProjectNode root;

    public ProjectFileTreeModel(@NotNull Project project) {
        this.root = new ProjectNode(project);
        this.updater = new ProjectFileNodeUpdater(project, this.invoker){

            @Override
            protected void updateStructure(boolean fromRoot, @NotNull Set<? extends VirtualFile> updatedFiles) {
                boolean filtered = ((ProjectFileTreeModel)ProjectFileTreeModel.this).root.filter != null;
                SmartHashSet nodes = fromRoot || filtered ? null : new SmartHashSet();
                ((ProjectFileTreeModel)ProjectFileTreeModel.this).root.children.forEach(child2 -> child2.invalidateChildren(node -> {
                    Node n;
                    if (!updatedFiles.contains(node.file)) {
                        return true;
                    }
                    if (filtered) {
                        node.resetParentVisibility();
                    }
                    if (nodes == null) {
                        return false;
                    }
                    Node node2 = n = node.file.isDirectory() ? node : node.parent;
                    if (n == null) {
                        return false;
                    }
                    Node p = n.parent;
                    while (p != null) {
                        if (nodes.contains((Object)p)) {
                            return false;
                        }
                        p = p.parent;
                    }
                    nodes.add((Object)n);
                    return false;
                }));
                if (nodes != null) {
                    nodes.forEach(node -> {
                        TreePath path = TreePathUtil.pathToCustomNode(node, child2 -> child2.parent);
                        if (path != null) {
                            ProjectFileTreeModel.this.pathChanged(path);
                        }
                    });
                } else {
                    if (fromRoot) {
                        ((ProjectFileTreeModel)ProjectFileTreeModel.this).root.valid = false;
                    }
                    ProjectFileTreeModel.this.pathChanged(null);
                }
            }
        };
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        return this.invoker;
    }

    public boolean isValidThread() {
        return this.invoker.isValidThread();
    }

    public void onValidThread(@NotNull Runnable task2) {
        this.invoker.runOrInvokeLater(task2);
    }

    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.root != object && super.isLeaf(object);
    }

    @Override
    public int getIndexOfChild(Object parent, Object object) {
        Node node = object instanceof Node ? (Node)object : null;
        return node == null || node.parent != parent ? -1 : super.getIndexOfChild(parent, object);
    }

    @Override
    @NotNull
    public List<ProjectFileNode> getChildren(Object object) {
        Node node;
        Node node2 = node = object instanceof Node && this.isValidThread() ? (Node)object : null;
        if (node == null) {
            return Collections.emptyList();
        }
        List<FileNode> children2 = node.getChildren();
        if (children2.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        VirtualFileFilter filter = this.root.filter;
        for (FileNode child2 : children2) {
            if (!(child2 instanceof FileNode) || !this.isVisible(child2, filter)) continue;
            result2.add(child2);
        }
        return result2;
    }

    private boolean isVisible(@NotNull FileNode node, @Nullable VirtualFileFilter filter) {
        if (!node.file.isValid() || this.root.project.isDisposed()) {
            return false;
        }
        if (!this.root.showExcludedFiles && ProjectFileIndex.getInstance((Project)this.root.project).isExcluded(node.file)) {
            return false;
        }
        if (filter == null) {
            return true;
        }
        ThreeState visibility = node.visibility;
        if (visibility == ThreeState.NO) {
            return false;
        }
        if (visibility == ThreeState.YES) {
            return true;
        }
        boolean visible = filter.accept(node.file);
        if (!visible && node.file.isDirectory()) {
            List<FileNode> children2 = node.getChildren();
            visible = !children2.stream().allMatch(child2 -> child2.visibility == ThreeState.NO) && (children2.stream().anyMatch(child2 -> child2.visibility == ThreeState.YES) || children2.stream().anyMatch(child2 -> this.isVisible((FileNode)child2, filter)));
        }
        node.visibility = ThreeState.fromBoolean((boolean)visible);
        return visible;
    }

    public void setFilter(@Nullable VirtualFileFilter filter) {
        this.onValidThread(() -> {
            if (this.root.filter == null && filter == null) {
                return;
            }
            this.root.filter = filter;
            this.root.resetVisibility();
            this.pathChanged(null);
        });
    }

    public void setSettings(boolean showExcludedFiles, boolean showModules) {
        this.onValidThread(() -> {
            if (this.root.showExcludedFiles != showExcludedFiles) {
                if (this.root.filter != null) {
                    this.root.resetVisibility();
                }
                this.root.showExcludedFiles = showExcludedFiles;
                this.root.valid = false;
            }
            if (this.root.showModules != showModules) {
                this.root.showModules = showModules;
                this.root.valid = false;
            }
        });
    }

    private void pathChanged(@Nullable TreePath path) {
        this.onValidThread(() -> this.treeStructureChanged(path, null, null));
    }

    private static class FileNode
    extends Node
    implements ProjectFileNode {
        final VirtualFile file;
        final Object id;

        FileNode(@NotNull VirtualFile file2, @NotNull Object id) {
            this.file = file2;
            this.id = id;
        }

        @Override
        @NotNull
        public Object getRootID() {
            return this.id;
        }

        @Override
        @NotNull
        public VirtualFile getVirtualFile() {
            return this.file;
        }

        public String toString() {
            return this.parent instanceof ProjectNode ? this.file.getPath() : this.file.getName();
        }

        @Override
        @NotNull
        List<FileNode> getChildren(@NotNull List<FileNode> oldList) {
            this.visibility = ThreeState.NO;
            VirtualFile file2 = this.getVirtualFile();
            if (!file2.isValid()) {
                return Collections.emptyList();
            }
            ProjectNode parent = this.findParent(ProjectNode.class);
            if (parent == null) {
                return Collections.emptyList();
            }
            this.visibility = ThreeState.UNSURE;
            VirtualFile[] children2 = file2.getChildren();
            if (children2 == null || children2.length == 0) {
                return Collections.emptyList();
            }
            SmartList list2 = new SmartList();
            Mapper mapper = new Mapper(oldList);
            for (VirtualFile child2 : children2) {
                if (child2.is(VFileProperty.SYMLINK) && VfsUtilCore.isInvalidLink((VirtualFile)child2)) continue;
                Object id = this.getRootID();
                AreaInstance area = ProjectFileNode.findArea(child2, parent.project);
                if (area == null || !(id instanceof VirtualFile) && !area.equals(id)) continue;
                list2.add(mapper.apply(child2, id));
            }
            return list2;
        }

        void invalidateChildren(Predicate<FileNode> validator) {
            if (this.valid || !this.file.isDirectory()) {
                if (validator == null || !validator.test(this)) {
                    validator = null;
                    this.valid = false;
                }
                for (FileNode node : this.children) {
                    node.invalidateChildren(validator);
                }
            }
        }
    }

    private static class ProjectNode
    extends Node {
        volatile VirtualFileFilter filter;
        volatile boolean showExcludedFiles;
        volatile boolean showModules;
        final Project project;

        ProjectNode(@NotNull Project project) {
            this.project = project;
        }

        public String toString() {
            return this.project.getName();
        }

        @Override
        @NotNull
        List<FileNode> getChildren(@NotNull List<FileNode> oldList) {
            SmartList list2 = new SmartList();
            Mapper mapper = new Mapper(oldList);
            if (this.showModules) {
                ProjectNode.visitContentRoots(this.project, (arg_0, arg_1) -> ProjectNode.lambda$getChildren$0((List)list2, mapper, arg_0, arg_1));
            } else {
                TreeCollector<VirtualFile> collector = TreeCollector.createFileRootsCollector();
                ProjectNode.visitContentRoots(this.project, (file2, area) -> collector.add((VirtualFile)file2));
                collector.get().forEach(arg_0 -> ProjectNode.lambda$getChildren$2((List)list2, mapper, arg_0));
            }
            return list2;
        }

        private static void visitContentRoots(@Nullable Project project, @NotNull BiConsumer<? super VirtualFile, ? super AreaInstance> consumer) {
            VirtualFile ancestor = ProjectFileNode.findBaseDir(project);
            if (ancestor != null && project == ProjectFileNode.findArea(ancestor, project)) {
                consumer.accept((VirtualFile)ancestor, (AreaInstance)project);
            }
            if (project != null && !project.isDisposed()) {
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    if (module.isDisposed()) continue;
                    for (VirtualFile file2 : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                        consumer.accept((VirtualFile)file2, (AreaInstance)module);
                    }
                }
            }
        }

        private static /* synthetic */ void lambda$getChildren$2(List list2, Mapper mapper, VirtualFile file2) {
            list2.add(mapper.apply(file2, (Object)file2));
        }

        private static /* synthetic */ void lambda$getChildren$0(List list2, Mapper mapper, VirtualFile file2, AreaInstance area) {
            list2.add(mapper.apply(file2, (Object)area));
        }
    }

    private static abstract class Node {
        volatile Node parent;
        volatile ThreeState visibility;
        volatile List<FileNode> children = Collections.emptyList();
        volatile boolean valid;

        private Node() {
        }

        @NotNull
        abstract List<FileNode> getChildren(@NotNull List<FileNode> var1);

        final List<FileNode> getChildren() {
            List<FileNode> oldList = this.children;
            if (this.valid) {
                return oldList;
            }
            List<FileNode> newList = this.getChildren(oldList);
            oldList.forEach(node -> {
                node.parent = null;
            });
            newList.forEach(node -> {
                node.parent = this;
            });
            this.children = newList;
            this.valid = true;
            return newList;
        }

        final void resetVisibility() {
            this.visibility = null;
            this.children.forEach(Node::resetVisibility);
        }

        final void resetParentVisibility() {
            Node node = this.parent;
            while (node != null) {
                node.visibility = null;
                node = node.parent;
            }
        }

        final <N> N findParent(Class<N> type) {
            Node node = this;
            while (node != null) {
                if (type.isInstance(node)) {
                    return type.cast(node);
                }
                node = node.parent;
            }
            return null;
        }
    }

    private static final class Mapper
    implements BiFunction<VirtualFile, Object, FileNode> {
        private final HashMap<VirtualFile, FileNode> map = new HashMap();

        Mapper(@NotNull List<? extends FileNode> list2) {
            list2.forEach(node -> this.map.put(node.file, (FileNode)node));
        }

        @Override
        @NotNull
        public FileNode apply(VirtualFile file2, Object id) {
            FileNode node = this.map.isEmpty() ? null : this.map.remove(file2);
            return node != null && node.id.equals(id) ? node : new FileNode(file2, id);
        }
    }
}

