/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.ui.tree.ui.Control;
import com.intellij.util.ui.LafIconLookup;
import java.awt.Graphics;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public final class DefaultControl
implements Control {
    private final CompoundIcon collapsedIcon = new CompoundIcon("treeCollapsed");
    private final CompoundIcon expandedIcon = new CompoundIcon("treeExpanded");

    @Override
    @NotNull
    public Icon getIcon(boolean expanded, boolean selected) {
        return expanded ? this.expandedIcon.getIcon(selected) : this.collapsedIcon.getIcon(selected);
    }

    @Override
    public int getWidth() {
        return Math.max(this.expandedIcon.getWidth(), this.collapsedIcon.getWidth());
    }

    @Override
    public int getHeight() {
        return Math.max(this.expandedIcon.getHeight(), this.collapsedIcon.getHeight());
    }

    @Override
    public void paint(@NotNull Graphics g, int x, int y, int width, int height, boolean expanded, boolean selected) {
        Icon icon = this.getIcon(expanded, selected);
        icon.paintIcon(null, g, x + (width - icon.getIconWidth()) / 2, y + (height - icon.getIconHeight()) / 2);
    }

    private static final class CompoundIcon {
        private final Icon defaultIcon;
        private final Icon selectedIcon;

        private CompoundIcon(String name) {
            this.defaultIcon = LafIconLookup.getIcon((String)name);
            this.selectedIcon = LafIconLookup.getSelectedIcon((String)name);
        }

        @NotNull
        private Icon getIcon(boolean selected) {
            return selected ? this.selectedIcon : this.defaultIcon;
        }

        private int getWidth() {
            return Math.max(this.selectedIcon.getIconWidth(), this.defaultIcon.getIconWidth());
        }

        private int getHeight() {
            return Math.max(this.selectedIcon.getIconHeight(), this.defaultIcon.getIconHeight());
        }
    }
}

