/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.execution.filters.FileHyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.actions.ActiveAnnotationGutter;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcs.history.VcsHistoryProviderEx;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotateStackTraceAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(AnnotateStackTraceAction.class);
    private final EditorHyperlinkSupport myHyperlinks;
    private final Editor myEditor;
    private boolean myIsLoading = false;

    public AnnotateStackTraceAction(@NotNull Editor editor, @NotNull EditorHyperlinkSupport hyperlinks) {
        super("Show files modification info", null, AllIcons.Actions.Annotate);
        this.myHyperlinks = hyperlinks;
        this.myEditor = editor;
    }

    public void update(@NotNull AnActionEvent e) {
        boolean isShown = this.myEditor.getGutter().isAnnotationsShown();
        e.getPresentation().setEnabled(!isShown && !this.myIsLoading);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.myIsLoading = true;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myEditor.getProject(), "Getting File History", true){
            private final Object LOCK;
            private final MergingUpdateQueue myUpdateQueue;
            private MyActiveAnnotationGutter myGutter;
            {
                this.LOCK = new Object();
                this.myUpdateQueue = new MergingUpdateQueue("AnnotateStackTraceAction", 200, true, null);
            }

            public void onCancel() {
                AnnotateStackTraceAction.this.myEditor.getGutter().closeAllAnnotations();
            }

            public void onFinished() {
                AnnotateStackTraceAction.this.myIsLoading = false;
                Disposer.dispose((Disposable)this.myUpdateQueue);
            }

            public void run(final @NotNull ProgressIndicator indicator) {
                MultiMap files2lines = new MultiMap();
                final HashMap revisions = ContainerUtil.newHashMap();
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (int line = 0; line < AnnotateStackTraceAction.this.myEditor.getDocument().getLineCount(); ++line) {
                        indicator.checkCanceled();
                        VirtualFile file2 = AnnotateStackTraceAction.getHyperlinkVirtualFile(AnnotateStackTraceAction.this.myHyperlinks.findAllHyperlinksOnLine(line));
                        if (file2 == null) continue;
                        files2lines.putValue((Object)file2, (Object)line);
                    }
                });
                files2lines.entrySet().forEach(entry -> {
                    indicator.checkCanceled();
                    VirtualFile file2 = (VirtualFile)entry.getKey();
                    Collection lines2 = (Collection)entry.getValue();
                    LastRevision revision = this.getLastRevision(file2);
                    if (revision == null) {
                        return;
                    }
                    Object object = this.LOCK;
                    synchronized (object) {
                        for (Integer line : lines2) {
                            revisions.put(line, revision);
                        }
                    }
                    this.myUpdateQueue.queue(new Update("update"){

                        public void run() {
                            this.updateGutter(indicator, revisions);
                        }
                    });
                });
                ApplicationManager.getApplication().invokeLater(() -> this.updateGutter(indicator, revisions));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void updateGutter(@NotNull ProgressIndicator indicator, @NotNull Map<Integer, LastRevision> revisions) {
                HashMap revisionsCopy;
                if (indicator.isCanceled()) {
                    return;
                }
                if (this.myGutter == null) {
                    this.myGutter = new MyActiveAnnotationGutter(this.getProject(), AnnotateStackTraceAction.this.myHyperlinks, indicator);
                    AnnotateStackTraceAction.this.myEditor.getGutter().registerTextAnnotation((TextAnnotationGutterProvider)this.myGutter, (EditorGutterAction)this.myGutter);
                }
                Object object = this.LOCK;
                synchronized (object) {
                    revisionsCopy = ContainerUtil.newHashMap(revisions);
                }
                this.myGutter.updateData(revisionsCopy);
                ((EditorGutterComponentEx)AnnotateStackTraceAction.this.myEditor.getGutter()).revalidateMarkup();
            }

            @Nullable
            private LastRevision getLastRevision(@NotNull VirtualFile file2) {
                try {
                    AbstractVcs vcs = VcsUtil.getVcsFor((Project)AnnotateStackTraceAction.this.myEditor.getProject(), (VirtualFile)file2);
                    if (vcs == null) {
                        return null;
                    }
                    VcsHistoryProvider historyProvider = vcs.getVcsHistoryProvider();
                    if (historyProvider == null) {
                        return null;
                    }
                    FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file2);
                    if (historyProvider instanceof VcsHistoryProviderEx) {
                        VcsFileRevision revision = ((VcsHistoryProviderEx)historyProvider).getLastRevision(filePath);
                        if (revision == null) {
                            return null;
                        }
                        return LastRevision.create(revision);
                    }
                    VcsHistorySession session2 = historyProvider.createSessionFor(filePath);
                    if (session2 == null) {
                        return null;
                    }
                    List list2 = session2.getRevisionList();
                    if (list2 == null || list2.isEmpty()) {
                        return null;
                    }
                    return LastRevision.create((VcsFileRevision)list2.get(0));
                }
                catch (VcsException ignored) {
                    LOG.warn((Throwable)ignored);
                    return null;
                }
            }
        });
    }

    @Nullable
    private static VirtualFile getHyperlinkVirtualFile(@NotNull List<RangeHighlighter> links) {
        RangeHighlighter key = (RangeHighlighter)ContainerUtil.getLastItem(links);
        if (key == null) {
            return null;
        }
        HyperlinkInfo info = EditorHyperlinkSupport.getHyperlinkInfo(key);
        if (!(info instanceof FileHyperlinkInfo)) {
            return null;
        }
        OpenFileDescriptor descriptor = ((FileHyperlinkInfo)info).getDescriptor();
        return descriptor != null ? descriptor.getFile() : null;
    }

    private static class MyActiveAnnotationGutter
    implements ActiveAnnotationGutter {
        @NotNull
        private final Project myProject;
        @NotNull
        private final EditorHyperlinkSupport myHyperlinks;
        @NotNull
        private final ProgressIndicator myIndicator;
        @NotNull
        private Map<Integer, LastRevision> myRevisions = Collections.emptyMap();
        private Date myNewestDate = null;
        private int myMaxDateLength = 0;

        MyActiveAnnotationGutter(@NotNull Project project, @NotNull EditorHyperlinkSupport hyperlinks, @NotNull ProgressIndicator indicator) {
            this.myProject = project;
            this.myHyperlinks = hyperlinks;
            this.myIndicator = indicator;
        }

        public void doAction(int lineNum) {
            LastRevision revision = this.myRevisions.get(lineNum);
            if (revision == null) {
                return;
            }
            VirtualFile file2 = AnnotateStackTraceAction.getHyperlinkVirtualFile(this.myHyperlinks.findAllHyperlinksOnLine(lineNum));
            if (file2 == null) {
                return;
            }
            AbstractVcs vcs = ProjectLevelVcsManager.getInstance((Project)this.myProject).getVcsFor(file2);
            if (vcs != null) {
                VcsRevisionNumber number = revision.getNumber();
                VcsKey vcsKey = vcs.getKeyInstanceMethod();
                ShowAllAffectedGenericAction.showSubmittedFiles((Project)this.myProject, (VcsRevisionNumber)number, (VirtualFile)file2, (VcsKey)vcsKey);
            }
        }

        public Cursor getCursor(int lineNum) {
            return this.myRevisions.containsKey(lineNum) ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor();
        }

        public String getLineText(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            if (revision != null) {
                return String.format("%" + this.myMaxDateLength + "s", DateFormatUtil.formatPrettyDate((Date)revision.getDate())) + " " + revision.getAuthor();
            }
            return "";
        }

        public String getToolTip(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            if (revision != null) {
                return XmlStringUtil.escapeString((String)(revision.getAuthor() + " " + DateFormatUtil.formatDateTime((Date)revision.getDate()) + "\n" + revision.getMessage()));
            }
            return null;
        }

        public EditorFontType getStyle(int line, Editor editor) {
            LastRevision revision = this.myRevisions.get(line);
            return revision != null && revision.getDate().equals(this.myNewestDate) ? EditorFontType.BOLD : EditorFontType.PLAIN;
        }

        public ColorKey getColor(int line, Editor editor) {
            return AnnotationSource.LOCAL.getColor();
        }

        public Color getBgColor(int line, Editor editor) {
            return null;
        }

        public List<AnAction> getPopupActions(int line, Editor editor) {
            return Collections.emptyList();
        }

        public void gutterClosed() {
            this.myIndicator.cancel();
        }

        public void updateData(@NotNull Map<Integer, LastRevision> revisions) {
            this.myRevisions = revisions;
            Date newestDate = null;
            int maxDateLength = 0;
            for (LastRevision revision : this.myRevisions.values()) {
                int length;
                Date date = revision.getDate();
                if (newestDate == null || date.after(newestDate)) {
                    newestDate = date;
                }
                if ((length = DateFormatUtil.formatPrettyDate((Date)date).length()) <= maxDateLength) continue;
                maxDateLength = length;
            }
            this.myNewestDate = newestDate;
            this.myMaxDateLength = maxDateLength;
        }
    }

    private static class LastRevision {
        @NotNull
        private final VcsRevisionNumber myNumber;
        @NotNull
        private final String myAuthor;
        @NotNull
        private final Date myDate;
        @NotNull
        private final String myMessage;

        LastRevision(@NotNull VcsRevisionNumber number, @NotNull String author, @NotNull Date date, @NotNull String message) {
            this.myNumber = number;
            this.myAuthor = author;
            this.myDate = date;
            this.myMessage = message;
        }

        @NotNull
        public static LastRevision create(@NotNull VcsFileRevision revision) {
            VcsRevisionNumber number = revision.getRevisionNumber();
            String author = StringUtil.notNullize((String)revision.getAuthor(), (String)"Unknown");
            Date date = revision.getRevisionDate();
            String message = StringUtil.notNullize((String)revision.getCommitMessage());
            return new LastRevision(number, author, date, message);
        }

        @NotNull
        public VcsRevisionNumber getNumber() {
            return this.myNumber;
        }

        @NotNull
        public String getAuthor() {
            return this.myAuthor;
        }

        @NotNull
        public Date getDate() {
            return this.myDate;
        }

        @NotNull
        public String getMessage() {
            return this.myMessage;
        }
    }
}

