/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewLongNameLocation;
import com.intellij.usageView.UsageViewNodeTextLocation;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UsageViewUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.usageView.UsageViewUtil");

    private UsageViewUtil() {
    }

    @NotNull
    public static String createNodeText(@NotNull PsiElement element) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewNodeTextLocation.INSTANCE);
    }

    @NotNull
    public static String getShortName(@NotNull PsiElement psiElement) {
        LOG.assertTrue(psiElement.isValid(), (Object)psiElement);
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
    }

    @NotNull
    public static String getLongName(@NotNull PsiElement psiElement) {
        LOG.assertTrue(psiElement.isValid(), (Object)psiElement);
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewLongNameLocation.INSTANCE);
    }

    @NotNull
    public static String getType(@NotNull PsiElement psiElement) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)psiElement, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
    }

    private static boolean hasNonCodeUsages(@NotNull UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (!usage.isNonCodeUsage) continue;
            return true;
        }
        return false;
    }

    private static boolean hasUsagesInGeneratedCode(@NotNull UsageInfo[] usages, @NotNull Project project) {
        for (UsageInfo usage : usages) {
            VirtualFile file2 = usage.getVirtualFile();
            if (file2 == null || !GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file2, (Project)project)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasReadOnlyUsages(@NotNull UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            if (usage.isWritable()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static UsageInfo[] removeDuplicatedUsages(@NotNull UsageInfo[] usages) {
        LinkedHashSet<UsageInfo> set2 = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
        String newTextInNonCodeUsage = Arrays.stream(usages).filter(usage -> usage instanceof NonCodeUsageInfo).map(usage -> ((NonCodeUsageInfo)usage).newText).findFirst().orElse(null);
        if (newTextInNonCodeUsage != null) {
            for (UsageInfo usage2 : usages) {
                PsiReference psiReference;
                PsiElement usageElement;
                PsiLanguageInjectionHost context;
                PsiFile file2;
                if (!(usage2 instanceof MoveRenameUsageInfo) || (file2 = usage2.getFile()) == null || (context = InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)file2)) == null || (usageElement = usage2.getElement()) == null || (psiReference = usage2.getReference()) == null) continue;
                int injectionOffsetInMasterFile = InjectedLanguageManager.getInstance((Project)usageElement.getProject()).injectedToHost(usageElement, usageElement.getTextOffset());
                ProperTextRange rangeInElement = usage2.getRangeInElement();
                assert (rangeInElement != null) : usage2;
                TextRange range2 = rangeInElement.shiftRight(injectionOffsetInMasterFile);
                PsiFile containingFile = context.getContainingFile();
                if (containingFile == null) continue;
                set2.remove(NonCodeUsageInfo.create((PsiFile)containingFile, (int)range2.getStartOffset(), (int)range2.getEndOffset(), (PsiElement)((MoveRenameUsageInfo)usage2).getReferencedElement(), (String)newTextInNonCodeUsage));
            }
        }
        return set2.toArray(UsageInfo.EMPTY_ARRAY);
    }

    @NotNull
    public static UsageInfo[] toUsageInfoArray(@NotNull Collection<? extends UsageInfo> collection) {
        int size = collection.size();
        return size == 0 ? UsageInfo.EMPTY_ARRAY : collection.toArray(new UsageInfo[size]);
    }

    @NotNull
    public static PsiElement[] toElements(@NotNull UsageInfo[] usageInfos) {
        return (PsiElement[])ContainerUtil.map2Array((Object[])usageInfos, PsiElement.class, UsageInfo::getElement);
    }

    public static void navigateTo(@NotNull UsageInfo info, boolean requestFocus) {
        int offset = info.getNavigationOffset();
        VirtualFile file2 = info.getVirtualFile();
        Project project = info.getProject();
        if (file2 != null) {
            FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, file2, offset), requestFocus);
        }
    }

    @NotNull
    public static Set<UsageInfo> getNotExcludedUsageInfos(@NotNull UsageView usageView) {
        Set excludedUsages = usageView.getExcludedUsages();
        LinkedHashSet<UsageInfo> usageInfos = new LinkedHashSet<UsageInfo>();
        for (Usage usage : usageView.getUsages()) {
            if (!(usage instanceof UsageInfo2UsageAdapter) || excludedUsages.contains(usage)) continue;
            UsageInfo usageInfo = ((UsageInfo2UsageAdapter)usage).getUsageInfo();
            usageInfos.add(usageInfo);
        }
        return usageInfos;
    }

    public static boolean reportNonRegularUsages(@NotNull UsageInfo[] usages, @NotNull Project project) {
        boolean inGeneratedCode = UsageViewUtil.hasUsagesInGeneratedCode(usages, project);
        if (UsageViewUtil.hasNonCodeUsages(usages) || inGeneratedCode) {
            StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
            if (statusBar != null) {
                statusBar.setInfo(RefactoringBundle.message((String)(inGeneratedCode ? "occurrences.found.in.comments.strings.non.java.files.and.generated.code" : "occurrences.found.in.comments.strings.and.non.java.files")));
            }
            return true;
        }
        return false;
    }
}

