/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usageView.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindSettings;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.UsageView;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class UsageViewContentManagerImpl
extends UsageViewContentManager {
    private final Key<Boolean> REUSABLE_CONTENT_KEY = Key.create((String)"UsageTreeManager.REUSABLE_CONTENT_KEY");
    private final Key<Boolean> NOT_REUSABLE_CONTENT_KEY = Key.create((String)"UsageTreeManager.NOT_REUSABLE_CONTENT_KEY");
    private final Key<UsageView> NEW_USAGE_VIEW_KEY = Key.create((String)"NEW_USAGE_VIEW_KEY");
    private final ContentManager myFindContentManager;

    public UsageViewContentManagerImpl(Project project, ToolWindowManager toolWindowManager) {
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.FIND, true, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
        toolWindow.setHelpId("ideaInterface.find");
        toolWindow.setToHideOnEmptyContent(true);
        toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowFind);
        ((ToolWindowEx)toolWindow).setAdditionalGearActions((ActionGroup)new DefaultActionGroup(new AnAction[]{new DumbAwareToggleAction(FindBundle.message("find.open.in.new.tab.title.action", new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                return FindSettings.getInstance().isShowResultsInSeparateView();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                FindSettings.getInstance().setShowResultsInSeparateView(state);
            }
        }}));
        this.myFindContentManager = toolWindow.getContentManager();
        this.myFindContentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                event.getContent().release();
            }
        });
        new ContentManagerWatcher(toolWindow, this.myFindContentManager);
    }

    @NotNull
    public Content addContent(@NotNull String contentName, boolean reusable, @NotNull JComponent component, boolean toOpenInNewTab, boolean isLockable) {
        return this.addContent(contentName, null, null, reusable, component, toOpenInNewTab, isLockable);
    }

    @NotNull
    public Content addContent(@NotNull String contentName, String tabName, String toolwindowTitle, boolean reusable, @NotNull JComponent component, boolean toOpenInNewTab, boolean isLockable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content selectedContent = this.getSelectedContent();
        boolean bl = selectedContent != null && selectedContent.isPinned();
        Content contentToDelete = null;
        int indexToAdd = -1;
        if (!(toOpenInNewTab |= bl) && reusable) {
            ArrayList contents = ContainerUtil.newArrayList((Object[])this.myFindContentManager.getContents());
            if (selectedContent != null) {
                contents.remove(selectedContent);
                contents.add(selectedContent);
            }
            for (Content content : contents) {
                UsageView usageView;
                if (content.isPinned() || content.getUserData(contentKey) == null || (usageView = (UsageView)content.getUserData(this.NEW_USAGE_VIEW_KEY)) != null && usageView.isSearchInProgress()) continue;
                contentToDelete = content;
                indexToAdd = this.myFindContentManager.getIndexOfContent(contentToDelete);
            }
        }
        Content content = ContentFactory.SERVICE.getInstance().createContent(component, contentName, isLockable);
        content.setTabName(tabName);
        content.setToolwindowTitle(toolwindowTitle);
        content.putUserData(contentKey, (Object)Boolean.TRUE);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        this.myFindContentManager.addContent(content, indexToAdd);
        if (contentToDelete != null) {
            this.myFindContentManager.removeContent(contentToDelete, true);
        }
        this.myFindContentManager.setSelectedContent(content);
        return content;
    }

    public int getReusableContentsCount() {
        return this.getContentCount(true);
    }

    private int getContentCount(boolean reusable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content[] contents = this.myFindContentManager.getContents();
        return (int)Arrays.stream(contents).filter(content -> content.getUserData(contentKey) != null).count();
    }

    public Content getSelectedContent(boolean reusable) {
        Key<Boolean> contentKey = reusable ? this.REUSABLE_CONTENT_KEY : this.NOT_REUSABLE_CONTENT_KEY;
        Content selectedContent = this.myFindContentManager.getSelectedContent();
        return selectedContent == null || selectedContent.getUserData(contentKey) == null ? null : selectedContent;
    }

    public Content getSelectedContent() {
        return this.myFindContentManager == null ? null : this.myFindContentManager.getSelectedContent();
    }

    public void closeContent(@NotNull Content content) {
        this.myFindContentManager.removeContent(content, true);
        content.release();
    }
}

