/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.CachedValueBase;
import com.intellij.util.CachedValueLeakChecker;
import com.intellij.util.CachedValueStabilityChecker;
import com.intellij.util.CachedValuesFactory;
import com.intellij.util.DefaultCachedValuesFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedValuesManagerImpl
extends CachedValuesManager {
    private final Project myProject;
    private final CachedValuesFactory myFactory;

    public CachedValuesManagerImpl(Project project, CachedValuesFactory factory) {
        this.myProject = project;
        this.myFactory = factory == null ? new DefaultCachedValuesFactory(project) : factory;
    }

    @NotNull
    public <T> CachedValue<T> createCachedValue(@NotNull CachedValueProvider<T> provider, boolean trackValue) {
        return this.myFactory.createCachedValue(provider, trackValue);
    }

    @NotNull
    public <T, P> ParameterizedCachedValue<T, P> createParameterizedCachedValue(@NotNull ParameterizedCachedValueProvider<T, P> provider, boolean trackValue) {
        return this.myFactory.createParameterizedCachedValue(provider, trackValue);
    }

    @Nullable
    public <T> T getCachedValue(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        return dataHolder instanceof UserDataHolderEx ? this.getCachedValueFromExHolder((UserDataHolderEx)dataHolder, key, provider, trackValue) : this.getCachedValueFromHolder(dataHolder, key, provider, trackValue);
    }

    private <T> T getCachedValueFromExHolder(@NotNull UserDataHolderEx dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue value = (CachedValue)dataHolder.getUserData(key);
        if (value instanceof CachedValueBase && ((CachedValueBase)value).isFromMyProject(this.myProject)) {
            Getter data = value.getUpToDateOrNull();
            if (data != null) {
                return (T)data.get();
            }
            CachedValueStabilityChecker.checkProvidersEquivalent(provider, value.getValueProvider(), key);
        }
        while (this.isOutdated(value)) {
            if (dataHolder.replace(key, (Object)value, null)) {
                value = null;
                break;
            }
            value = (CachedValue)dataHolder.getUserData(key);
        }
        if (value == null) {
            value = (CachedValue)dataHolder.putUserDataIfAbsent(key, this.freshCachedValue((UserDataHolder)dataHolder, key, provider, trackValue));
        }
        return (T)value.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T getCachedValueFromHolder(@NotNull UserDataHolder dataHolder, @NotNull Key<CachedValue<T>> key, @NotNull CachedValueProvider<T> provider, boolean trackValue) {
        CachedValue<T> value;
        UserDataHolder userDataHolder = dataHolder;
        synchronized (userDataHolder) {
            value = (CachedValue<T>)dataHolder.getUserData(key);
            if (this.isOutdated(value)) {
                value = null;
            }
            if (value == null) {
                value = this.freshCachedValue(dataHolder, key, provider, trackValue);
                dataHolder.putUserData(key, value);
            }
        }
        return (T)value.getValue();
    }

    private <T> CachedValue<T> freshCachedValue(UserDataHolder dh, Key<CachedValue<T>> key, CachedValueProvider<T> provider, boolean trackValue) {
        CachedValueLeakChecker.checkProvider(provider, key, dh);
        CachedValue<T> value = this.createCachedValue(provider, trackValue);
        assert (((CachedValueBase)value).isFromMyProject(this.myProject));
        return value;
    }

    private boolean isOutdated(CachedValue<?> value) {
        return value instanceof CachedValueBase && (!((CachedValueBase)value).isFromMyProject(this.myProject) || CachedValuesManagerImpl.hasOutdatedValue((CachedValueBase)value));
    }

    private static boolean hasOutdatedValue(CachedValueBase base) {
        return !base.hasUpToDateValue() && base.getRawData() != null;
    }
}

