/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.TabbedContentImpl;
import com.intellij.util.ContentsUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentUtilEx
extends ContentsUtil {
    public static void addTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, boolean select) {
        ContentUtilEx.addTabbedContent(manager, contentComponent, groupPrefix, tabName, select, null);
    }

    public static void addTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull String groupPrefix, @NotNull String tabName, boolean select, @Nullable Disposable childDisposable) {
        if (PropertiesComponent.getInstance().getBoolean("tabbed.toolwindow.expanded." + groupPrefix)) {
            Content content = ContentFactory.SERVICE.getInstance().createContent(contentComponent, ContentUtilEx.getFullName(groupPrefix, tabName), true);
            content.putUserData(Content.TABBED_CONTENT_KEY, (Object)Boolean.TRUE);
            content.putUserData(Content.TAB_GROUP_NAME_KEY, (Object)groupPrefix);
            for (Content c : manager.getContents()) {
                if (c.getComponent() != contentComponent) continue;
                if (select) {
                    manager.setSelectedContent(c);
                }
                return;
            }
            ContentUtilEx.addContent((ContentManager)manager, (Content)content, (boolean)select);
            ContentUtilEx.registerDisposable(content, childDisposable, contentComponent);
            return;
        }
        TabbedContent tabbedContent = ContentUtilEx.findTabbedContent(manager, groupPrefix);
        if (tabbedContent == null) {
            Disposable disposable = Disposer.newDisposable();
            tabbedContent = new TabbedContentImpl(contentComponent, tabName, true, groupPrefix);
            ContentsUtil.addOrReplaceContent((ContentManager)manager, (Content)tabbedContent, (boolean)select);
            Disposer.register((Disposable)tabbedContent, (Disposable)disposable);
        } else {
            for (Pair tab : new ArrayList(tabbedContent.getTabs())) {
                if (!Comparing.equal((Object)tab.second, (Object)contentComponent)) continue;
                tabbedContent.removeContent((JComponent)tab.second);
            }
            if (select) {
                manager.setSelectedContent((Content)tabbedContent, true, true);
            }
            tabbedContent.addContent(contentComponent, tabName, true);
        }
        ContentUtilEx.registerDisposable((Content)tabbedContent, childDisposable, contentComponent);
    }

    private static void registerDisposable(@NotNull Content content, @Nullable Disposable childDisposable, @NotNull JComponent contentComponent) {
        if (childDisposable != null) {
            Disposer.register((Disposable)content, (Disposable)childDisposable);
            assert (contentComponent.getClientProperty("TabContentDisposable") == null);
            contentComponent.putClientProperty("TabContentDisposable", childDisposable);
            Disposer.register((Disposable)childDisposable, () -> contentComponent.putClientProperty("TabContentDisposable", null));
        } else {
            Object disposableByKey = contentComponent.getClientProperty("TabContentDisposable");
            if (disposableByKey instanceof Disposable) {
                Disposer.register((Disposable)content, (Disposable)((Disposable)disposableByKey));
            }
        }
    }

    @Nullable
    public static TabbedContent findTabbedContent(@NotNull ContentManager manager, @NotNull String groupPrefix) {
        TabbedContent tabbedContent = null;
        for (Content content : manager.getContents()) {
            if (!(content instanceof TabbedContent) || !content.getTabName().startsWith(ContentUtilEx.getFullPrefix(groupPrefix))) continue;
            tabbedContent = (TabbedContent)content;
            break;
        }
        return tabbedContent;
    }

    public static boolean isContentTab(@NotNull Content content, @NotNull String groupPrefix) {
        return content instanceof TabbedContent && content.getTabName().startsWith(ContentUtilEx.getFullPrefix(groupPrefix)) || groupPrefix.equals(content.getUserData(Content.TAB_GROUP_NAME_KEY));
    }

    @NotNull
    public static String getFullName(@NotNull String groupPrefix, @NotNull String tabName) {
        return ContentUtilEx.getFullPrefix(groupPrefix) + tabName;
    }

    @NotNull
    private static String getFullPrefix(@NotNull String groupPrefix) {
        return groupPrefix + ": ";
    }

    public static boolean selectContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, boolean requestFocus) {
        for (Content content : manager.getContents()) {
            if (content instanceof TabbedContentImpl) {
                boolean found = ((TabbedContentImpl)content).findAndSelectContent(contentComponent);
                if (!found) continue;
                manager.setSelectedContent(content, requestFocus);
                return true;
            }
            if (!Comparing.equal((Object)content.getComponent(), (Object)contentComponent)) continue;
            manager.setSelectedContent(content, requestFocus);
            return true;
        }
        return false;
    }

    @Nullable
    public static JComponent findContentComponent(@NotNull ContentManager manager, @NotNull Condition<? super JComponent> condition) {
        for (Content content : manager.getContents()) {
            if (content instanceof TabbedContentImpl) {
                List<Pair<String, JComponent>> tabs2 = ((TabbedContentImpl)content).getTabs();
                for (Pair<String, JComponent> tab : tabs2) {
                    if (!condition.value(tab.second)) continue;
                    return (JComponent)tab.second;
                }
                continue;
            }
            if (!condition.value((Object)content.getComponent())) continue;
            return content.getComponent();
        }
        return null;
    }

    @Nullable
    private static JComponent findContentComponent(@NotNull TabbedContent tabbedContent, @NotNull Condition<? super JComponent> condition) {
        for (Pair tab : tabbedContent.getTabs()) {
            if (!condition.value(tab.second)) continue;
            return (JComponent)tab.second;
        }
        return null;
    }

    public static boolean closeContentTab(@NotNull ContentManager manager, @NotNull Condition<? super JComponent> condition) {
        for (Content content : manager.getContents()) {
            if (content instanceof TabbedContent && ((TabbedContent)content).hasMultipleTabs()) {
                TabbedContent tabbedContent = (TabbedContent)content;
                JComponent component = ContentUtilEx.findContentComponent(tabbedContent, condition);
                if (component == null) continue;
                tabbedContent.removeContent(component);
                ContentUtilEx.dispose((JComponent)component);
                return true;
            }
            if (!condition.value((Object)content.getComponent())) continue;
            manager.removeContent(content, true);
            return true;
        }
        return false;
    }

    public static int getSelectedTab(@NotNull TabbedContent content) {
        int selectedIndex = content.getSelectedIndex();
        if (selectedIndex != -1) {
            return selectedIndex;
        }
        JComponent current = content.getComponent();
        int index = 0;
        for (Pair tab : content.getTabs()) {
            if (tab.second == current) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static boolean renameTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull String newName) {
        for (Content content : manager.getContents()) {
            String groupPrefix;
            if (content instanceof TabbedContentImpl) {
                if (!((TabbedContentImpl)content).rename(contentComponent, newName)) continue;
                return true;
            }
            if (!Comparing.equal((Object)content.getComponent(), (Object)contentComponent) || (groupPrefix = (String)content.getUserData(Content.TAB_GROUP_NAME_KEY)) == null) continue;
            content.setDisplayName(ContentUtilEx.getFullName(groupPrefix, newName));
            return true;
        }
        return false;
    }
}

