/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.util.SystemProperties;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class JdkBundle {
    private static final String BUNDLED_JDK_DIR_NAME;
    private final File myLocation;
    private final JdkVersionDetector.JdkVersionInfo myVersionInfo;
    private final boolean myBoot;
    private final boolean myBundled;
    private final boolean myJdk;
    @Deprecated
    public static final Bitness runtimeBitness;
    static final /* synthetic */ boolean $assertionsDisabled;

    private JdkBundle(File location, JdkVersionDetector.JdkVersionInfo versionInfo, boolean boot, boolean bundled, boolean jdk) {
        this.myLocation = location;
        this.myVersionInfo = versionInfo;
        this.myBoot = boot;
        this.myBundled = bundled;
        this.myJdk = jdk;
    }

    @NotNull
    public File getLocation() {
        return this.myLocation;
    }

    @NotNull
    public JavaVersion getBundleVersion() {
        return this.myVersionInfo.version;
    }

    @NotNull
    public Bitness getBitness() {
        return this.myVersionInfo.bitness;
    }

    public boolean isBoot() {
        return this.myBoot;
    }

    public boolean isBundled() {
        return this.myBundled;
    }

    public boolean isJdk() {
        return this.myJdk;
    }

    public boolean isOperational() {
        File javaPath;
        File contents;
        if (this.myBoot) {
            return true;
        }
        File home = this.myLocation;
        if (SystemInfo.isMac && (contents = new File(home, "Contents/Home")).isDirectory()) {
            home = contents;
        }
        if (!(javaPath = new File(home, SystemInfo.isWindows ? "bin\\java.exe" : "bin/java")).isFile()) {
            javaPath = new File(home, SystemInfo.isWindows ? "jre\\bin\\java.exe" : "jre/bin/java");
        }
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{javaPath.getPath(), "-version"}));
            return output.getExitCode() == 0;
        }
        catch (ExecutionException e) {
            Logger.getInstance(JdkBundle.class).error((Throwable)e);
            return false;
        }
    }

    @NotNull
    public static JdkBundle createBoot() {
        File home = new File(SystemProperties.getJavaHome());
        JdkBundle bundle = JdkBundle.createBundle(home, true);
        if (!$assertionsDisabled && bundle == null) {
            throw new AssertionError(home);
        }
        return bundle;
    }

    @Nullable
    public static JdkBundle createBundled() {
        return JdkBundle.createBundle(new File(PathManager.getHomePath(), BUNDLED_JDK_DIR_NAME), false);
    }

    @Nullable
    public static JdkBundle createBundle(@NotNull File bundleHome) {
        return JdkBundle.createBundle(bundleHome, false);
    }

    private static JdkBundle createBundle(File bundleHome, boolean boot) {
        JdkVersionDetector.JdkVersionInfo versionInfo;
        File jdk;
        if ("jre".equals(bundleHome.getName()) && new File(jdk = bundleHome.getParentFile(), "lib").isDirectory()) {
            bundleHome = jdk;
        }
        File actualHome = bundleHome;
        if (SystemInfo.isMac) {
            if (actualHome.getName().equals("Home") && actualHome.getParentFile().getName().equals("Contents")) {
                bundleHome = actualHome.getParentFile().getParentFile();
            } else {
                File contents = new File(bundleHome, "Contents/Home");
                if (contents.isDirectory()) {
                    actualHome = contents;
                }
            }
        }
        if ((versionInfo = boot ? new JdkVersionDetector.JdkVersionInfo(JavaVersion.current(), SystemInfo.is64Bit ? Bitness.x64 : Bitness.x32) : JdkVersionDetector.getInstance().detectJdkVersionInfo(actualHome.getPath())) != null) {
            boolean bundled = PathManager.isUnderHomeDirectory((String)bundleHome.getPath());
            boolean jdk2 = JdkUtil.checkForJdk((File)actualHome);
            return new JdkBundle(bundleHome, versionInfo, boot, bundled, jdk2);
        }
        return null;
    }

    @Deprecated
    public String getVisualRepresentation() {
        StringBuilder representation = new StringBuilder();
        representation.append("java ");
        representation.append(this.myVersionInfo.version);
        if (this.myBoot || this.myBundled) {
            representation.append(" [");
            if (this.myBoot) {
                representation.append(this.myBundled ? "boot, " : "boot");
            }
            if (this.myBundled) {
                representation.append("bundled");
            }
            representation.append("]");
        }
        return representation.toString();
    }

    @Deprecated
    public String getBundleName() {
        return "java";
    }

    @Deprecated
    public Version getVersion() {
        JavaVersion v = this.myVersionInfo.version;
        return v.feature <= 8 ? new Version(1, v.feature, 0) : new Version(v.feature, 0, v.update);
    }

    @Deprecated
    public Integer getUpdateNumber() {
        return this.myVersionInfo.version.update;
    }

    @Deprecated
    public static JdkBundle createBundle(@NotNull File jvm, boolean boot, boolean bundled) {
        return JdkBundle.createBundle(jvm, boot, bundled, true);
    }

    @Deprecated
    public static JdkBundle createBundle(@NotNull File jvm, boolean boot, boolean bundled, boolean matchArch) {
        JdkBundle bundle = JdkBundle.createBundle(jvm, boot);
        if (matchArch && bundle != null) {
            Bitness arch;
            Bitness bitness = arch = SystemInfo.is64Bit ? Bitness.x64 : Bitness.x32;
            if (arch != bundle.myVersionInfo.bitness) {
                bundle = null;
            }
        }
        return bundle;
    }

    @Deprecated
    public static File getBundledJDKAbsoluteLocation() {
        return new File(PathManager.getHomePath(), SystemInfo.isMac ? "jdk" : "jre");
    }

    static {
        boolean bl = $assertionsDisabled = !JdkBundle.class.desiredAssertionStatus();
        BUNDLED_JDK_DIR_NAME = SystemInfo.isMac ? "jdk" : (SystemInfo.is64Bit ? "jre64" : (SystemInfo.isWindows ? "jre32" : "jre"));
        runtimeBitness = SystemInfo.is64Bit ? Bitness.x64 : Bitness.x32;
    }
}

