/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinProcessManager;
import com.intellij.ide.actions.CreateDesktopEntryAction;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.sun.jna.IntegerType;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Restarter {
    private static final NotNullLazyValue<Boolean> ourRestartSupported = new AtomicNotNullLazyValue<Boolean>(){

        @NotNull
        protected Boolean compute() {
            String problem = SystemInfo.isWindows ? (!JnaLoader.isLoaded() ? "JNA not loaded" : Restarter.checkRestarter("restarter.exe")) : (SystemInfo.isMac ? (Restarter.getMacOsAppDir() == null ? "not a bundle: " + PathManager.getHomePath() : Restarter.checkRestarter("restarter")) : (SystemInfo.isUnix ? (UnixProcessManager.getCurrentProcessId() <= 0 ? "cannot detect process ID" : (CreateDesktopEntryAction.getLauncherScript() == null ? "cannot find launcher script in " + PathManager.getBinPath() : (PathEnvironmentVariableUtil.findInPath((String)"python") == null && PathEnvironmentVariableUtil.findInPath((String)"python3") == null ? "cannot find neither 'python' nor 'python3' in PATH" : Restarter.checkRestarter("restart.py")))) : "unknown platform: " + SystemInfo.OS_NAME));
            if (problem == null) {
                return true;
            }
            Logger.getInstance(Restarter.class).info("not supported: " + problem);
            return false;
        }
    };

    private Restarter() {
    }

    public static boolean isSupported() {
        return (Boolean)ourRestartSupported.getValue();
    }

    private static String checkRestarter(String restarterName) {
        File restarter = PathManager.findBinFile((String)restarterName);
        return restarter != null && restarter.isFile() && restarter.canExecute() ? null : "not an executable file: " + restarter;
    }

    public static void scheduleRestart(boolean elevate, String ... beforeRestart) throws IOException {
        Logger.getInstance(Restarter.class).info("restart: " + Arrays.toString(beforeRestart));
        if (SystemInfo.isWindows) {
            Restarter.restartOnWindows(elevate, beforeRestart);
        } else if (SystemInfo.isMac) {
            Restarter.restartOnMac(beforeRestart);
        } else if (SystemInfo.isUnix) {
            Restarter.restartOnUnix(beforeRestart);
        } else {
            throw new IOException("Cannot restart application: not supported.");
        }
    }

    private static void restartOnWindows(boolean elevate, String ... beforeRestart) throws IOException {
        File launcher;
        Kernel32 kernel32 = (Kernel32)Native.loadLibrary((String)"kernel32", Kernel32.class);
        Shell32 shell32 = (Shell32)Native.loadLibrary((String)"shell32", Shell32.class);
        int pid = WinProcessManager.getCurrentProcessId();
        IntByReference argc = new IntByReference();
        Pointer argvPtr = shell32.CommandLineToArgvW(kernel32.GetCommandLineW(), argc);
        String[] argv = Restarter.getRestartArgv(argvPtr.getWideStringArray(0L, argc.getValue()));
        kernel32.LocalFree(argvPtr);
        char[] buffer = new char[Short.MAX_VALUE];
        if (kernel32.GetModuleFileNameW(null, buffer, new Kernel32.DWORD(buffer.length)).intValue() > 0) {
            argv[0] = Native.toString((char[])buffer);
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(String.valueOf(pid));
        if (beforeRestart.length > 0) {
            args.add(String.valueOf(beforeRestart.length));
            Collections.addAll(args, beforeRestart);
        }
        if (elevate && (launcher = PathManager.findBinFile((String)"launcher.exe")) != null) {
            args.add(String.valueOf(argv.length + 1));
            args.add(launcher.getPath());
        } else {
            args.add(String.valueOf(argv.length));
        }
        Collections.addAll(args, argv);
        File restarter = PathManager.findBinFile((String)"restarter.exe");
        if (restarter == null) {
            throw new IOException("Can't find restarter.exe; please reinstall the IDE");
        }
        Restarter.runRestarter(restarter, args);
        TimeoutUtil.sleep((long)500L);
    }

    private static String[] getRestartArgv(String[] argv) {
        String mainClass = System.getProperty("idea.main.class.name", "com.intellij.idea.Main");
        int countArgs = argv.length;
        for (int i = argv.length - 1; i >= 0; --i) {
            if (!argv[i].equals(mainClass) && !argv[i].endsWith(".exe")) continue;
            countArgs = i + 1;
            if (!argv[i].endsWith(".exe") || argv[i].indexOf(File.separatorChar) >= 0) break;
            argv[i] = new File(PathManager.getBinPath(), argv[i]).getPath();
            break;
        }
        String[] restartArg = new String[countArgs];
        System.arraycopy(argv, 0, restartArg, 0, countArgs);
        return restartArg;
    }

    private static void restartOnMac(String ... beforeRestart) throws IOException {
        File appDir = Restarter.getMacOsAppDir();
        if (appDir == null) {
            throw new IOException("Application bundle not found: " + PathManager.getHomePath());
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(appDir.getPath());
        Collections.addAll(args, beforeRestart);
        Restarter.runRestarter(new File(PathManager.getBinPath(), "restarter"), args);
    }

    private static File getMacOsAppDir() {
        File appDir = new File(PathManager.getHomePath()).getParentFile();
        return appDir != null && appDir.getName().endsWith(".app") && appDir.isDirectory() ? appDir : null;
    }

    private static void restartOnUnix(String ... beforeRestart) throws IOException {
        String launcherScript = CreateDesktopEntryAction.getLauncherScript();
        if (launcherScript == null) {
            throw new IOException("Launcher script not found in " + PathManager.getBinPath());
        }
        int pid = UnixProcessManager.getCurrentProcessId();
        if (pid <= 0) {
            throw new IOException("Invalid process ID: " + pid);
        }
        File python = PathEnvironmentVariableUtil.findInPath((String)"python");
        if (python == null) {
            python = PathEnvironmentVariableUtil.findInPath((String)"python3");
        }
        if (python == null) {
            throw new IOException("Cannot find neither 'python' nor 'python3' in PATH");
        }
        File script = new File(PathManager.getBinPath(), "restart.py");
        ArrayList<String> args = new ArrayList<String>();
        if ("python".equals(python.getName())) {
            args.add(String.valueOf(pid));
            args.add(launcherScript);
            Collections.addAll(args, beforeRestart);
            Restarter.runRestarter(script, args);
        } else {
            args.add(script.getPath());
            args.add(String.valueOf(pid));
            args.add(launcherScript);
            Collections.addAll(args, beforeRestart);
            Restarter.runRestarter(python, args);
        }
    }

    private static void runRestarter(File restarterFile, List<String> restarterArgs) throws IOException {
        boolean isUpdate = restarterArgs.contains("com.intellij.updater.Runner");
        File restarter = isUpdate ? Restarter.createTempExecutable(restarterFile) : restarterFile;
        restarterArgs.add(0, restarter.getPath());
        Runtime.getRuntime().exec(ArrayUtil.toStringArray(restarterArgs));
    }

    @NotNull
    public static File createTempExecutable(@NotNull File executable) throws IOException {
        File tempDir = new File(PathManager.getSystemPath(), "restart");
        if (!FileUtilRt.createDirectory((File)tempDir)) {
            throw new IOException("Cannot create directory: " + tempDir);
        }
        File copy = new File(tempDir, executable.getName());
        if (!FileUtilRt.ensureCanCreateFile((File)copy) || copy.exists() && !copy.delete()) {
            String prefix = FileUtilRt.getNameWithoutExtension((String)copy.getName());
            String ext = FileUtilRt.getExtension((String)executable.getName());
            String suffix = StringUtil.isEmptyOrSpaces((String)ext) ? ".tmp" : "." + ext;
            copy = FileUtilRt.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)false);
        }
        FileUtilRt.copy((File)executable, (File)copy);
        if (executable.canExecute() && !copy.setExecutable(true)) {
            throw new IOException("Cannot make file executable: " + copy);
        }
        return copy;
    }

    private static interface Shell32
    extends StdCallLibrary {
        public Pointer CommandLineToArgvW(WString var1, IntByReference var2);
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public WString GetCommandLineW();

        public Pointer LocalFree(Pointer var1);

        public DWORD GetModuleFileNameW(Pointer var1, char[] var2, DWORD var3);

        public static class DWORD
        extends IntegerType {
            public static final int SIZE = 4;

            public DWORD() {
                this(0L);
            }

            public DWORD(long value) {
                super(4, value, true);
            }
        }
    }
}

