/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public final class ScrambledOutputStream
extends OutputStream {
    static final int MASK = 170;
    private final OutputStream myOriginalStream;

    public ScrambledOutputStream(@NotNull OutputStream originalStream) {
        this.myOriginalStream = originalStream;
    }

    @Override
    public void write(int b) throws IOException {
        this.myOriginalStream.write(b ^ 0xAA);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] newBytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            newBytes[i] = (byte)(b[off + i] ^ 0xAA);
        }
        this.myOriginalStream.write(newBytes, 0, len);
    }

    @Override
    public void flush() throws IOException {
        this.myOriginalStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.myOriginalStream.close();
    }
}

