/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UrlImpl
implements Url {
    private final String scheme;
    private final String authority;
    private final String path;
    private String decodedPath;
    private final String parameters;
    private String externalForm;
    private UrlImpl withoutParameters;

    @Deprecated
    public UrlImpl(@NotNull String path) {
        this(null, null, path, null);
    }

    UrlImpl(@Nullable String scheme2, @Nullable String authority, @Nullable String path) {
        this(scheme2, authority, path, null);
    }

    UrlImpl(@Nullable String scheme2, @Nullable String authority, @Nullable String path, @Nullable String parameters) {
        this.scheme = scheme2;
        this.authority = authority;
        this.path = StringUtil.notNullize((String)path);
        this.parameters = StringUtil.nullize((String)parameters);
    }

    public Url resolve(@NotNull String subPath) {
        return new UrlImpl(this.scheme, this.authority, this.path.isEmpty() ? subPath : this.path + "/" + subPath, this.parameters);
    }

    @NotNull
    public Url addParameters(@NotNull Map<String, String> parameters) {
        if (parameters.isEmpty()) {
            return this;
        }
        StringBuilder builder2 = new StringBuilder();
        if (this.parameters == null) {
            builder2.append('?');
        } else {
            builder2.append(this.parameters);
            builder2.append('&');
        }
        Urls.encodeParameters(parameters, builder2);
        return new UrlImpl(this.scheme, this.authority, this.path, builder2.toString());
    }

    @NotNull
    public String getPath() {
        if (this.decodedPath == null) {
            this.decodedPath = URLUtil.unescapePercentSequences((String)this.path);
        }
        return this.decodedPath;
    }

    @Nullable
    public String getScheme() {
        return this.scheme;
    }

    @Nullable
    public String getAuthority() {
        return this.authority;
    }

    public boolean isInLocalFileSystem() {
        return "file".equals(this.scheme);
    }

    @Nullable
    public String getParameters() {
        return this.parameters;
    }

    public String toDecodedForm() {
        StringBuilder builder2 = new StringBuilder();
        if (this.scheme != null) {
            builder2.append(this.scheme);
            if (this.authority == null) {
                builder2.append(':');
            } else {
                builder2.append("://");
            }
            if (this.authority != null) {
                builder2.append(this.authority);
            }
        }
        builder2.append(this.getPath());
        if (this.parameters != null) {
            builder2.append(this.parameters);
        }
        return builder2.toString();
    }

    @NotNull
    public String toExternalForm() {
        if (this.externalForm != null) {
            return this.externalForm;
        }
        if ((this.authority == null || !this.path.isEmpty() && this.path.charAt(0) != '/') && !this.isInLocalFileSystem()) {
            return this.toDecodedForm();
        }
        String result2 = Urls.toUriWithoutParameters(this).toASCIIString();
        if (this.parameters != null) {
            result2 = result2 + this.parameters;
        }
        this.externalForm = result2;
        return result2;
    }

    @NotNull
    public Url trimParameters() {
        if (this.parameters == null) {
            return this;
        }
        if (this.withoutParameters == null) {
            this.withoutParameters = new UrlImpl(this.scheme, this.authority, this.path, null);
        }
        return this.withoutParameters;
    }

    public String toString() {
        return this.toExternalForm();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equals((CharSequence)this.scheme, (CharSequence)url.scheme) && StringUtil.equals((CharSequence)this.authority, (CharSequence)url.authority) && this.getPath().equals(url.getPath()) && StringUtil.equals((CharSequence)this.parameters, (CharSequence)url.parameters);
    }

    public boolean equalsIgnoreCase(@Nullable Url o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UrlImpl)) {
            return false;
        }
        UrlImpl url = (UrlImpl)o;
        return StringUtil.equalsIgnoreCase((CharSequence)this.scheme, (CharSequence)url.scheme) && StringUtil.equalsIgnoreCase((CharSequence)this.authority, (CharSequence)url.authority) && this.getPath().equalsIgnoreCase(url.getPath()) && StringUtil.equalsIgnoreCase((CharSequence)this.parameters, (CharSequence)url.parameters);
    }

    public boolean equalsIgnoreParameters(@Nullable Url url) {
        return url != null && this.equals(url.trimParameters());
    }

    private int computeHashCode(boolean caseSensitive) {
        int result2 = UrlImpl.stringHashCode(this.scheme, caseSensitive);
        result2 = 31 * result2 + UrlImpl.stringHashCode(this.authority, caseSensitive);
        result2 = 31 * result2 + UrlImpl.stringHashCode(this.getPath(), caseSensitive);
        result2 = 31 * result2 + UrlImpl.stringHashCode(this.parameters, caseSensitive);
        return result2;
    }

    private static int stringHashCode(@Nullable CharSequence string, boolean caseSensitive) {
        return string == null ? 0 : (caseSensitive ? string.hashCode() : StringUtil.stringHashCodeInsensitive((CharSequence)string));
    }

    public int hashCode() {
        return this.computeHashCode(true);
    }

    public int hashCodeCaseInsensitive() {
        return this.computeHashCode(false);
    }
}

