/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LocalFileUrl;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.Urls;
import com.intellij.util.UrlsKt;
import com.intellij.util.io.URLUtil;
import gnu.trove.TObjectHashingStrategy;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\n\u001a\u00020\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0007J*\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0013J\u0016\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ(\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\b\b\u0002\u0010\u0016\u001a\u00020\u0013H\u0007J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000eH\u0007J\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u001a\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010\u000eH\u0007J$\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010\u000e2\b\u0010\f\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010%\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u000eH\u0007J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u000eH\u0007J\u001a\u0010)\u001a\u00020'2\b\u0010*\u001a\u0004\u0018\u00010\u000e2\u0006\u0010$\u001a\u00020\u000eH\u0007J*\u0010+\u001a\u00020'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010\u000eH\u0007J6\u0010+\u001a\u00020'2\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000e2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0007J\"\u0010+\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010\u000eH\u0007J\u001a\u0010-\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020\u0013H\u0007J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0019\u001a\u00020\u000eH\u0007J\u0012\u00101\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u000eH\u0007J\u0012\u00102\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020 H\u0007J\u0012\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020 H\u0002J\u0010\u00104\u001a\u0002002\u0006\u0010\u0019\u001a\u00020\u0005H\u0007R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00065"}, d2={"Lcom/intellij/util/Urls;", "", "()V", "caseInsensitiveUrlHashingStrategy", "Lgnu/trove/TObjectHashingStrategy;", "Lcom/intellij/util/Url;", "getCaseInsensitiveUrlHashingStrategy", "()Lgnu/trove/TObjectHashingStrategy;", "caseInsensitiveUrlHashingStrategy$delegate", "Lkotlin/Lazy;", "encodeParameters", "", "parameters", "", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "equals", "", "url1", "url2", "caseSensitive", "ignoreParameters", "equalsIgnoreParameters", "url", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "urls", "", "newFromEncoded", "newFromIdea", "", "newFromVirtualFile", "newHttpUrl", "authority", "path", "newLocalFileUrl", "newUnparsable", "Lcom/intellij/util/UrlImpl;", "string", "newUri", "scheme", "newUrl", "rawParameters", "parse", "asLocalIfNoScheme", "parseAsJavaUriWithoutParameters", "Ljava/net/URI;", "parseEncoded", "parseFromIdea", "parseUrl", "toUriWithoutParameters", "intellij.platform.ide.impl"})
public final class Urls {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private static final Lazy caseInsensitiveUrlHashingStrategy$delegate;
    public static final Urls INSTANCE;

    static {
        Urls urls;
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Urls.class), "caseInsensitiveUrlHashingStrategy", "getCaseInsensitiveUrlHashingStrategy()Lgnu/trove/TObjectHashingStrategy;"))};
        INSTANCE = urls = new Urls();
        caseInsensitiveUrlHashingStrategy$delegate = LazyKt.lazy((Function0)caseInsensitiveUrlHashingStrategy.2.INSTANCE);
    }

    @NotNull
    public final TObjectHashingStrategy<Url> getCaseInsensitiveUrlHashingStrategy() {
        Lazy lazy = caseInsensitiveUrlHashingStrategy$delegate;
        Urls urls = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (TObjectHashingStrategy)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final UrlImpl newUri(@Nullable String scheme2, @NotNull String path) {
        return new UrlImpl(scheme2, null, path);
    }

    @JvmStatic
    @NotNull
    public static final UrlImpl newUrl(@NotNull String scheme2, @NotNull String authority, @NotNull String path, @Nullable String rawParameters) {
        return new UrlImpl(scheme2, authority, path, rawParameters);
    }

    @JvmStatic
    @NotNull
    public static final UrlImpl newUrl(@NotNull String scheme2, @NotNull String authority, @NotNull String path, @NotNull Map<String, String> parameters) {
        String parametersString = null;
        Map<String, String> map2 = parameters;
        if (!map2.isEmpty()) {
            StringBuilder result2 = new StringBuilder();
            result2.append("?");
            Urls.encodeParameters(parameters, result2);
            parametersString = result2.toString();
        }
        return new UrlImpl(scheme2, authority, path, parametersString);
    }

    @JvmStatic
    public static final void encodeParameters(@NotNull Map<String, String> parameters, @NotNull StringBuilder result2) {
        int initialSize = result2.length();
        Map<String, String> map2 = parameters;
        for (Map.Entry<String, String> entry : map2.entrySet()) {
            Object object = entry;
            String name = object.getKey();
            object = entry;
            String value = object.getValue();
            if (result2.length() != initialSize) {
                result2.append('&');
            }
            result2.append(URLUtil.encodeURIComponent((String)name));
            if (value == null || !((object = (CharSequence)value).length() > 0)) continue;
            result2.append('=');
            result2.append(URLUtil.encodeURIComponent((String)value));
        }
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull String path) {
        return new LocalFileUrl(FileUtilRt.toSystemIndependentName((String)path));
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull VirtualFile file2) {
        return new LocalFileUrl(file2.getPath());
    }

    @JvmStatic
    @NotNull
    public static final Url newFromEncoded(@NotNull String url) {
        Url result2 = Urls.parseEncoded(url);
        UrlsKt.access$getLOG$p().assertTrue(result2 != null, (Object)url);
        Url url2 = result2;
        if (url2 == null) {
            Intrinsics.throwNpe();
        }
        return url2;
    }

    @JvmStatic
    @Nullable
    public static final Url parseEncoded(@NotNull String url) {
        return Urls.parse(url, false);
    }

    @JvmStatic
    @NotNull
    public static final Url newHttpUrl(@NotNull String authority, @Nullable String path) {
        return Urls.newUrl("http", authority, path);
    }

    @JvmStatic
    @NotNull
    public static final Url newHttpUrl(@NotNull String authority, @Nullable String path, @Nullable String parameters) {
        return new UrlImpl("http", authority, path, parameters);
    }

    @JvmStatic
    @NotNull
    public static final Url newUrl(@NotNull String scheme2, @NotNull String authority, @Nullable String path) {
        return new UrlImpl(scheme2, authority, path);
    }

    @JvmStatic
    @NotNull
    public static final Url newFromIdea(@NotNull CharSequence url) {
        Url result2 = Urls.parseFromIdea(url);
        UrlsKt.access$getLOG$p().assertTrue(result2 != null, (Object)url);
        Url url2 = result2;
        if (url2 == null) {
            Intrinsics.throwNpe();
        }
        return url2;
    }

    @JvmStatic
    @Nullable
    public static final Url parseFromIdea(@NotNull CharSequence url) {
        int n = url.length();
        for (int i = 0; i < n; ++i) {
            char c = url.charAt(i);
            if (c == ':') {
                return INSTANCE.parseUrl(url);
            }
            if (c != '/' && c != '\\') continue;
            return Urls.newLocalFileUrl(((Object)url).toString());
        }
        return Urls.newLocalFileUrl(((Object)url).toString());
    }

    @JvmStatic
    @Nullable
    public static final Url parse(@NotNull String url, boolean asLocalIfNoScheme) {
        CharSequence charSequence = url;
        if (charSequence.length() == 0) {
            return null;
        }
        if (asLocalIfNoScheme && !URLUtil.containsScheme((String)url)) {
            return Urls.newLocalFileUrl(url);
        }
        return INSTANCE.parseUrl(VfsUtilCore.toIdeaUrl((String)url));
    }

    @JvmStatic
    @Nullable
    public static final URI parseAsJavaUriWithoutParameters(@NotNull String url) {
        Url url2 = INSTANCE.parseUrl(url);
        if (url2 == null) {
            return null;
        }
        Url asUrl = url2;
        try {
            return Urls.toUriWithoutParameters(asUrl);
        }
        catch (Exception e) {
            UrlsKt.access$getLOG$p().info("Cannot parse url " + url, (Throwable)e);
            return null;
        }
    }

    private final Url parseUrl(CharSequence url) {
        boolean hasUrlSeparator;
        CharSequence urlToParse = null;
        urlToParse = StringUtil.startsWith((CharSequence)url, (CharSequence)"jar:file://") ? url.subSequence("jar:".length(), url.length()) : url;
        Matcher matcher = UrlsKt.access$getURI_PATTERN$p().matcher(urlToParse);
        if (!matcher.matches()) {
            return null;
        }
        String scheme2 = matcher.group(1);
        if (urlToParse != url) {
            scheme2 = "jar:" + scheme2;
        }
        String authority = StringUtil.nullize((String)matcher.group(3));
        String path = StringUtil.nullize((String)matcher.group(4));
        boolean bl = hasUrlSeparator = !StringUtil.isEmpty((String)matcher.group(2));
        if (authority == null) {
            if (hasUrlSeparator) {
                authority = "";
            }
        } else if (Intrinsics.areEqual((Object)"file", (Object)scheme2) || !hasUrlSeparator) {
            path = path == null ? authority : authority + path;
            String string = authority = hasUrlSeparator ? "" : null;
        }
        if (path != null && (!StringUtil.isEmpty((String)authority) || Intrinsics.areEqual((Object)"file", (Object)scheme2))) {
            path = FileUtil.toCanonicalUriPath((String)path);
        }
        return new UrlImpl(scheme2, authority, path, matcher.group(5));
    }

    @JvmStatic
    @NotNull
    public static final Url newFromVirtualFile(@NotNull VirtualFile file2) {
        if (file2.isInLocalFileSystem()) {
            return Urls.newUri(file2.getFileSystem().getProtocol(), file2.getPath());
        }
        Url url = INSTANCE.parseUrl(file2.getUrl());
        Url url2 = url;
        if (url2 == null) {
            url2 = Urls.newUnparsable(file2.getPath());
        }
        return url2;
    }

    @JvmStatic
    @NotNull
    public static final UrlImpl newUnparsable(@NotNull String string) {
        return new UrlImpl(null, null, string, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<? extends Url> urls, boolean caseSensitive) {
        for (Url url2 : urls) {
            if (!INSTANCE.equals(url, url2, caseSensitive, true)) continue;
            return true;
        }
        return false;
    }

    @JvmStatic
    @JvmOverloads
    public static /* synthetic */ boolean equalsIgnoreParameters$default(Url url, Collection collection, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return Urls.equalsIgnoreParameters(url, collection, bl);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<? extends Url> urls) {
        return Urls.equalsIgnoreParameters$default(url, urls, false, 4, null);
    }

    public final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull VirtualFile file2) {
        if (file2.isInLocalFileSystem()) {
            return url.isInLocalFileSystem() && (SystemInfoRt.isFileSystemCaseSensitive ? Intrinsics.areEqual((Object)url.getPath(), (Object)file2.getPath()) : StringsKt.equals((String)url.getPath(), (String)file2.getPath(), (boolean)true));
        }
        if (url.isInLocalFileSystem()) {
            return false;
        }
        Url fileUrl = this.parseUrl(file2.getUrl());
        return fileUrl != null && fileUrl.equalsIgnoreParameters(url);
    }

    public final boolean equals(@Nullable Url url1, @Nullable Url url2, boolean caseSensitive, boolean ignoreParameters) {
        if (url1 == null || url2 == null) {
            return url1 == url2;
        }
        Url o1 = ignoreParameters ? url1.trimParameters() : url1;
        Url o2 = ignoreParameters ? url2.trimParameters() : url2;
        return caseSensitive ? Intrinsics.areEqual((Object)o1, (Object)o2) : o1.equalsIgnoreCase(o2);
    }

    @JvmStatic
    @NotNull
    public static final URI toUriWithoutParameters(@NotNull Url url) {
        try {
            String externalPath = url.getPath();
            boolean inLocalFileSystem = url.isInLocalFileSystem();
            if (inLocalFileSystem && SystemInfoRt.isWindows && externalPath.charAt(0) != '/') {
                externalPath = '/' + externalPath;
            }
            return new URI(inLocalFileSystem ? "file" : url.getScheme(), inLocalFileSystem ? "" : url.getAuthority(), externalPath, null, null);
        }
        catch (URISyntaxException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    private Urls() {
    }
}

