/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.Invoker;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public interface Command<T>
extends Supplier<T>,
Consumer<T> {

    public static final class Processor {
        public final Invoker foreground;
        public final Invoker background;

        public Processor(@NotNull Invoker foreground, @NotNull Invoker background) {
            this.foreground = foreground;
            this.background = background;
        }

        public <T> void consume(Consumer<? super T> consumer, T value) {
            if (consumer != null) {
                this.foreground.runOrInvokeLater(() -> consumer.accept((Object)value));
            }
        }

        public <T> void process(Command<T> command) {
            if (command != null) {
                this.background.runOrInvokeLater(() -> this.consume(command, command.get()));
            }
        }

        public <T> void process(Supplier<? extends T> supplier, Consumer<? super T> consumer) {
            if (supplier != null) {
                this.background.runOrInvokeLater(() -> this.consume(consumer, supplier.get()));
            } else {
                this.consume(consumer, null);
            }
        }

        public int getTaskCount() {
            if (this.foreground == this.background) {
                return this.background.getTaskCount();
            }
            return this.foreground.getTaskCount() + this.background.getTaskCount();
        }
    }
}

