/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.EventQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Obsolescent;

public abstract class Invoker
implements Disposable {
    private static final int THRESHOLD = Integer.MAX_VALUE;
    private static final Logger LOG = Logger.getInstance(Invoker.class);
    private static final AtomicInteger UID = new AtomicInteger();
    private final ConcurrentHashMap<AsyncPromise<?>, ProgressIndicatorBase> indicators = new ConcurrentHashMap();
    private final AtomicInteger count = new AtomicInteger();
    private final String description;
    private volatile boolean disposed;

    private Invoker(@NotNull String prefix, @NotNull Disposable parent) {
        this.description = UID.getAndIncrement() + ".Invoker." + prefix + ": " + parent;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    public String toString() {
        return this.description;
    }

    public void dispose() {
        this.disposed = true;
        while (!this.indicators.isEmpty()) {
            ((ConcurrentHashMap.KeySetView)this.indicators.keySet()).forEach(AsyncPromise::cancel);
        }
    }

    public abstract boolean isValidThread();

    @NotNull
    public final CancellablePromise<?> invokeLater(@NotNull Runnable task2) {
        return this.invokeLater(task2, 0);
    }

    @NotNull
    public final CancellablePromise<?> invokeLater(@NotNull Runnable task2, int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("delay must be non-negative: " + delay);
        }
        AsyncPromise promise = new AsyncPromise();
        if (this.canInvoke(task2, promise)) {
            this.count.incrementAndGet();
            this.offer(() -> this.invokeSafely(task2, promise, 0), delay);
        }
        return promise;
    }

    @NotNull
    public final CancellablePromise<?> runOrInvokeLater(@NotNull Runnable task2) {
        if (this.isValidThread()) {
            this.count.incrementAndGet();
            AsyncPromise promise = new AsyncPromise();
            this.invokeSafely(task2, promise, 0);
            return promise;
        }
        return this.invokeLater(task2);
    }

    @Deprecated
    public final void invokeLaterIfNeeded(@NotNull Runnable task2) {
        this.runOrInvokeLater(task2);
    }

    public final int getTaskCount() {
        return this.disposed ? 0 : this.count.get();
    }

    abstract void offer(@NotNull Runnable var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSafely(@NotNull Runnable task2, @NotNull AsyncPromise<?> promise, int attempt) {
        try {
            if (this.canInvoke(task2, promise)) {
                if (ApplicationManager.getApplication() == null) {
                    task2.run();
                } else if (EventQueue.isDispatchThread()) {
                    ProgressManager.getInstance().runProcess(task2, (ProgressIndicator)this.indicator(promise));
                } else if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                    if (((ApplicationEx)ApplicationManager.getApplication()).isWriteActionPending()) {
                        throw new ProcessCanceledException();
                    }
                    ProgressManager.getInstance().runProcess(task2, (ProgressIndicator)this.indicator(promise));
                } else {
                    while (!ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(task2, this.indicator(promise))) {
                        if (!Registry.is((String)"invoker.can.yield.to.pending.write.actions")) {
                            throw new ProcessCanceledException();
                        }
                        if (!this.canInvoke(task2, promise)) {
                            return;
                        }
                        ProgressIndicatorUtils.yieldToPendingWriteActions();
                        if (!this.canRestart(task2, promise, attempt)) {
                            return;
                        }
                        LOG.debug("Task is restarted");
                        ++attempt;
                    }
                }
                promise.setResult(null);
            }
        }
        catch (ProcessCanceledException | IndexNotReadyException exception) {
            if (this.canRestart(task2, promise, attempt)) {
                this.count.incrementAndGet();
                int nextAttempt = attempt + 1;
                this.offer(() -> this.invokeSafely(task2, promise, nextAttempt), 10);
                LOG.debug("Task is restarted");
            }
        }
        catch (Throwable throwable) {
            try {
                LOG.error(throwable);
            }
            finally {
                promise.setError(throwable);
            }
        }
        finally {
            this.count.decrementAndGet();
        }
    }

    private boolean canRestart(@NotNull Runnable task2, @NotNull AsyncPromise<?> promise, int attempt) {
        LOG.debug("Task is canceled");
        if (attempt < Integer.MAX_VALUE) {
            return this.canInvoke(task2, promise);
        }
        LOG.warn("Task is always canceled: " + task2);
        promise.setError("timeout");
        return false;
    }

    private boolean canInvoke(@NotNull Runnable task2, @NotNull AsyncPromise<?> promise) {
        Obsolescent obsolescent;
        if (promise.isDone()) {
            LOG.debug("Promise is cancelled: ", new Object[]{promise.isCancelled()});
            return false;
        }
        if (this.disposed) {
            LOG.debug("Invoker is disposed");
            promise.setError("disposed");
            return false;
        }
        if (task2 instanceof Obsolescent && (obsolescent = (Obsolescent)task2).isObsolete()) {
            LOG.debug("Task is obsolete");
            promise.setError("obsolete");
            return false;
        }
        return true;
    }

    @NotNull
    private ProgressIndicatorBase indicator(@NotNull AsyncPromise<?> promise) {
        ProgressIndicatorBase indicator = this.indicators.get(promise);
        if (indicator == null) {
            indicator = new ProgressIndicatorBase(true);
            ProgressIndicatorBase old = this.indicators.put(promise, indicator);
            if (old != null) {
                LOG.error("the same task is running in parallel");
            }
            promise.onProcessed(done -> this.indicators.remove(promise).cancel());
        }
        return indicator;
    }

    private static void schedule(ScheduledExecutorService executor, Runnable runnable2, int delay) {
        if (delay > 0) {
            executor.schedule(runnable2, (long)delay, TimeUnit.MILLISECONDS);
        } else {
            executor.execute(runnable2);
        }
    }

    public static final class BackgroundThread
    extends Invoker {
        private final ScheduledExecutorService executor = AppExecutorUtil.createBoundedScheduledExecutorService((String)this.toString(), (int)1);
        private volatile Thread thread;

        public BackgroundThread(@NotNull Disposable parent) {
            super("Background.Thread", parent);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.executor.shutdown();
        }

        @Override
        public boolean isValidThread() {
            return this.thread == Thread.currentThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            Invoker.schedule(this.executor, () -> {
                if (this.thread != null) {
                    LOG.error("unexpected thread: " + this.thread);
                }
                try {
                    this.thread = Thread.currentThread();
                    runnable2.run();
                }
                finally {
                    this.thread = null;
                }
            }, delay);
        }
    }

    public static final class BackgroundPool
    extends Invoker {
        public BackgroundPool(@NotNull Disposable parent) {
            super("Background.Pool", parent);
        }

        @Override
        public boolean isValidThread() {
            return !EventQueue.isDispatchThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            Invoker.schedule(AppExecutorUtil.getAppScheduledExecutorService(), runnable2, delay);
        }
    }

    public static final class EDT
    extends Invoker {
        public EDT(@NotNull Disposable parent) {
            super("EDT", parent);
        }

        @Override
        public boolean isValidThread() {
            return EventQueue.isDispatchThread();
        }

        @Override
        void offer(@NotNull Runnable runnable2, int delay) {
            if (delay > 0) {
                EdtExecutorService.getScheduledExecutorInstance().schedule(runnable2, (long)delay, TimeUnit.MILLISECONDS);
            } else {
                EdtExecutorService.getInstance().execute(runnable2);
            }
        }
    }
}

