/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.intellij.facet.frameworks.LibrariesDownloadAssistant;
import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.frameworks.beans.ArtifactItem;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileSetVersionsFetcherBase<FS extends DownloadableFileSetDescription, F extends DownloadableFileDescription>
implements DownloadableFileSetVersions<FS> {
    private static final Comparator<DownloadableFileSetDescription> VERSIONS_COMPARATOR = (o1, o2) -> -StringUtil.compareVersionNumbers((String)o1.getVersionString(), (String)o2.getVersionString());
    protected final String myGroupId;
    private final URL[] myLocalUrls;

    public FileSetVersionsFetcherBase(@Nullable String groupId, @NotNull URL[] localUrls) {
        this.myLocalUrls = localUrls;
        this.myGroupId = groupId;
    }

    public void fetchVersions(@NotNull DownloadableFileSetVersions.FileSetVersionsCallback<FS> callback2) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> callback2.onSuccess(this.fetchVersions()));
    }

    @NotNull
    public List<FS> fetchVersions() {
        ApplicationManagerEx.getApplicationEx().assertTimeConsuming();
        Artifact[] versions = this.myGroupId != null ? LibrariesDownloadAssistant.getVersions((String)this.myGroupId, (URL[])this.myLocalUrls) : LibrariesDownloadAssistant.getVersions((URL[])this.myLocalUrls);
        ArrayList<FS> result2 = new ArrayList<FS>();
        for (Artifact version2 : versions) {
            ArtifactItem[] items = version2.getItems();
            ArrayList<F> files2 = new ArrayList<F>();
            for (ArtifactItem item : items) {
                String url = item.getUrl();
                String prefix = version2.getUrlPrefix();
                if (url == null) {
                    if (prefix != null) {
                        url = prefix + item.getName();
                    }
                } else {
                    url = FileSetVersionsFetcherBase.prependPrefix(url, prefix);
                }
                assert (url != null);
                files2.add(this.createFileDescription(item, url, prefix));
            }
            result2.add(this.createVersion(version2, files2));
        }
        Collections.sort(result2, VERSIONS_COMPARATOR);
        return result2;
    }

    @NotNull
    protected static String prependPrefix(@NotNull String url, @Nullable String prefix) {
        if (!url.startsWith("http://") && prefix != null) {
            url = prefix + url;
        }
        return url;
    }

    protected abstract F createFileDescription(ArtifactItem var1, String var2, @Nullable String var3);

    protected abstract FS createVersion(Artifact var1, List<F> var2);
}

