/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.gist.PsiFileGistImpl;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.gist.VirtualFileGistImpl;
import com.intellij.util.io.DataExternalizer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class GistManagerImpl
extends GistManager {
    private static final Logger LOG = Logger.getInstance(GistManagerImpl.class);
    private static final Set<String> ourKnownIds = ContainerUtil.newConcurrentSet();
    private static final String ourPropertyName = "file.gist.reindex.count";
    private final AtomicInteger myReindexCount = new AtomicInteger(PropertiesComponent.getInstance().getInt("file.gist.reindex.count", 0));

    public GistManagerImpl() {
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events.stream().anyMatch(this::shouldDropCache)) {
                    GistManagerImpl.this.invalidateGists();
                }
            }

            private boolean shouldDropCache(VFileEvent e) {
                if (!(e instanceof VFilePropertyChangeEvent)) {
                    return false;
                }
                String propertyName = ((VFilePropertyChangeEvent)e).getPropertyName();
                return propertyName.equals("name") || propertyName.equals("encoding");
            }
        });
    }

    @NotNull
    public <Data> VirtualFileGist<Data> newVirtualFileGist(@NotNull String id, int version2, @NotNull DataExternalizer<Data> externalizer, @NotNull VirtualFileGist.GistCalculator<Data> calcData) {
        if (!ourKnownIds.add(id)) {
            throw new IllegalArgumentException("Gist '" + id + "' is already registered");
        }
        return new VirtualFileGistImpl<Data>(id, version2, externalizer, calcData);
    }

    @NotNull
    public <Data> PsiFileGist<Data> newPsiFileGist(@NotNull String id, int version2, @NotNull DataExternalizer<Data> externalizer, @NotNull NullableFunction<PsiFile, Data> calculator) {
        return new PsiFileGistImpl<Data>(id, version2, externalizer, calculator);
    }

    int getReindexCount() {
        return this.myReindexCount.get();
    }

    public void invalidateData() {
        this.invalidateGists();
        GistManagerImpl.invalidateDependentCaches();
    }

    private void invalidateGists() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invalidating gists", new Throwable());
        }
        PropertiesComponent.getInstance().setValue(ourPropertyName, this.myReindexCount.incrementAndGet(), 0);
    }

    private static void invalidateDependentCaches() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                PsiManager.getInstance((Project)project).dropPsiCaches();
            }
        }, (ModalityState)ModalityState.NON_MODAL);
    }

    public void resetReindexCount() {
        this.myReindexCount.set(0);
        PropertiesComponent.getInstance().unsetValue(ourPropertyName);
    }
}

