/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexableSetContributor;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AdditionalIndexableFileSet
implements IndexableFileSet {
    private final Project myProject;
    private volatile Set<VirtualFile> cachedFiles;
    private volatile Set<VirtualFile> cachedDirectories;
    private volatile IndexableSetContributor[] myExtensions;

    public AdditionalIndexableFileSet(@NotNull Project project, IndexableSetContributor ... extensions) {
        this.myProject = project;
        this.myExtensions = extensions;
    }

    public AdditionalIndexableFileSet(@NotNull Project project) {
        this.myProject = project;
    }

    AdditionalIndexableFileSet(IndexableSetContributor ... extensions) {
        this.myProject = null;
        this.myExtensions = extensions;
    }

    public AdditionalIndexableFileSet() {
        this.myProject = null;
    }

    @NotNull
    private Set<VirtualFile> getDirectories() {
        Set<VirtualFile> directories = this.cachedDirectories;
        if (directories == null || VfsUtilCore.hasInvalidFiles(directories) || VfsUtilCore.hasInvalidFiles(this.cachedFiles)) {
            directories = this.collectFilesAndDirectories();
        }
        return directories;
    }

    @NotNull
    private Set<VirtualFile> collectFilesAndDirectories() {
        if (this.myExtensions == null) {
            this.myExtensions = (IndexableSetContributor[])IndexableSetContributor.EP_NAME.getExtensions();
        }
        THashSet files2 = new THashSet();
        THashSet directories = new THashSet();
        for (IndexableSetContributor contributor : this.myExtensions) {
            for (VirtualFile root : IndexableSetContributor.getRootsToIndex((IndexableSetContributor)contributor)) {
                (root.isDirectory() ? directories : files2).add(root);
            }
            if (this.myProject == null) continue;
            Set projectRoots = IndexableSetContributor.getProjectRootsToIndex((IndexableSetContributor)contributor, (Project)this.myProject);
            for (VirtualFile root : projectRoots) {
                (root.isDirectory() ? directories : files2).add(root);
            }
        }
        this.cachedFiles = files2;
        this.cachedDirectories = directories;
        return directories;
    }

    public boolean isInSet(@NotNull VirtualFile file2) {
        return VfsUtilCore.isUnder((VirtualFile)file2, this.getDirectories()) || this.cachedFiles.contains(file2);
    }

    public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (!AdditionalIndexableFileSet.this.isInSet(file2)) {
                    return false;
                }
                if (!file2.isDirectory()) {
                    iterator.processFile(file2);
                }
                return true;
            }
        });
    }
}

