/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.AppTopics;
import com.intellij.history.LocalHistory;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.startup.ServiceNotReadyException;
import com.intellij.lang.FileASTNode;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.BaseComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbModeAction;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.DumbServiceImpl;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.CollectingContentIterator;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.FlushingDaemon;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiDocumentTransactionListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartFMap;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.gist.GistManager;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.ContentHashesSupport;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.DeletedVirtualFileStub;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexProjectHandler;
import com.intellij.util.indexing.FileBasedIndexScanRunnableCollector;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.GlobalIndexFilter;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexAccessValidator;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexedFilesListener;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.InvertedIndexUtil;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.PerIndexDocumentVersionMap;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import com.intellij.util.indexing.ProjectFilesCondition;
import com.intellij.util.indexing.PsiDependentIndex;
import com.intellij.util.indexing.RebuildStatus;
import com.intellij.util.indexing.SharedIndicesData;
import com.intellij.util.indexing.SilentProgressIndicator;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.StorageGuard;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.UpdateTask;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareMapIndexStorage;
import com.intellij.util.indexing.VfsAwareMapReduceIndex;
import com.intellij.util.indexing.VfsEventsMerger;
import com.intellij.util.indexing.impl.InvertedIndexValueIterator;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Phaser;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedIndexImpl
extends FileBasedIndex
implements BaseComponent,
Disposable {
    static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.FileBasedIndexImpl");
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    private static final NotificationGroup NOTIFICATIONS = new NotificationGroup("Indexing", NotificationDisplayType.BALLOON, false);
    private final List<ID<?, ?>> myIndicesForDirectories = new SmartList();
    private final Map<ID<?, ?>, DocumentUpdateTask> myUnsavedDataUpdateTasks = new ConcurrentHashMap();
    private final Set<ID<?, ?>> myNotRequiringContentIndices = new THashSet();
    private final Set<ID<?, ?>> myRequiringContentIndices = new THashSet();
    private final Set<ID<?, ?>> myPsiDependentIndices = new THashSet();
    private final Set<FileType> myNoLimitCheckTypes = new THashSet();
    private final PerIndexDocumentVersionMap myLastIndexedDocStamps = new PerIndexDocumentVersionMap();
    @NotNull
    private final ChangedFilesCollector myChangedFilesCollector;
    private final List<IndexableFileSet> myIndexableSets = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Map<IndexableFileSet, Project> myIndexableSetToProjectMap = new THashMap();
    private final MessageBusConnection myConnection;
    private final FileDocumentManager myFileDocumentManager;
    private final FileTypeManagerImpl myFileTypeManager;
    private final Set<ID<?, ?>> myUpToDateIndicesForUnsavedOrTransactedDocuments = ContainerUtil.newConcurrentSet();
    private volatile SmartFMap<Document, PsiFile> myTransactionMap = SmartFMap.emptyMap();
    private final boolean myIsUnitTestMode;
    @Nullable
    private ScheduledFuture<?> myFlushingFuture;
    private final AtomicInteger myLocalModCount = new AtomicInteger();
    private final AtomicInteger myFilesModCount = new AtomicInteger();
    private final AtomicInteger myUpdatingFiles = new AtomicInteger();
    private final Set<Project> myProjectsBeingUpdated = ContainerUtil.newConcurrentSet();
    private final IndexAccessValidator myAccessValidator = new IndexAccessValidator();
    private volatile boolean myInitialized;
    private Future<IndexConfiguration> myStateFuture;
    private volatile IndexConfiguration myState;
    private volatile Future<?> myAllIndicesInitializedFuture;
    private final AtomicBoolean myShutdownPerformed = new AtomicBoolean(false);
    private static final ThreadLocal<Integer> myUpToDateCheckState = new ThreadLocal();
    private final ThreadLocal<Boolean> myReentrancyGuard = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final Key<SoftReference<ProjectIndexableFilesFilter>> ourProjectFilesSetKey = Key.create((String)"projectFiles");
    private final Lock myCalcIndexableFilesLock = new ReentrantLock();
    private static final Key<WeakReference<FileContentImpl>> ourFileContentKey = Key.create((String)"unsaved.document.index.content");
    private final StorageGuard myStorageLock = new StorageGuard();
    private volatile boolean myPreviousDataBufferingState;
    private final Object myBufferingStateUpdateLock = new Object();
    static final Key<Boolean> ourPhysicalContentKey = Key.create((String)"physical.content.flag");
    private final VirtualFileUpdateTask myForceUpdateTask = new VirtualFileUpdateTask();
    private final AtomicInteger myForceUpdateRequests = new AtomicInteger();
    private final Lock myReadLock;
    private final Lock myWriteLock;

    private IndexConfiguration getState() {
        IndexConfiguration state;
        if (!this.myInitialized) {
            LOG.error("Unexpected initialization problem");
        }
        if ((state = this.myState) == null) {
            try {
                this.myState = state = this.myStateFuture.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return state;
    }

    public FileBasedIndexImpl(VirtualFileManager vfManager, FileDocumentManager fdm, FileTypeManagerImpl fileTypeManager, @NotNull MessageBus bus) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.myReadLock = lock.readLock();
        this.myWriteLock = lock.writeLock();
        this.myFileDocumentManager = fdm;
        this.myFileTypeManager = fileTypeManager;
        this.myIsUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
        MessageBusConnection connection = bus.connect();
        connection.subscribe(PsiDocumentTransactionListener.TOPIC, (Object)new PsiDocumentTransactionListener(){

            @Override
            public void transactionStarted(@NotNull Document doc, @NotNull PsiFile file2) {
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.plus((Object)doc, (Object)file2);
                FileBasedIndexImpl.this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
            }

            @Override
            public void transactionCompleted(@NotNull Document doc, @NotNull PsiFile file2) {
                FileBasedIndexImpl.this.myTransactionMap = FileBasedIndexImpl.this.myTransactionMap.minus((Object)doc);
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){
            @Nullable
            private Map<FileType, Set<String>> myTypeToExtensionMap;

            public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
                FileBasedIndexImpl.cleanupProcessedFlag();
                this.myTypeToExtensionMap = new THashMap();
                for (FileType type : FileBasedIndexImpl.this.myFileTypeManager.getRegisteredFileTypes()) {
                    this.myTypeToExtensionMap.put(type, this.getExtensions(type));
                }
            }

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                Map<FileType, Set<String>> oldTypeToExtensionsMap = this.myTypeToExtensionMap;
                this.myTypeToExtensionMap = null;
                if (oldTypeToExtensionsMap != null) {
                    THashMap newTypeToExtensionsMap = new THashMap();
                    for (FileType type : FileBasedIndexImpl.this.myFileTypeManager.getRegisteredFileTypes()) {
                        newTypeToExtensionsMap.put(type, this.getExtensions(type));
                    }
                    if (!newTypeToExtensionsMap.keySet().containsAll(oldTypeToExtensionsMap.keySet())) {
                        HashSet<FileType> removedFileTypes = new HashSet<FileType>(oldTypeToExtensionsMap.keySet());
                        removedFileTypes.removeAll(newTypeToExtensionsMap.keySet());
                        this.rebuildAllIndices("The following file types were removed/are no longer associated: " + removedFileTypes);
                        return;
                    }
                    for (Map.Entry entry : oldTypeToExtensionsMap.entrySet()) {
                        FileType fileType = (FileType)entry.getKey();
                        Set strings = (Set)entry.getValue();
                        if (((Set)newTypeToExtensionsMap.get(fileType)).containsAll(strings)) continue;
                        HashSet removedExtensions = new HashSet(strings);
                        removedExtensions.removeAll((Collection)newTypeToExtensionsMap.get(fileType));
                        this.rebuildAllIndices(fileType.getName() + " is no longer associated with extension(s) " + String.join((CharSequence)",", removedExtensions));
                        return;
                    }
                }
            }

            @NotNull
            private Set<String> getExtensions(@NotNull FileType type) {
                THashSet set2 = new THashSet();
                for (FileNameMatcher matcher : FileBasedIndexImpl.this.myFileTypeManager.getAssociations(type)) {
                    set2.add(matcher.getPresentableString());
                }
                return set2;
            }

            private void rebuildAllIndices(@NotNull String reason) {
                FileBasedIndexImpl.this.doClearIndices();
                FileBasedIndexImpl.scheduleIndexRebuild("File type change, " + reason);
            }
        });
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                FileBasedIndexImpl.this.cleanupMemoryStorage(true);
            }

            public void unsavedDocumentsDropped() {
                FileBasedIndexImpl.this.cleanupMemoryStorage(false);
            }
        });
        ApplicationManager.getApplication().addApplicationListener(new ApplicationListener(){

            public void writeActionStarted(@NotNull Object action) {
                FileBasedIndexImpl.this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
            }
        });
        this.myChangedFilesCollector = new ChangedFilesCollector();
        this.myConnection = connection;
        this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this.myChangedFilesCollector);
    }

    @VisibleForTesting
    void doClearIndices() {
        this.waitUntilIndicesAreInitialized();
        IndexingStamp.flushCaches();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            try {
                this.clearIndex(indexId);
            }
            catch (StorageException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    boolean processChangedFiles(@NotNull Project project, @NotNull Processor<? super VirtualFile> processor2) {
        return Stream.concat(this.myChangedFilesCollector.myVfsEventsMerger.getChangedFiles(), this.myChangedFilesCollector.myFilesToUpdate.values().stream()).filter(this.filesToBeIndexedForProjectCondition(project)).distinct().mapToInt(f -> processor2.process(f) ? 1 : 0).allMatch(success2 -> success2 == 1);
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file2, @Nullable FileType fileType) {
        return ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)file2, (FileType)fileType);
    }

    static boolean belongsToScope(VirtualFile file2, VirtualFile restrictedTo, GlobalSearchScope filter) {
        if (!(file2 instanceof VirtualFileWithId) || !file2.isValid()) {
            return false;
        }
        return !(restrictedTo != null && !Comparing.equal((Object)file2, (Object)restrictedTo) || filter != null && restrictedTo == null && !filter.accept(file2));
    }

    public void requestReindex(@NotNull VirtualFile file2) {
        GistManager.getInstance().invalidateData();
        this.myChangedFilesCollector.invalidateIndicesRecursively(file2, true);
        if (this.myInitialized) {
            this.myChangedFilesCollector.ensureUpToDateAsync();
        }
    }

    public void initComponent() {
        long started = System.nanoTime();
        List extensions = IndexInfrastructure.hasIndices() ? FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList() : Collections.emptyList();
        LOG.info("Index exts enumerated:" + (System.nanoTime() - started) / 1000000L + ", number of extensions:" + extensions.size());
        started = System.nanoTime();
        this.myStateFuture = IndexInfrastructure.submitGenesisTask(new FileIndexDataInitialization(extensions));
        LOG.info("Index scheduled:" + (System.nanoTime() - started) / 1000000L);
        if (!IndexInfrastructure.ourDoAsyncIndicesInitialization) {
            this.waitUntilIndicesAreInitialized();
        }
    }

    private void waitUntilIndicesAreInitialized() {
        try {
            this.myStateFuture.get();
        }
        catch (Throwable t) {
            LOG.error(t);
        }
    }

    private static <K, V> boolean registerIndexer(@NotNull FileBasedIndexExtension<K, V> extension, IndexConfiguration state) throws IOException {
        ID name = extension.getName();
        int version2 = extension.getVersion();
        File versionFile = IndexInfrastructure.getVersionFile(name);
        boolean versionChanged = false;
        if (IndexingStamp.versionDiffers(name, version2)) {
            boolean versionFileExisted = versionFile.exists();
            if (versionFileExisted) {
                versionChanged = true;
                LOG.info("Version has changed for index " + name + ". The index will be rebuilt.");
            } else {
                LOG.debug("Index " + name + " will be built.");
            }
            if (extension.hasSnapshotMapping() && versionChanged) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name));
            }
            File rootDir = IndexInfrastructure.getIndexRootDir(name);
            if (versionFileExisted) {
                FileUtil.deleteWithRenaming((File)rootDir);
            }
            IndexingStamp.rewriteVersion(name, version2);
        }
        FileBasedIndexImpl.initIndexStorage(extension, version2, state);
        return versionChanged;
    }

    private static <K, V> void initIndexStorage(@NotNull FileBasedIndexExtension<K, V> extension, int version2, IndexConfiguration state) throws IOException {
        VfsAwareMapIndexStorage storage2 = null;
        ID name = extension.getName();
        boolean contentHashesEnumeratorOk = false;
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                if (extension.hasSnapshotMapping()) {
                    ContentHashesSupport.initContentHashesEnumerator();
                    contentHashesEnumeratorOk = true;
                }
                storage2 = new VfsAwareMapIndexStorage(IndexInfrastructure.getStorageFile(name), extension.getKeyDescriptor(), extension.getValueExternalizer(), extension.getCacheSize(), extension.keyIsUniqueForIndexedFile(), extension.traceKeyHashToVirtualFileMapping());
                FileBasedIndex.InputFilter inputFilter = extension.getInputFilter();
                THashSet addedTypes = new THashSet();
                if (inputFilter instanceof FileBasedIndex.FileTypeSpecificInputFilter) {
                    ((FileBasedIndex.FileTypeSpecificInputFilter)inputFilter).registerFileTypesUsedForIndexing(arg_0 -> FileBasedIndexImpl.lambda$initIndexStorage$2((Set)addedTypes, arg_0));
                }
                state.registerIndex(name, FileBasedIndexImpl.createIndex(extension, new MemoryIndexStorage(storage2, name)), file2 -> file2 instanceof VirtualFileWithId && inputFilter.acceptInput(file2) && !GlobalIndexFilter.isExcludedFromIndexViaFilters(file2, name), version2 + GlobalIndexFilter.getFiltersVersion(name), (Collection<? extends FileType>)addedTypes);
                break;
            }
            catch (Exception e) {
                LOG.info((Throwable)e);
                boolean instantiatedStorage = storage2 != null;
                try {
                    if (storage2 != null) {
                        storage2.close();
                    }
                    storage2 = null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(name));
                if (extension.hasSnapshotMapping() && (!contentHashesEnumeratorOk || instantiatedStorage)) {
                    FileUtil.deleteWithRenaming((File)IndexInfrastructure.getPersistentIndexRootDir(name));
                }
                IndexingStamp.rewriteVersion(name, version2);
                continue;
            }
        }
    }

    private static void saveRegisteredIndicesAndDropUnregisteredOnes(@NotNull Collection<ID<?, ?>> ids) {
        Throwable throwable;
        if (ApplicationManager.getApplication().isDisposed() || !IndexInfrastructure.hasIndices()) {
            return;
        }
        File registeredIndicesFile = new File(PathManager.getIndexRoot(), "registered");
        THashSet indicesToDrop = new THashSet();
        try {
            throwable = null;
            try (Iterator in = new DataInputStream(new BufferedInputStream(new FileInputStream(registeredIndicesFile)));){
                int size = ((DataInputStream)((Object)in)).readInt();
                for (int idx = 0; idx < size; ++idx) {
                    indicesToDrop.add(IOUtil.readString((DataInput)((Object)in)));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException in) {
            // empty catch block
        }
        for (ID<?, ?> key : ids) {
            indicesToDrop.remove(key.getName());
        }
        if (!indicesToDrop.isEmpty()) {
            LOG.info("Dropping indices:" + StringUtil.join((Collection)indicesToDrop, (String)","));
            for (String s : indicesToDrop) {
                FileUtil.deleteWithRenaming((File)IndexInfrastructure.getIndexRootDir(ID.create((String)s)));
            }
        }
        FileUtil.createIfDoesntExist((File)registeredIndicesFile);
        try {
            throwable = null;
            try (DataOutputStream os = new DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(registeredIndicesFile)));){
                os.writeInt(ids.size());
                for (ID<?, ?> id : ids) {
                    IOUtil.writeString((String)id.getName(), (DataOutput)os);
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    private static <K, V> UpdatableIndex<K, V, FileContent> createIndex(@NotNull FileBasedIndexExtension<K, V> extension, @NotNull MemoryIndexStorage<K, V> storage2) throws StorageException, IOException {
        VfsAwareMapReduceIndex index;
        if (extension instanceof CustomImplementationFileBasedIndexExtension) {
            UpdatableIndex custom = ((CustomImplementationFileBasedIndexExtension)extension).createIndexImplementation(extension, storage2);
            if (!(custom instanceof VfsAwareMapReduceIndex)) {
                return custom;
            }
            index = (VfsAwareMapReduceIndex)custom;
        } else {
            index = new VfsAwareMapReduceIndex(extension, storage2);
        }
        return index;
    }

    public void dispose() {
        this.performShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performShutdown() {
        if (!this.myShutdownPerformed.compareAndSet(false, true)) {
            return;
        }
        this.waitUntilAllIndicesAreInitialized();
        try {
            if (this.myFlushingFuture != null) {
                this.myFlushingFuture.cancel(false);
                this.myFlushingFuture = null;
            }
        }
        finally {
            LOG.info("START INDEX SHUTDOWN");
            try {
                PersistentIndicesConfiguration.saveConfiguration();
                for (VirtualFile file2 : this.myChangedFilesCollector.getAllFilesToUpdate()) {
                    if (file2.isValid()) continue;
                    this.removeDataFromIndicesForFile(Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2)), file2);
                }
                IndexingStamp.flushCaches();
                IndexConfiguration state = this.getState();
                for (ID<?, ?> indexId : state.getIndexIDs()) {
                    try {
                        UpdatableIndex<?, ?, FileContent> index = state.getIndex(indexId);
                        assert (index != null);
                        if (!RebuildStatus.isOk(indexId)) {
                            index.clear();
                        }
                        index.dispose();
                    }
                    catch (Throwable throwable) {
                        LOG.info("Problem disposing " + indexId, throwable);
                    }
                }
                ContentHashesSupport.flushContentHashes();
                SharedIndicesData.flushData();
                this.myConnection.disconnect();
            }
            catch (Throwable e) {
                LOG.error("Problems during index shutdown", e);
            }
            LOG.info("END INDEX SHUTDOWN");
        }
    }

    private void waitUntilAllIndicesAreInitialized() {
        try {
            this.waitUntilIndicesAreInitialized();
            this.myAllIndicesInitializedFuture.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void removeDataFromIndicesForFile(int fileId, VirtualFile file2) {
        VirtualFile originalFile = file2 instanceof DeletedVirtualFileStub ? ((DeletedVirtualFileStub)file2).getOriginalFile() : file2;
        List<ID<?, ?>> states = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        if (!states.isEmpty()) {
            ProgressManager.getInstance().executeNonCancelableSection(() -> this.removeFileDataFromIndices(states, fileId, originalFile));
        }
    }

    private void removeFileDataFromIndices(@NotNull Collection<ID<?, ?>> affectedIndices, int inputId, VirtualFile file2) {
        this.removeTransientFileDataFromIndices(affectedIndices, inputId, file2);
        Throwable unexpectedError = null;
        for (ID<?, ?> indexId : affectedIndices) {
            try {
                this.updateSingleIndex(indexId, null, inputId, null);
            }
            catch (ProcessCanceledException pce) {
                LOG.error((Throwable)pce);
            }
            catch (Throwable e) {
                LOG.info(e);
                if (unexpectedError != null) continue;
                unexpectedError = e;
            }
        }
        IndexingStamp.flushCache(inputId);
        if (unexpectedError != null) {
            LOG.error(unexpectedError);
        }
    }

    private void removeTransientFileDataFromIndices(Collection<ID<?, ?>> indices, int inputId, VirtualFile file2) {
        for (ID<?, ?> indexId : indices) {
            MapReduceIndex index = (MapReduceIndex)this.myState.getIndex(indexId);
            assert (index != null);
            index.removeTransientDataForFile(inputId);
        }
        Document document = this.myFileDocumentManager.getCachedDocument(file2);
        if (document != null) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
        }
        if (!this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
            this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
        }
    }

    private void flushAllIndices(long modCount) {
        if (HeavyProcessLatch.INSTANCE.isRunning()) {
            return;
        }
        IndexingStamp.flushCaches();
        IndexConfiguration state = this.getState();
        for (ID<?, ?> indexId : new ArrayList(state.getIndexIDs())) {
            if (HeavyProcessLatch.INSTANCE.isRunning() || modCount != (long)this.myLocalModCount.get()) {
                return;
            }
            try {
                UpdatableIndex<?, ?, FileContent> index = state.getIndex(indexId);
                if (index == null) continue;
                index.flush();
            }
            catch (Throwable e) {
                this.requestRebuild(indexId, e);
            }
        }
        ContentHashesSupport.flushContentHashes();
        SharedIndicesData.flushData();
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull ID<K, ?> indexId, @NotNull Project project) {
        THashSet allKeys = new THashSet();
        this.processAllKeys(indexId, Processors.cancelableCollectProcessor((Collection)allKeys), project);
        return allKeys;
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor2, @Nullable Project project) {
        return this.processAllKeys(indexId, processor2, (GlobalSearchScope)(project == null ? new EverythingGlobalScope() : GlobalSearchScope.allScope((Project)project)), null);
    }

    public <K> boolean processAllKeys(@NotNull ID<K, ?> indexId, @NotNull Processor<? super K> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex<K, ?, FileContent> index = this.getIndex(indexId);
            if (index == null) {
                return true;
            }
            this.ensureUpToDate(indexId, scope.getProject(), scope);
            return index.processAllKeys(processor2, scope, idFilter);
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return false;
    }

    public static <T, E extends Throwable> T disableUpToDateCheckIn(@NotNull ThrowableComputable<T, E> runnable2) throws E {
        FileBasedIndexImpl.disableUpToDateCheckForCurrentThread();
        try {
            Object object = runnable2.compute();
            return (T)object;
        }
        finally {
            FileBasedIndexImpl.enableUpToDateCheckForCurrentThread();
        }
    }

    private static void disableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        myUpToDateCheckState.set(currentValue == null ? 1 : currentValue + 1);
    }

    private static void enableUpToDateCheckForCurrentThread() {
        Integer currentValue = myUpToDateCheckState.get();
        if (currentValue != null) {
            int newValue = currentValue - 1;
            if (newValue != 0) {
                myUpToDateCheckState.set(newValue);
            } else {
                myUpToDateCheckState.remove();
            }
        }
    }

    private static boolean isUpToDateCheckEnabled() {
        Integer value = myUpToDateCheckState.get();
        return value == null || value == 0;
    }

    public <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter) {
        this.ensureUpToDate(indexId, project, filter, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <K> void ensureUpToDate(@NotNull ID<K, ?> indexId, @Nullable Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedFile) {
        block11: {
            ProgressManager.checkCanceled();
            this.myChangedFilesCollector.ensureUpToDate();
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!this.needsFileContentLoading(indexId)) {
                return;
            }
            if (filter == GlobalSearchScope.EMPTY_SCOPE) {
                return;
            }
            if (ActionUtil.isDumbMode((Project)project)) {
                FileBasedIndexImpl.handleDumbMode(project);
            }
            NoAccessDuringPsiEvents.checkCallContext();
            if (this.myReentrancyGuard.get().booleanValue()) {
                return;
            }
            this.myReentrancyGuard.set(Boolean.TRUE);
            try {
                if (!FileBasedIndexImpl.isUpToDateCheckEnabled()) break block11;
                try {
                    if (!RebuildStatus.isOk(indexId)) {
                        throw new ServiceNotReadyException();
                    }
                    this.forceUpdate(project, filter, restrictedFile);
                    this.indexUnsavedDocuments(indexId, project, filter, restrictedFile);
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof StorageException || cause instanceof IOException) {
                        this.scheduleRebuild(indexId, e);
                        break block11;
                    }
                    throw e;
                }
            }
            finally {
                this.myReentrancyGuard.set(Boolean.FALSE);
            }
        }
    }

    private static void handleDumbMode(@Nullable Project project) {
        BackgroundableProcessIndicator indicator;
        ProgressIndicator progressIndicator;
        ProgressManager.checkCanceled();
        if (project != null && (progressIndicator = ProgressManager.getInstance().getProgressIndicator()) instanceof BackgroundableProcessIndicator && (indicator = (BackgroundableProcessIndicator)progressIndicator).getDumbModeAction() == DumbModeAction.WAIT) {
            assert (!ApplicationManager.getApplication().isDispatchThread());
            DumbService.getInstance((Project)project).waitForSmartMode();
            return;
        }
        throw IndexNotReadyException.create(project == null ? null : DumbServiceImpl.getInstance(project).getDumbModeStartTrace());
    }

    @NotNull
    public <K, V> List<V> getValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        Iterator virtualFileIterator;
        VirtualFile restrictToFile = null;
        if (filter instanceof Iterable && (virtualFileIterator = ((Iterable)filter).iterator()).hasNext()) {
            VirtualFile restrictToFileCandidate = (VirtualFile)virtualFileIterator.next();
            if (!virtualFileIterator.hasNext()) {
                restrictToFile = restrictToFileCandidate;
            }
        }
        SmartList values = new SmartList();
        FileBasedIndex.ValueProcessor processor2 = (arg_0, arg_1) -> FileBasedIndexImpl.lambda$getValues$6((List)values, arg_0, arg_1);
        if (restrictToFile != null) {
            this.processValuesInOneFile(indexId, dataKey, restrictToFile, processor2, filter);
        } else {
            this.processValuesInScope(indexId, dataKey, true, filter, null, processor2);
        }
        return values;
    }

    @NotNull
    public <K, V> Collection<VirtualFile> getContainingFiles(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull GlobalSearchScope filter) {
        THashSet files2 = new THashSet();
        this.processValuesInScope(indexId, dataKey, false, filter, null, (arg_0, arg_1) -> FileBasedIndexImpl.lambda$getContainingFiles$7((Set)files2, arg_0, arg_1));
        return files2;
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope filter) {
        return this.processValues(indexId, dataKey, inFile, processor2, filter, null);
    }

    public <K, V> boolean processValues(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile inFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope filter, @Nullable IdFilter idFilter) {
        return inFile != null ? this.processValuesInOneFile(indexId, dataKey, inFile, processor2, filter) : this.processValuesInScope(indexId, dataKey, false, filter, idFilter, processor2);
    }

    public <K, V> long getIndexModificationStamp(ID<K, V> indexId, @NotNull Project project) {
        UpdatableIndex<K, V, FileContent> index = this.getState().getIndex(indexId);
        if (index instanceof MapReduceIndex) {
            this.ensureUpToDate(indexId, project, GlobalSearchScope.allScope((Project)project));
            return ((MapReduceIndex)index).getModificationStamp();
        }
        return -1L;
    }

    public <K, V> boolean processAllValues(@NotNull ID<K, V> indexId, @NotNull K key, @NotNull Project project, @NotNull IdValueProcessor<? super V> processor2) {
        return this.processValueIterator(indexId, key, null, GlobalSearchScope.allScope((Project)project), valueIt -> {
            while (valueIt.hasNext()) {
                Object value = valueIt.next();
                ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                while (inputIdsIterator.hasNext()) {
                    if (!processor2.process(inputIdsIterator.next(), value)) {
                        return false;
                    }
                    ProgressManager.checkCanceled();
                }
            }
            return true;
        });
    }

    @Nullable
    private <K, V, R> R processExceptions(@NotNull ID<K, V> indexId, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope filter, @NotNull ThrowableConvertor<? super UpdatableIndex<K, V, FileContent>, ? extends R, ? extends StorageException> computable) {
        try {
            this.waitUntilIndicesAreInitialized();
            UpdatableIndex index = this.getIndex(indexId);
            if (index == null) {
                return null;
            }
            Project project = filter.getProject();
            this.ensureUpToDate(indexId, project, filter, restrictToFile);
            return (R)this.myAccessValidator.validate(indexId, () -> ConcurrencyUtil.withLock((Lock)index.getReadLock(), () -> computable.convert((Object)index)));
        }
        catch (StorageException e) {
            this.scheduleRebuild(indexId, e);
        }
        catch (RuntimeException e) {
            Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
            if (cause != null) {
                this.scheduleRebuild(indexId, cause);
            }
            throw e;
        }
        return null;
    }

    private <K, V> boolean processValuesInOneFile(@NotNull ID<K, V> indexId, @NotNull K dataKey, @NotNull VirtualFile restrictToFile, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2, @NotNull GlobalSearchScope scope) {
        if (!(restrictToFile instanceof VirtualFileWithId)) {
            return true;
        }
        int restrictedFileId = FileBasedIndexImpl.getFileId((VirtualFile)restrictToFile);
        return this.processValueIterator(indexId, dataKey, restrictToFile, scope, valueIt -> {
            while (valueIt.hasNext()) {
                Object value = valueIt.next();
                if (valueIt.getValueAssociationPredicate().contains(restrictedFileId) && !processor2.process(restrictToFile, value)) {
                    return false;
                }
                ProgressManager.checkCanceled();
            }
            return true;
        });
    }

    private <K, V> boolean processValuesInScope(@NotNull ID<K, V> indexId, @NotNull K dataKey, boolean ensureValueProcessedOnce, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter, @NotNull FileBasedIndex.ValueProcessor<? super V> processor2) {
        PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
        IdFilter filter = idFilter != null ? idFilter : this.projectIndexableFiles(scope.getProject());
        return this.processValueIterator(indexId, dataKey, null, scope, valueIt -> {
            block0: while (valueIt.hasNext()) {
                Object value = valueIt.next();
                ValueContainer.IntIterator inputIdsIterator = valueIt.getInputIdsIterator();
                while (inputIdsIterator.hasNext()) {
                    int id = inputIdsIterator.next();
                    if (filter != null && !filter.containsFileId(id)) continue;
                    VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(fs, id);
                    if (file2 != null && scope.accept(file2)) {
                        if (!processor2.process(file2, value)) {
                            return false;
                        }
                        if (ensureValueProcessedOnce) {
                            ProgressManager.checkCanceled();
                            continue block0;
                        }
                    }
                    ProgressManager.checkCanceled();
                }
            }
            return true;
        });
    }

    private <K, V> boolean processValueIterator(@NotNull ID<K, V> indexId, @NotNull K dataKey, @Nullable VirtualFile restrictToFile, @NotNull GlobalSearchScope scope, @NotNull Processor<? super InvertedIndexValueIterator<V>> valueProcessor) {
        Boolean result2 = (Boolean)this.processExceptions(indexId, restrictToFile, scope, index -> valueProcessor.process((Object)((InvertedIndexValueIterator)index.getData(dataKey).getValueIterator())));
        return result2 == null || result2 != false;
    }

    public <K, V> boolean processFilesContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter, @Nullable Condition<? super V> valueChecker, @NotNull Processor<? super VirtualFile> processor2) {
        ProjectIndexableFilesFilter filesSet = this.projectIndexableFiles(filter.getProject());
        TIntHashSet set2 = this.collectFileIdsContainingAllKeys(indexId, dataKeys, filter, valueChecker, filesSet);
        return set2 != null && FileBasedIndexImpl.processVirtualFiles(set2, filter, processor2);
    }

    void filesUpdateEnumerationFinished() {
    }

    public void cleanupForNextTest() {
        this.myChangedFilesCollector.ensureUpToDate();
        this.myTransactionMap = SmartFMap.emptyMap();
        IndexConfiguration state = this.getState();
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            MapReduceIndex index = (MapReduceIndex)state.getIndex(indexId);
            assert (index != null);
            MemoryIndexStorage memStorage = (MemoryIndexStorage)index.getStorage();
            ConcurrencyUtil.withLock((Lock)index.getReadLock(), () -> memStorage.clearCaches());
        }
    }

    public IndexedFilesListener getChangedFilesCollector() {
        return this.myChangedFilesCollector;
    }

    void filesUpdateStarted(Project project) {
        this.myChangedFilesCollector.ensureUpToDate();
        this.myProjectsBeingUpdated.add(project);
        this.myFilesModCount.incrementAndGet();
    }

    void filesUpdateFinished(@NotNull Project project) {
        this.myProjectsBeingUpdated.remove(project);
        this.myFilesModCount.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ProjectIndexableFilesFilter projectIndexableFiles(@Nullable Project project) {
        if (project == null || this.myUpdatingFiles.get() > 0) {
            return null;
        }
        if (this.myProjectsBeingUpdated.contains(project)) {
            return null;
        }
        SoftReference reference = (SoftReference)project.getUserData(ourProjectFilesSetKey);
        ProjectIndexableFilesFilter data = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference));
        int currentFileModCount = this.myFilesModCount.get();
        if (data != null && data.myModificationCount == currentFileModCount) {
            return data;
        }
        if (this.myCalcIndexableFilesLock.tryLock()) {
            try {
                reference = (SoftReference)project.getUserData(ourProjectFilesSetKey);
                data = (ProjectIndexableFilesFilter)((Object)com.intellij.reference.SoftReference.dereference((Reference)reference));
                if (data != null && data.myModificationCount == currentFileModCount) {
                    ProjectIndexableFilesFilter projectIndexableFilesFilter = data;
                    return projectIndexableFilesFilter;
                }
                long start2 = System.currentTimeMillis();
                TIntArrayList filesSet = new TIntArrayList();
                this.iterateIndexableFiles(fileOrDir -> {
                    ProgressManager.checkCanceled();
                    if (fileOrDir instanceof VirtualFileWithId) {
                        filesSet.add(((VirtualFileWithId)fileOrDir).getId());
                    }
                    return true;
                }, project, (ProgressIndicator)SilentProgressIndicator.create());
                ProjectIndexableFilesFilter filter = new ProjectIndexableFilesFilter(filesSet, currentFileModCount);
                project.putUserData(ourProjectFilesSetKey, new SoftReference<ProjectIndexableFilesFilter>(filter));
                long finish = System.currentTimeMillis();
                LOG.debug(filesSet.size() + " files iterated in " + (finish - start2) + " ms");
                ProjectIndexableFilesFilter projectIndexableFilesFilter = filter;
                return projectIndexableFilesFilter;
            }
            finally {
                this.myCalcIndexableFilesLock.unlock();
            }
        }
        return null;
    }

    @Nullable
    private <K, V> TIntHashSet collectFileIdsContainingAllKeys(@NotNull ID<K, V> indexId, @NotNull Collection<? extends K> dataKeys, @NotNull GlobalSearchScope filter, @Nullable Condition<? super V> valueChecker, @Nullable ProjectIndexableFilesFilter projectFilesFilter) {
        ThrowableConvertor convertor = index -> InvertedIndexUtil.collectInputIdsContainingAllKeys((InvertedIndex)index, (Collection)dataKeys, __ -> {
            ProgressManager.checkCanceled();
            return true;
        }, (Condition)valueChecker, projectFilesFilter == null ? null : projectFilesFilter::containsFileId);
        return (TIntHashSet)this.processExceptions(indexId, null, filter, convertor);
    }

    private static boolean processVirtualFiles(@NotNull TIntHashSet ids, @NotNull GlobalSearchScope filter, @NotNull Processor<? super VirtualFile> processor2) {
        PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
        return ids.forEach(id -> {
            ProgressManager.checkCanceled();
            VirtualFile file2 = IndexInfrastructure.findFileByIdIfCached(fs, id);
            if (file2 != null && filter.accept(file2)) {
                return processor2.process((Object)file2);
            }
            return true;
        });
    }

    @Nullable
    public static Throwable getCauseToRebuildIndex(@NotNull RuntimeException e) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (e instanceof ProcessCanceledException) {
            return null;
        }
        if (e instanceof IndexOutOfBoundsException) {
            return e;
        }
        Throwable cause = e.getCause();
        if (cause instanceof StorageException || cause instanceof IOException || cause instanceof IllegalArgumentException) {
            return cause;
        }
        return null;
    }

    public <K, V> boolean getFilesWithKey(@NotNull ID<K, V> indexId, @NotNull Set<? extends K> dataKeys, @NotNull Processor<? super VirtualFile> processor2, @NotNull GlobalSearchScope filter) {
        return this.processFilesContainingAllKeys(indexId, dataKeys, filter, null, processor2);
    }

    public <K> void scheduleRebuild(@NotNull ID<K, ?> indexId, @NotNull Throwable e) {
        this.requestRebuild(indexId, e);
    }

    private static void scheduleIndexRebuild(String reason) {
        LOG.info("scheduleIndexRebuild, reason: " + reason);
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project));
        }
    }

    void clearIndicesIfNecessary() {
        this.waitUntilIndicesAreInitialized();
        for (ID<?, ?> indexId : this.getState().getIndexIDs()) {
            try {
                RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<StorageException>)((ThrowableRunnable)() -> this.getIndex(indexId).clear()));
            }
            catch (StorageException e) {
                this.requestRebuild(indexId);
                LOG.error((Throwable)e);
            }
        }
    }

    private void clearIndex(@NotNull ID<?, ?> indexId) throws StorageException {
        this.advanceIndexVersion(indexId);
        UpdatableIndex<?, ?, FileContent> index = this.myState.getIndex(indexId);
        assert (index != null) : "Index with key " + indexId + " not found or not registered properly";
        index.clear();
    }

    private void advanceIndexVersion(ID<?, ?> indexId) {
        try {
            IndexingStamp.rewriteVersion(indexId, this.myState.getIndexVersion(indexId));
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    @NotNull
    private Set<Document> getUnsavedDocuments() {
        Document[] documents = this.myFileDocumentManager.getUnsavedDocuments();
        if (documents.length == 0) {
            return Collections.emptySet();
        }
        if (documents.length == 1) {
            return Collections.singleton(documents[0]);
        }
        return new THashSet(Arrays.asList(documents));
    }

    @NotNull
    private Set<Document> getTransactedDocuments() {
        return this.myTransactionMap.keySet();
    }

    private void indexUnsavedDocuments(@NotNull ID<?, ?> indexId, @Nullable Project project, GlobalSearchScope filter, VirtualFile restrictedFile) {
        List documentsToProcessForProject;
        if (this.myUpToDateIndicesForUnsavedOrTransactedDocuments.contains(indexId)) {
            return;
        }
        Object documents = this.getUnsavedDocuments();
        boolean psiBasedIndex = this.myPsiDependentIndices.contains(indexId);
        if (psiBasedIndex) {
            Document[] uncommittedDocuments;
            Set<Document> transactedDocuments = this.getTransactedDocuments();
            if (documents.isEmpty()) {
                documents = transactedDocuments;
            } else if (!transactedDocuments.isEmpty()) {
                documents = new THashSet(documents);
                documents.addAll(transactedDocuments);
            }
            Document[] documentArray = uncommittedDocuments = project != null ? PsiDocumentManager.getInstance((Project)project).getUncommittedDocuments() : Document.EMPTY_ARRAY;
            if (uncommittedDocuments.length > 0) {
                List<Document> uncommittedDocumentsCollection = Arrays.asList(uncommittedDocuments);
                if (documents.isEmpty()) {
                    documents = uncommittedDocumentsCollection;
                } else {
                    if (!(documents instanceof THashSet)) {
                        documents = new THashSet((Collection)documents);
                    }
                    documents.addAll(uncommittedDocumentsCollection);
                }
            }
        }
        if (!documents.isEmpty() && !(documentsToProcessForProject = ContainerUtil.filter(documents, document -> FileBasedIndexImpl.belongsToScope(this.myFileDocumentManager.getFile(document), restrictedFile, filter))).isEmpty()) {
            DocumentUpdateTask task2 = this.myUnsavedDataUpdateTasks.get(indexId);
            assert (task2 != null) : "Task for unsaved data indexing was not initialized for index " + indexId;
            if (this.runUpdate(true, (Computable<Boolean>)((Computable)() -> task2.processAll(documentsToProcessForProject, project))) && documentsToProcessForProject.size() == documents.size() && !this.hasActiveTransactions()) {
                ProgressManager.checkCanceled();
                this.myUpToDateIndicesForUnsavedOrTransactedDocuments.add(indexId);
            }
        }
    }

    private boolean hasActiveTransactions() {
        return !this.myTransactionMap.isEmpty();
    }

    private boolean indexUnsavedDocument(@NotNull Document document, @NotNull ID<?, ?> requestedIndexId, Project project, @NotNull VirtualFile vFile) {
        PsiFile dominantContentFile = project == null ? null : FileBasedIndexImpl.findLatestKnownPsiForUncomittedDocument(document, project);
        DocumentContent content = dominantContentFile != null && dominantContentFile.getViewProvider().getModificationStamp() != document.getModificationStamp() ? new PsiContent(document, dominantContentFile) : new AuthenticContent(document);
        boolean psiBasedIndex = this.myPsiDependentIndices.contains(requestedIndexId);
        long currentDocStamp = psiBasedIndex ? PsiDocumentManager.getInstance((Project)project).getLastCommittedStamp(document) : content.getModificationStamp();
        long previousDocStamp = this.myLastIndexedDocStamps.get(document, requestedIndexId);
        if (previousDocStamp == currentDocStamp) {
            return false;
        }
        CharSequence contentText = content.getText();
        this.myFileTypeManager.freezeFileTypeTemporarilyIn(vFile, () -> {
            if (this.getAffectedIndexCandidates(vFile).contains(requestedIndexId) && this.getInputFilter(requestedIndexId).acceptInput(vFile)) {
                int inputId = Math.abs(FileBasedIndexImpl.getFileId((VirtualFile)vFile));
                if (!this.isTooLarge(vFile, contentText.length())) {
                    FileContentImpl newFc;
                    WeakReference previousContentRef = (WeakReference)document.getUserData(ourFileContentKey);
                    FileContentImpl previousContent = (FileContentImpl)((Object)((Object)com.intellij.reference.SoftReference.dereference((Reference)previousContentRef)));
                    if (previousContent != null && previousContent.getStamp() == currentDocStamp) {
                        newFc = previousContent;
                    } else {
                        newFc = new FileContentImpl(vFile, contentText, currentDocStamp);
                        document.putUserData(ourFileContentKey, new WeakReference<FileContentImpl>(newFc));
                    }
                    FileBasedIndexImpl.initFileContent(newFc, project, dominantContentFile);
                    newFc.ensureThreadSafeLighterAST();
                    if (content instanceof AuthenticContent) {
                        newFc.putUserData(PlatformIdTableBuilding.EDITOR_HIGHLIGHTER, EditorHighlighterCache.getEditorHighlighterForCachesBuilding(document));
                    }
                    try {
                        this.getIndex(requestedIndexId).update(inputId, (Object)newFc).compute();
                    }
                    finally {
                        FileBasedIndexImpl.cleanFileContent(newFc, dominantContentFile);
                    }
                } else {
                    this.getIndex(requestedIndexId).update(inputId, null).compute();
                }
            }
            long previousState = this.myLastIndexedDocStamps.set(document, requestedIndexId, currentDocStamp);
            assert (previousState == previousDocStamp);
        });
        return true;
    }

    @ApiStatus.Experimental
    public void runCleanupAction(@NotNull Runnable cleanupAction) {
        Computable updateComputable = () -> {
            cleanupAction.run();
            return true;
        };
        this.runUpdate(false, (Computable<Boolean>)updateComputable);
        this.runUpdate(true, (Computable<Boolean>)updateComputable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runUpdate(boolean transientInMemoryIndices, Computable<Boolean> update) {
        StorageGuard.StorageModeExitHandler storageModeExitHandler = this.myStorageLock.enter(transientInMemoryIndices);
        if (this.myPreviousDataBufferingState != transientInMemoryIndices) {
            Object object = this.myBufferingStateUpdateLock;
            synchronized (object) {
                if (this.myPreviousDataBufferingState != transientInMemoryIndices) {
                    IndexConfiguration state = this.getState();
                    for (ID<?, ?> indexId : state.getIndexIDs()) {
                        MapReduceIndex index = (MapReduceIndex)state.getIndex(indexId);
                        assert (index != null);
                        ((MemoryIndexStorage)index.getStorage()).setBufferingEnabled(transientInMemoryIndices);
                    }
                    this.myPreviousDataBufferingState = transientInMemoryIndices;
                }
            }
        }
        try {
            boolean bl = (Boolean)update.compute();
            return bl;
        }
        finally {
            storageModeExitHandler.leave();
        }
    }

    private void cleanupMemoryStorage(boolean skipPsiBasedIndices) {
        this.myLastIndexedDocStamps.clear();
        IndexConfiguration state = this.myState;
        if (state == null) {
            return;
        }
        for (ID<?, ?> indexId : state.getIndexIDs()) {
            if (skipPsiBasedIndices && this.myPsiDependentIndices.contains(indexId)) continue;
            MapReduceIndex index = (MapReduceIndex)state.getIndex(indexId);
            assert (index != null);
            MemoryIndexStorage memStorage = (MemoryIndexStorage)index.getStorage();
            ConcurrencyUtil.withLock((Lock)index.getWriteLock(), () -> memStorage.clearMemoryMap());
            memStorage.fireMemoryStorageCleared();
        }
    }

    public void requestRebuild(@NotNull ID<?, ?> indexId, Throwable throwable) {
        FileBasedIndexImpl.cleanupProcessedFlag();
        if (RebuildStatus.requestRebuild(indexId)) {
            String message = "Rebuild requested for index " + indexId;
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() && app.isReadAccessAllowed() && !app.isDispatchThread()) {
                LOG.error(message, throwable);
            } else {
                LOG.info(message, throwable);
            }
            FileBasedIndexImpl.cleanupProcessedFlag();
            if (!this.myInitialized) {
                return;
            }
            this.advanceIndexVersion(indexId);
            Runnable rebuildRunnable = () -> FileBasedIndexImpl.scheduleIndexRebuild("checkRebuild");
            if (this.myIsUnitTestMode) {
                rebuildRunnable.run();
            } else {
                TransactionGuard.getInstance().submitTransactionLater((Disposable)app, rebuildRunnable);
            }
        }
    }

    public <K, V> UpdatableIndex<K, V, FileContent> getIndex(ID<K, V> indexId) {
        return this.getState().getIndex(indexId);
    }

    private FileBasedIndex.InputFilter getInputFilter(@NotNull ID<?, ?> indexId) {
        if (!this.myInitialized) {
            this.waitUntilIndicesAreInitialized();
        }
        return this.getState().getInputFilter(indexId);
    }

    @NotNull
    Collection<VirtualFile> getFilesToUpdate(Project project) {
        return ContainerUtil.filter(this.myChangedFilesCollector.getAllFilesToUpdate(), this.filesToBeIndexedForProjectCondition(project)::test);
    }

    @NotNull
    private Predicate<VirtualFile> filesToBeIndexedForProjectCondition(Project project) {
        return virtualFile -> {
            if (!virtualFile.isValid()) {
                return true;
            }
            for (IndexableFileSet set2 : this.myIndexableSets) {
                Project proj = this.myIndexableSetToProjectMap.get(set2);
                if (proj != null && !proj.equals(project) || !((Boolean)ReadAction.compute(() -> set2.isInSet(virtualFile))).booleanValue()) continue;
                return true;
            }
            return false;
        };
    }

    public boolean isFileUpToDate(VirtualFile file2) {
        return !this.myChangedFilesCollector.isScheduledForUpdate(file2);
    }

    void processRefreshedFile(@Nullable Project project, @NotNull com.intellij.ide.caches.FileContent fileContent) {
        VirtualFile file2 = fileContent.getVirtualFile();
        if (this.myChangedFilesCollector.isScheduledForUpdate(file2)) {
            this.indexFileContent(project, fileContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexFileContent(@Nullable Project project, @NotNull com.intellij.ide.caches.FileContent content) {
        VirtualFile file2 = content.getVirtualFile();
        int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
        try {
            if (file2.isValid() && content.getTimeStamp() != file2.getTimeStamp()) {
                content = new com.intellij.ide.caches.FileContent(file2);
            }
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.removeDataFromIndicesForFile(fileId, file2);
                if (file2 instanceof DeletedVirtualFileStub && ((DeletedVirtualFileStub)file2).isResurrected()) {
                    this.doIndexFileContent(project, new com.intellij.ide.caches.FileContent(((DeletedVirtualFileStub)file2).getOriginalFile()));
                }
            } else {
                this.doIndexFileContent(project, content);
            }
        }
        finally {
            IndexingStamp.flushCache(fileId);
        }
        this.myChangedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
        if (file2 instanceof VirtualFileSystemEntry) {
            ((VirtualFileSystemEntry)file2).setFileIndexed(true);
        }
    }

    private void doIndexFileContent(@Nullable Project project, @NotNull com.intellij.ide.caches.FileContent content) {
        VirtualFile file2 = content.getVirtualFile();
        this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, () -> {
            FileType fileType = file2.getFileType();
            Project finalProject = project == null ? ProjectUtil.guessProjectForFile((VirtualFile)file2) : project;
            PsiFile psiFile = null;
            FileContentImpl fc = null;
            int inputId = Math.abs(FileBasedIndexImpl.getFileId((VirtualFile)file2));
            THashSet currentIndexedStates = new THashSet(IndexingStamp.getNontrivialFileIndexedStates(inputId));
            List<ID<?, ?>> affectedIndexCandidates = this.getAffectedIndexCandidates(file2);
            int size = affectedIndexCandidates.size();
            for (int i = 0; i < size; ++i) {
                ID<?, ?> indexId = affectedIndexCandidates.get(i);
                if (!this.shouldIndexFile(file2, indexId)) continue;
                if (fc == null) {
                    byte[] currentBytes;
                    try {
                        currentBytes = content.getBytes();
                    }
                    catch (IOException e) {
                        currentBytes = ArrayUtil.EMPTY_BYTE_ARRAY;
                    }
                    fc = new FileContentImpl(file2, currentBytes);
                    if (IdIndex.ourSnapshotMappingsEnabled) {
                        FileType substituteFileType = SubstitutedFileType.substituteFileType(file2, fileType, finalProject);
                        byte[] hash = fileType.isBinary() ? ContentHashesSupport.calcContentHash(currentBytes, substituteFileType) : ContentHashesSupport.calcContentHashWithFileType(currentBytes, fc.getCharset(), substituteFileType);
                        fc.setHash(hash);
                    }
                    psiFile = (PsiFile)content.getUserData(IndexingDataKeys.PSI_FILE);
                    FileBasedIndexImpl.initFileContent(fc, finalProject, psiFile);
                }
                try {
                    ProgressManager.checkCanceled();
                    this.updateSingleIndex(indexId, file2, inputId, fc);
                    currentIndexedStates.remove(indexId);
                    continue;
                }
                catch (ProcessCanceledException e) {
                    FileBasedIndexImpl.cleanFileContent(fc, psiFile);
                    throw e;
                }
            }
            if (psiFile != null) {
                psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
            }
            for (ID indexId : currentIndexedStates) {
                if (this.getIndex(indexId).isIndexedStateForFile(inputId, file2)) continue;
                ProgressManager.checkCanceled();
                this.updateSingleIndex(indexId, file2, inputId, null);
            }
        });
    }

    public boolean isIndexingCandidate(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        return !this.isTooLarge(file2) && this.getAffectedIndexCandidates(file2).contains(indexId);
    }

    @NotNull
    private List<ID<?, ?>> getAffectedIndexCandidates(@NotNull VirtualFile file2) {
        if (file2.isDirectory()) {
            return FileBasedIndexImpl.isProjectOrWorkspaceFile(file2, null) ? Collections.emptyList() : this.myIndicesForDirectories;
        }
        FileType fileType = file2.getFileType();
        if (FileBasedIndexImpl.isProjectOrWorkspaceFile(file2, fileType)) {
            return Collections.emptyList();
        }
        return this.getState().getFileTypesForIndex(fileType);
    }

    private static void cleanFileContent(@NotNull FileContentImpl fc, PsiFile psiFile) {
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, null);
        }
        fc.putUserData(IndexingDataKeys.PSI_FILE, null);
    }

    private static void initFileContent(@NotNull FileContentImpl fc, Project project, PsiFile psiFile) {
        if (psiFile != null) {
            psiFile.putUserData(PsiFileImpl.BUILDING_STUB, (Object)true);
            fc.putUserData(IndexingDataKeys.PSI_FILE, psiFile);
        }
        fc.putUserData(IndexingDataKeys.PROJECT, project);
    }

    private void updateSingleIndex(@NotNull ID<?, ?> indexId, VirtualFile file2, int inputId, @Nullable FileContent currentFC) {
        boolean hasContent;
        if (!RebuildStatus.isOk(indexId) && !this.myIsUnitTestMode) {
            return;
        }
        this.myLocalModCount.incrementAndGet();
        UpdatableIndex<?, ?, FileContent> index = this.getIndex(indexId);
        assert (index != null);
        boolean bl = hasContent = currentFC != null;
        if (hasContent && currentFC.getUserData(ourPhysicalContentKey) == null) {
            currentFC.putUserData(ourPhysicalContentKey, (Object)Boolean.TRUE);
        }
        boolean updateCalculated = false;
        try {
            Computable update = index.update(inputId, currentFC);
            updateCalculated = true;
            this.scheduleUpdate(indexId, (Computable<Boolean>)update, file2, inputId, hasContent);
        }
        catch (RuntimeException exception) {
            Throwable causeToRebuildIndex = FileBasedIndexImpl.getCauseToRebuildIndex(exception);
            if (causeToRebuildIndex != null && (updateCalculated || causeToRebuildIndex instanceof IOException)) {
                this.requestRebuild(indexId, exception);
                return;
            }
            throw exception;
        }
    }

    private void forceUpdate(@Nullable Project project, @Nullable GlobalSearchScope filter, @Nullable VirtualFile restrictedTo) {
        Collection<VirtualFile> allFilesToUpdate = this.myChangedFilesCollector.getAllFilesToUpdate();
        if (!allFilesToUpdate.isEmpty()) {
            boolean includeFilesFromOtherProjects = restrictedTo == null && (this.myForceUpdateRequests.incrementAndGet() & 0x3F) == 0;
            List virtualFilesToBeUpdatedForProject = ContainerUtil.filter(allFilesToUpdate, (Condition)new ProjectFilesCondition(this.projectIndexableFiles(project), filter, restrictedTo, includeFilesFromOtherProjects));
            if (!virtualFilesToBeUpdatedForProject.isEmpty()) {
                this.myForceUpdateTask.processAll(virtualFilesToBeUpdatedForProject, project);
            }
        }
    }

    private void scheduleUpdate(@NotNull ID<?, ?> indexId, @NotNull Computable<Boolean> update, VirtualFile file2, int inputId, boolean hasContent) {
        if (this.runUpdate(false, update)) {
            ConcurrencyUtil.withLock((Lock)this.myReadLock, () -> {
                UpdatableIndex index = this.getIndex(indexId);
                if (hasContent) {
                    index.setIndexedStateForFile(inputId, file2);
                } else {
                    index.resetIndexedStateForFile(inputId);
                }
            });
        }
    }

    private boolean needsFileContentLoading(@NotNull ID<?, ?> indexId) {
        return !this.myNotRequiringContentIndices.contains(indexId);
    }

    @Nullable
    private IndexableFileSet getIndexableSetForFile(VirtualFile file2) {
        for (IndexableFileSet set2 : this.myIndexableSets) {
            if (!set2.isInSet(file2)) continue;
            return set2;
        }
        return null;
    }

    private void doTransientStateChangeForFile(int fileId, @NotNull VirtualFile file2) {
        this.waitUntilIndicesAreInitialized();
        if (!this.clearUpToDateStateForPsiIndicesOfUnsavedDocuments(file2, IndexingStamp.getNontrivialFileIndexedStates(fileId))) {
            this.clearUpToDateStateForPsiIndicesOfVirtualFile(file2);
        }
    }

    private void doInvalidateIndicesForFile(int fileId, @NotNull VirtualFile file2, boolean contentChanged) {
        this.waitUntilIndicesAreInitialized();
        FileBasedIndexImpl.cleanProcessedFlag(file2);
        List<ID<?, ?>> nontrivialFileIndexedStates = IndexingStamp.getNontrivialFileIndexedStates(fileId);
        Collection fileIndexedStatesToUpdate = ContainerUtil.intersection(nontrivialFileIndexedStates, this.myRequiringContentIndices);
        if (contentChanged) {
            if (!fileIndexedStatesToUpdate.isEmpty()) {
                int size = nontrivialFileIndexedStates.size();
                for (int i = 0; i < size; ++i) {
                    ID<?, ?> indexId = nontrivialFileIndexedStates.get(i);
                    if (!this.needsFileContentLoading(indexId)) continue;
                    this.getIndex(indexId).resetIndexedStateForFile(fileId);
                }
                this.removeTransientFileDataFromIndices(nontrivialFileIndexedStates, fileId, file2);
                if (file2.isValid()) {
                    if (!this.isTooLarge(file2)) {
                        this.myChangedFilesCollector.scheduleForUpdate(file2);
                    } else {
                        this.myChangedFilesCollector.scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
                    }
                } else {
                    LOG.info("Unexpected state in update:" + file2);
                }
            }
        } else {
            for (ID<?, ?> indexId : nontrivialFileIndexedStates) {
                if (!this.myNotRequiringContentIndices.contains(indexId)) continue;
                this.updateSingleIndex(indexId, null, fileId, null);
            }
            if (!fileIndexedStatesToUpdate.isEmpty()) {
                this.myChangedFilesCollector.scheduleForUpdate((VirtualFile)new DeletedVirtualFileStub((VirtualFileWithId)file2));
            } else {
                this.myChangedFilesCollector.removeScheduledFileFromUpdate(file2);
            }
        }
    }

    private void scheduleFileForIndexing(int fileId, @NotNull VirtualFile file2, boolean contentChange) {
        boolean fileIsDirectory = file2.isDirectory();
        if (!contentChange) {
            FileContentImpl fileContent = null;
            for (ID<?, ?> indexId : fileIsDirectory ? this.myIndicesForDirectories : this.myNotRequiringContentIndices) {
                if (!this.getInputFilter(indexId).acceptInput(file2)) continue;
                if (fileContent == null) {
                    fileContent = new FileContentImpl(file2);
                }
                this.updateSingleIndex(indexId, file2, fileId, fileContent);
            }
        }
        if (!fileIsDirectory) {
            if (!file2.isValid() || this.isTooLarge(file2)) {
                this.myChangedFilesCollector.removeScheduledFileFromUpdate(file2);
            } else {
                int finalFileId = fileId;
                this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, () -> {
                    List<ID<?, ?>> candidates = this.getAffectedIndexCandidates(file2);
                    boolean scheduleForUpdate = false;
                    int size = candidates.size();
                    for (int i = 0; i < size; ++i) {
                        ID<?, ?> indexId = candidates.get(i);
                        if (!this.needsFileContentLoading(indexId) || !this.getInputFilter(indexId).acceptInput(file2)) continue;
                        this.getIndex(indexId).resetIndexedStateForFile(finalFileId);
                        scheduleForUpdate = true;
                    }
                    if (scheduleForUpdate) {
                        IndexingStamp.flushCache(finalFileId);
                        this.myChangedFilesCollector.scheduleForUpdate(file2);
                    }
                });
            }
        }
    }

    private boolean clearUpToDateStateForPsiIndicesOfUnsavedDocuments(@NotNull VirtualFile file2, Collection<? extends ID<?, ?>> affectedIndices) {
        Document document;
        if (!this.myUpToDateIndicesForUnsavedOrTransactedDocuments.isEmpty()) {
            this.myUpToDateIndicesForUnsavedOrTransactedDocuments.clear();
        }
        if ((document = this.myFileDocumentManager.getCachedDocument(file2)) != null && this.myFileDocumentManager.isDocumentUnsaved(document)) {
            this.myLastIndexedDocStamps.clearForDocument(document);
            document.putUserData(ourFileContentKey, null);
            return true;
        }
        this.removeTransientFileDataFromIndices(ContainerUtil.intersection(affectedIndices, this.myPsiDependentIndices), FileBasedIndexImpl.getFileId((VirtualFile)file2), file2);
        return false;
    }

    static int getIdMaskingNonIdBasedFile(@NotNull VirtualFile file2) {
        return file2 instanceof VirtualFileWithId ? ((VirtualFileWithId)file2).getId() : 0;
    }

    private boolean shouldIndexFile(@NotNull VirtualFile file2, @NotNull ID<?, ?> indexId) {
        return this.getInputFilter(indexId).acceptInput(file2) && (FileBasedIndexImpl.isMock(file2) || !this.getIndex(indexId).isIndexedStateForFile(((NewVirtualFile)file2).getId(), file2));
    }

    static boolean isMock(VirtualFile file2) {
        return !(file2 instanceof NewVirtualFile);
    }

    private boolean isTooLarge(@NotNull VirtualFile file2) {
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2)) {
            return !this.myNoLimitCheckTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2);
        }
        return false;
    }

    private boolean isTooLarge(@NotNull VirtualFile file2, long contentSize) {
        if (SingleRootFileViewProvider.isTooLargeForIntelligence(file2, contentSize)) {
            return !this.myNoLimitCheckTypes.contains(file2.getFileType()) || SingleRootFileViewProvider.isTooLargeForContentLoading(file2, contentSize);
        }
        return false;
    }

    @NotNull
    CollectingContentIterator createContentIterator(@Nullable ProgressIndicator indicator) {
        return new UnindexedFilesFinder();
    }

    public void registerIndexableSet(@NotNull IndexableFileSet set2, @Nullable Project project) {
        this.myIndexableSets.add(set2);
        this.myIndexableSetToProjectMap.put(set2, project);
        if (project != null) {
            ((PsiManagerImpl)PsiManager.getInstance((Project)project)).addTreeChangePreprocessor(event -> {
                VirtualFile virtualFile;
                PsiFile file2;
                if (event.isGenericChange() && event.getCode() == PsiTreeChangeEventImpl.PsiEventType.CHILDREN_CHANGED && (file2 = event.getFile()) != null && (virtualFile = file2.getVirtualFile()) instanceof VirtualFileWithId) {
                    this.myChangedFilesCollector.myVfsEventsMerger.recordTransientStateChangeEvent(FileBasedIndexImpl.getFileId((VirtualFile)virtualFile), virtualFile);
                }
            });
        }
    }

    private void clearUpToDateStateForPsiIndicesOfVirtualFile(VirtualFile virtualFile) {
        if (virtualFile instanceof VirtualFileWithId) {
            int fileId = ((VirtualFileWithId)virtualFile).getId();
            boolean wasIndexed = false;
            List<ID<?, ?>> candidates = this.getAffectedIndexCandidates(virtualFile);
            for (ID<?, ?> psiBackedIndex : this.myPsiDependentIndices) {
                if (!candidates.contains(psiBackedIndex) || !this.getInputFilter(psiBackedIndex).acceptInput(virtualFile)) continue;
                this.getIndex(psiBackedIndex).resetIndexedStateForFile(fileId);
                wasIndexed = true;
            }
            if (wasIndexed) {
                this.myChangedFilesCollector.scheduleForUpdate(virtualFile);
                IndexingStamp.flushCache(fileId);
            }
        }
    }

    public void removeIndexableSet(@NotNull IndexableFileSet set2) {
        if (!this.myIndexableSetToProjectMap.containsKey(set2)) {
            return;
        }
        this.myIndexableSets.remove(set2);
        this.myIndexableSetToProjectMap.remove(set2);
        for (VirtualFile file2 : this.myChangedFilesCollector.getAllFilesToUpdate()) {
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            if (!file2.isValid()) {
                this.removeDataFromIndicesForFile(fileId, file2);
                this.myChangedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
                continue;
            }
            if (this.getIndexableSetForFile(file2) != null) continue;
            this.myChangedFilesCollector.removeFileIdFromFilesScheduledForUpdate(fileId);
        }
        IndexingStamp.flushCaches();
    }

    public VirtualFile findFileById(Project project, int id) {
        return IndexInfrastructure.findFileById((PersistentFS)ManagingFS.getInstance(), id);
    }

    @Nullable
    private static PsiFile findLatestKnownPsiForUncomittedDocument(@NotNull Document doc, @NotNull Project project) {
        return PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(doc);
    }

    private static void cleanupProcessedFlag() {
        VirtualFile[] roots;
        for (VirtualFile root : roots = ManagingFS.getInstance().getRoots()) {
            FileBasedIndexImpl.cleanProcessedFlag(root);
        }
    }

    private static void cleanProcessedFlag(@NotNull VirtualFile file2) {
        if (!(file2 instanceof VirtualFileSystemEntry)) {
            return;
        }
        VirtualFileSystemEntry nvf = (VirtualFileSystemEntry)file2;
        if (file2.isDirectory()) {
            nvf.setFileIndexed(false);
            for (VirtualFile child2 : nvf.getCachedChildren()) {
                FileBasedIndexImpl.cleanProcessedFlag(child2);
            }
        } else {
            nvf.setFileIndexed(false);
        }
    }

    public void iterateIndexableFilesConcurrently(@NotNull ContentIterator processor2, @NotNull Project project, @NotNull ProgressIndicator indicator) {
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(FileBasedIndexImpl.collectScanRootRunnables(processor2, project, indicator));
    }

    public void iterateIndexableFiles(@NotNull ContentIterator processor2, @NotNull Project project, ProgressIndicator indicator) {
        for (Runnable r : FileBasedIndexImpl.collectScanRootRunnables(processor2, project, indicator)) {
            r.run();
        }
    }

    @NotNull
    private static List<Runnable> collectScanRootRunnables(@NotNull ContentIterator processor2, @NotNull Project project, ProgressIndicator indicator) {
        FileBasedIndexScanRunnableCollector collector = FileBasedIndexScanRunnableCollector.getInstance(project);
        return collector.collectScanRootRunnables(processor2, indicator);
    }

    public void invalidateCaches() {
        File indexRoot = PathManager.getIndexRoot();
        LOG.info("Requesting explicit indices invalidation", new Throwable());
        try {
            File corruptionMarker = new File(indexRoot, CORRUPTION_MARKER_NAME);
            new FileOutputStream(corruptionMarker).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void waitForVfsEventsExecuted(long timeout, @NotNull TimeUnit unit) throws Exception {
        ApplicationManager.getApplication().assertIsDispatchThread();
        long deadline = System.nanoTime() + unit.toNanos(timeout);
        while (System.nanoTime() < deadline) {
            try {
                ((BoundedTaskExecutor)this.myChangedFilesCollector.myVfsEventsExecutor).waitAllTasksExecuted(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
                UIUtil.dispatchAllInvocationEvents();
            }
        }
    }

    private static /* synthetic */ boolean lambda$getContainingFiles$7(Set files2, VirtualFile file2, Object value) {
        files2.add(file2);
        return true;
    }

    private static /* synthetic */ boolean lambda$getValues$6(List values, VirtualFile file2, Object value) {
        values.add(value);
        return true;
    }

    private static /* synthetic */ void lambda$initIndexStorage$2(Set addedTypes, FileType type) {
        if (type != null) {
            addedTypes.add(type);
        }
    }

    private class FileIndexDataInitialization
    extends IndexInfrastructure.DataInitialization<IndexConfiguration> {
        private final IndexConfiguration state = new IndexConfiguration();
        private final AtomicBoolean versionChanged = new AtomicBoolean();
        private boolean currentVersionCorrupted;
        private SerializationManagerEx mySerializationManagerEx;

        FileIndexDataInitialization(List<? extends FileBasedIndexExtension> extensions) {
            if (!extensions.isEmpty()) {
                extensions = ContainerUtil.copyList(extensions);
                extensions.sort(Comparator.comparingInt(o -> o.dependsOnFileContent() ? 1 : 0));
            }
            for (FileBasedIndexExtension extension : extensions) {
                ID name = extension.getName();
                RebuildStatus.registerIndex(name);
                FileBasedIndexImpl.this.myUnsavedDataUpdateTasks.put(name, new DocumentUpdateTask(name));
                if (!extension.dependsOnFileContent()) {
                    if (extension.indexDirectories()) {
                        FileBasedIndexImpl.this.myIndicesForDirectories.add(name);
                    }
                    FileBasedIndexImpl.this.myNotRequiringContentIndices.add(name);
                } else {
                    FileBasedIndexImpl.this.myRequiringContentIndices.add(name);
                }
                if (extension instanceof PsiDependentIndex) {
                    FileBasedIndexImpl.this.myPsiDependentIndices.add(name);
                }
                FileBasedIndexImpl.this.myNoLimitCheckTypes.addAll(extension.getFileTypesWithSizeLimitNotApplicable());
                this.addNestedInitializationTask(() -> {
                    try {
                        this.versionChanged.compareAndSet(false, FileBasedIndexImpl.registerIndexer(extension, this.state));
                    }
                    catch (IOException io) {
                        throw io;
                    }
                    catch (Throwable t) {
                        PluginManager.handleComponentError(t, extension.getClass().getName(), null);
                    }
                });
            }
        }

        @Override
        protected void prepare() {
            this.mySerializationManagerEx = SerializationManagerEx.getInstanceEx();
            File indexRoot = PathManager.getIndexRoot();
            PersistentIndicesConfiguration.loadConfiguration();
            File corruptionMarker = new File(indexRoot, FileBasedIndexImpl.CORRUPTION_MARKER_NAME);
            boolean bl = this.currentVersionCorrupted = IndexInfrastructure.hasIndices() && corruptionMarker.exists();
            if (this.currentVersionCorrupted) {
                FileUtil.deleteWithRenaming((File)indexRoot);
                indexRoot.mkdirs();
                this.mySerializationManagerEx.reinitializeNameStorage();
                ID.reinitializeDiskStorage();
                PersistentIndicesConfiguration.saveConfiguration();
                FileUtil.delete((File)corruptionMarker);
            }
        }

        @Override
        protected void onThrowable(@NotNull Throwable t) {
            LOG.error(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IndexConfiguration finish() {
            IndexConfiguration indexConfiguration;
            try {
                this.state.finalizeFileTypeMappingForIndices();
                String rebuildNotification = null;
                if (this.currentVersionCorrupted) {
                    rebuildNotification = "Index files on disk are corrupted. Indices will be rebuilt.";
                } else if (this.versionChanged.get()) {
                    rebuildNotification = "Index file format has changed for some indices. These indices will be rebuilt.";
                }
                if (rebuildNotification != null && !ApplicationManager.getApplication().isHeadlessEnvironment() && Registry.is((String)"ide.showIndexRebuildMessage")) {
                    NOTIFICATIONS.createNotification("Index Rebuild", rebuildNotification, NotificationType.INFORMATION, null).notify(null);
                }
                this.state.freeze();
                FileBasedIndexImpl.this.myState = this.state;
                for (ID<?, ?> indexId : this.state.getIndexIDs()) {
                    try {
                        RebuildStatus.clearIndexIfNecessary(indexId, (ThrowableRunnable<StorageException>)((ThrowableRunnable)() -> FileBasedIndexImpl.this.clearIndex(indexId)));
                    }
                    catch (StorageException e) {
                        FileBasedIndexImpl.this.requestRebuild(indexId);
                        LOG.error((Throwable)e);
                    }
                }
                FileBasedIndexImpl.this.registerIndexableSet(new AdditionalIndexableFileSet(), null);
                indexConfiguration = this.state;
            }
            catch (Throwable throwable) {
                ShutDownTracker.getInstance().registerShutdownTask(() -> FileBasedIndexImpl.this.performShutdown());
                FileBasedIndexImpl.saveRegisteredIndicesAndDropUnregisteredOnes(this.state.getIndexIDs());
                FileBasedIndexImpl.this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new Runnable(){
                    private int lastModCount;

                    @Override
                    public void run() {
                        FileIndexDataInitialization.this.mySerializationManagerEx.flushNameStorage();
                        int currentModCount = FileBasedIndexImpl.this.myLocalModCount.get();
                        if (this.lastModCount == currentModCount) {
                            FileBasedIndexImpl.this.flushAllIndices(this.lastModCount);
                        }
                        this.lastModCount = currentModCount;
                    }
                });
                FileBasedIndexImpl.this.myAllIndicesInitializedFuture = IndexInfrastructure.submitGenesisTask(() -> {
                    if (!FileBasedIndexImpl.this.myShutdownPerformed.get()) {
                        FileBasedIndexImpl.this.myChangedFilesCollector.ensureUpToDateAsync();
                    }
                    return null;
                });
                FileBasedIndexImpl.this.myInitialized = true;
                throw throwable;
            }
            ShutDownTracker.getInstance().registerShutdownTask(() -> FileBasedIndexImpl.this.performShutdown());
            FileBasedIndexImpl.saveRegisteredIndicesAndDropUnregisteredOnes(this.state.getIndexIDs());
            FileBasedIndexImpl.this.myFlushingFuture = FlushingDaemon.everyFiveSeconds(new /* invalid duplicate definition of identical inner class */);
            FileBasedIndexImpl.this.myAllIndicesInitializedFuture = IndexInfrastructure.submitGenesisTask(() -> {
                if (!FileBasedIndexImpl.this.myShutdownPerformed.get()) {
                    FileBasedIndexImpl.this.myChangedFilesCollector.ensureUpToDateAsync();
                }
                return null;
            });
            FileBasedIndexImpl.this.myInitialized = true;
            return indexConfiguration;
        }
    }

    private final class DocumentUpdateTask
    extends UpdateTask<Document> {
        private final ID<?, ?> myIndexId;

        DocumentUpdateTask(ID<?, ?> indexId) {
            this.myIndexId = indexId;
        }

        @Override
        void doProcess(Document document, Project project) {
            FileBasedIndexImpl.this.indexUnsavedDocument(document, this.myIndexId, project, FileBasedIndexImpl.this.myFileDocumentManager.getFile(document));
        }
    }

    private class UnindexedFilesFinder
    implements CollectingContentIterator {
        private final List<VirtualFile> myFiles = new ArrayList<VirtualFile>();
        private final boolean myDoTraceForFilesToBeIndexed = LOG.isTraceEnabled();

        private UnindexedFilesFinder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public List<VirtualFile> getFiles() {
            List<VirtualFile> files2;
            List<VirtualFile> list2 = this.myFiles;
            synchronized (list2) {
                files2 = this.myFiles;
            }
            BitSet usedFileIds = new BitSet(files2.size());
            ArrayList<VirtualFile> localFileSystemFiles = new ArrayList<VirtualFile>(files2.size() / 2);
            ArrayList<VirtualFile> archiveFiles = new ArrayList<VirtualFile>(files2.size() / 2);
            for (VirtualFile file2 : files2) {
                int fileId = ((VirtualFileWithId)file2).getId();
                if (usedFileIds.get(fileId)) continue;
                usedFileIds.set(fileId);
                if (file2.getFileSystem() instanceof LocalFileSystem) {
                    localFileSystemFiles.add(file2);
                    continue;
                }
                archiveFiles.add(file2);
            }
            localFileSystemFiles.addAll(archiveFiles);
            return localFileSystemFiles;
        }

        public boolean processFile(@NotNull VirtualFile file2) {
            return (Boolean)ReadAction.compute(() -> {
                if (!file2.isValid()) {
                    return true;
                }
                if (file2 instanceof VirtualFileSystemEntry && ((VirtualFileSystemEntry)file2).isFileIndexed()) {
                    return true;
                }
                if (!(file2 instanceof VirtualFileWithId)) {
                    return true;
                }
                FileBasedIndexImpl.this.myFileTypeManager.freezeFileTypeTemporarilyIn(file2, () -> {
                    boolean isUptoDate = true;
                    if (file2.isDirectory() || !FileBasedIndexImpl.this.isTooLarge(file2)) {
                        List affectedIndexCandidates = FileBasedIndexImpl.this.getAffectedIndexCandidates(file2);
                        int size = affectedIndexCandidates.size();
                        for (int i = 0; i < size; ++i) {
                            ID indexId = (ID)affectedIndexCandidates.get(i);
                            try {
                                if (!FileBasedIndexImpl.this.needsFileContentLoading(indexId) || !FileBasedIndexImpl.this.shouldIndexFile(file2, indexId)) continue;
                                if (this.myDoTraceForFilesToBeIndexed) {
                                    LOG.trace("Scheduling indexing of " + file2 + " by request of index " + indexId);
                                }
                                List<VirtualFile> list2 = this.myFiles;
                                synchronized (list2) {
                                    this.myFiles.add(file2);
                                }
                                isUptoDate = false;
                                break;
                            }
                            catch (RuntimeException e) {
                                Throwable cause = e.getCause();
                                if (cause instanceof IOException || cause instanceof StorageException) {
                                    LOG.info((Throwable)e);
                                    FileBasedIndexImpl.this.requestRebuild(indexId);
                                    continue;
                                }
                                throw e;
                            }
                        }
                    }
                    FileContentImpl fileContent = null;
                    int inputId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
                    for (ID indexId : FileBasedIndexImpl.this.myNotRequiringContentIndices) {
                        if (!FileBasedIndexImpl.this.shouldIndexFile(file2, indexId)) continue;
                        isUptoDate = false;
                        if (fileContent == null) {
                            fileContent = new FileContentImpl(file2);
                        }
                        FileBasedIndexImpl.this.updateSingleIndex(indexId, file2, inputId, fileContent);
                    }
                    IndexingStamp.flushCache(inputId);
                    if (isUptoDate && file2 instanceof VirtualFileSystemEntry) {
                        ((VirtualFileSystemEntry)file2).setFileIndexed(true);
                    }
                });
                ProgressManager.checkCanceled();
                return true;
            });
        }
    }

    private final class ChangedFilesCollector
    extends IndexedFilesListener {
        private final IntObjectMap<VirtualFile> myFilesToUpdate = ContainerUtil.createConcurrentIntObjectMap();
        private final VfsEventsMerger myVfsEventsMerger = new VfsEventsMerger();
        private final AtomicInteger myProcessedEventIndex = new AtomicInteger();
        private final Phaser myWorkersFinishedSync = new Phaser(){

            @Override
            protected boolean onAdvance(int phase, int registeredParties) {
                return false;
            }
        };
        private final ExecutorService myVfsEventsExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"FileBasedIndex Vfs Event Processor");
        private final AtomicInteger myScheduledVfsEventsWorkers = new AtomicInteger();

        private ChangedFilesCollector() {
        }

        @Override
        protected void buildIndicesForFileRecursively(@NotNull VirtualFile file2, boolean contentChange) {
            FileBasedIndexImpl.cleanProcessedFlag(file2);
            if (!contentChange) {
                FileBasedIndexImpl.this.myUpdatingFiles.incrementAndGet();
            }
            super.buildIndicesForFileRecursively(file2, contentChange);
            if (!contentChange && FileBasedIndexImpl.this.myUpdatingFiles.decrementAndGet() == 0) {
                FileBasedIndexImpl.this.myFilesModCount.incrementAndGet();
            }
        }

        @Override
        protected void iterateIndexableFiles(@NotNull VirtualFile file2, @NotNull ContentIterator iterator) {
            for (IndexableFileSet set2 : FileBasedIndexImpl.this.myIndexableSets) {
                if (!set2.isInSet(file2)) continue;
                set2.iterateIndexableFilesIn(file2, iterator);
            }
        }

        @Override
        protected void buildIndicesForFile(@NotNull VirtualFile file2, boolean contentChange) {
            int fileId = FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2);
            this.myVfsEventsMerger.recordFileEvent(fileId, file2, contentChange);
        }

        @Override
        protected void doInvalidateIndicesForFile(@NotNull VirtualFile file2, boolean contentChange) {
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            this.myVfsEventsMerger.recordBeforeFileEvent(fileId, file2, contentChange);
        }

        void scheduleForUpdate(VirtualFile file2) {
            IndexableFileSet setForFile;
            if (!(file2 instanceof DeletedVirtualFileStub) && (setForFile = FileBasedIndexImpl.this.getIndexableSetForFile(file2)) == null) {
                return;
            }
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            VirtualFile previousVirtualFile = (VirtualFile)this.myFilesToUpdate.put(fileId, (Object)file2);
            if (previousVirtualFile instanceof DeletedVirtualFileStub && !previousVirtualFile.equals(file2)) {
                assert (((DeletedVirtualFileStub)previousVirtualFile).getOriginalFile().equals(file2));
                ((DeletedVirtualFileStub)previousVirtualFile).setResurrected(true);
                this.myFilesToUpdate.put(fileId, (Object)previousVirtualFile);
            }
        }

        private void removeScheduledFileFromUpdate(VirtualFile file2) {
            int fileId = Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2));
            VirtualFile previousVirtualFile = (VirtualFile)this.myFilesToUpdate.remove(fileId);
            if (previousVirtualFile instanceof DeletedVirtualFileStub) {
                assert (((DeletedVirtualFileStub)previousVirtualFile).getOriginalFile().equals(file2));
                ((DeletedVirtualFileStub)previousVirtualFile).setResurrected(false);
                this.myFilesToUpdate.put(fileId, (Object)previousVirtualFile);
            }
        }

        private void removeFileIdFromFilesScheduledForUpdate(int fileId) {
            this.myFilesToUpdate.remove(fileId);
        }

        Collection<VirtualFile> getAllFilesToUpdate() {
            this.ensureUpToDate();
            if (this.myFilesToUpdate.isEmpty()) {
                return Collections.emptyList();
            }
            return new ArrayList<VirtualFile>(this.myFilesToUpdate.values());
        }

        @Override
        public void before(@NotNull List<? extends VFileEvent> events) {
            for (VFileEvent vFileEvent : events) {
                if (!this.memoryStorageCleaningNeeded(vFileEvent)) continue;
                FileBasedIndexImpl.this.cleanupMemoryStorage(false);
                break;
            }
            super.before(events);
        }

        private boolean memoryStorageCleaningNeeded(VFileEvent event) {
            Object requestor = event.getRequestor();
            return requestor instanceof FileDocumentManager || requestor instanceof PsiManager || requestor == LocalHistory.VFS_EVENT_REQUESTOR;
        }

        @Override
        public void after(@NotNull List<? extends VFileEvent> events) {
            super.after(events);
            if (FileBasedIndexImpl.this.myInitialized) {
                this.ensureUpToDateAsync();
            }
        }

        boolean isScheduledForUpdate(VirtualFile file2) {
            return this.myFilesToUpdate.containsKey(Math.abs(FileBasedIndexImpl.getIdMaskingNonIdBasedFile(file2)));
        }

        void ensureUpToDate() {
            if (!FileBasedIndexImpl.isUpToDateCheckEnabled()) {
                return;
            }
            FileBasedIndexImpl.this.waitUntilIndicesAreInitialized();
            if (ApplicationManager.getApplication().isReadAccessAllowed()) {
                this.processFilesInReadAction();
            } else {
                this.processFilesInReadActionWithYieldingToWriteAction();
            }
        }

        void ensureUpToDateAsync() {
            if (this.myVfsEventsMerger.getApproximateChangesCount() >= 20 && this.myScheduledVfsEventsWorkers.compareAndSet(0, 1)) {
                this.myVfsEventsExecutor.submit(this::scheduledEventProcessingInReadActionWithYieldingToWriteAction);
                if (Registry.is((String)"try.starting.dumb.mode.where.many.files.changed")) {
                    Runnable startDumbMode = () -> {
                        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                            DumbServiceImpl dumbService = DumbServiceImpl.getInstance(project);
                            DumbModeTask task2 = FileBasedIndexProjectHandler.createChangedFilesIndexingTask(project);
                            if (task2 == null) continue;
                            dumbService.queueTask(task2);
                        }
                    };
                    Application app = ApplicationManager.getApplication();
                    if (!app.isHeadlessEnvironment() && app.isDispatchThread() && !LaterInvocator.isInModalContext()) {
                        startDumbMode.run();
                    } else {
                        app.invokeLater(startDumbMode, ModalityState.NON_MODAL);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processFilesInReadAction() {
            assert (ApplicationManager.getApplication().isReadAccessAllowed());
            int publishedEventIndex = this.myVfsEventsMerger.getPublishedEventIndex();
            int processedEventIndex = this.myProcessedEventIndex.get();
            if (processedEventIndex == publishedEventIndex) {
                return;
            }
            this.myWorkersFinishedSync.register();
            int phase = this.myWorkersFinishedSync.getPhase();
            try {
                this.myVfsEventsMerger.processChanges(info -> (Boolean)ConcurrencyUtil.withLock((Lock)FileBasedIndexImpl.this.myWriteLock, () -> {
                    try {
                        ProgressManager.getInstance().executeNonCancelableSection(() -> {
                            int fileId = info.getFileId();
                            VirtualFile file2 = info.getFile();
                            if (info.isTransientStateChanged()) {
                                FileBasedIndexImpl.this.doTransientStateChangeForFile(fileId, file2);
                            }
                            if (info.isBeforeContentChanged()) {
                                FileBasedIndexImpl.this.doInvalidateIndicesForFile(fileId, file2, true);
                            }
                            if (info.isContentChanged()) {
                                FileBasedIndexImpl.this.scheduleFileForIndexing(fileId, file2, true);
                            }
                            if (info.isFileRemoved()) {
                                FileBasedIndexImpl.this.doInvalidateIndicesForFile(fileId, file2, false);
                            }
                            if (info.isFileAdded()) {
                                FileBasedIndexImpl.this.scheduleFileForIndexing(fileId, file2, false);
                            }
                        });
                    }
                    finally {
                        IndexingStamp.flushCache(info.getFileId());
                    }
                    return true;
                }));
            }
            finally {
                this.myWorkersFinishedSync.arriveAndDeregister();
            }
            this.myWorkersFinishedSync.awaitAdvance(phase);
            if (this.myVfsEventsMerger.getPublishedEventIndex() == publishedEventIndex) {
                this.myProcessedEventIndex.compareAndSet(processedEventIndex, publishedEventIndex);
            }
        }

        private void processFilesInReadActionWithYieldingToWriteAction() {
            while (this.myVfsEventsMerger.hasChanges()) {
                if (ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(this::processFilesInReadAction)) continue;
                ProgressIndicatorUtils.yieldToPendingWriteActions();
            }
        }

        private void scheduledEventProcessingInReadActionWithYieldingToWriteAction() {
            try {
                this.processFilesInReadActionWithYieldingToWriteAction();
            }
            finally {
                this.myScheduledVfsEventsWorkers.decrementAndGet();
            }
        }
    }

    private class VirtualFileUpdateTask
    extends UpdateTask<VirtualFile> {
        private VirtualFileUpdateTask() {
        }

        @Override
        void doProcess(VirtualFile item, Project project) {
            FileBasedIndexImpl.this.processRefreshedFile(project, new com.intellij.ide.caches.FileContent(item));
        }
    }

    private static class PsiContent
    implements DocumentContent {
        private final Document myDocument;
        private final PsiFile myFile;

        private PsiContent(Document document, PsiFile file2) {
            this.myDocument = document;
            this.myFile = file2;
        }

        @Override
        @NotNull
        public CharSequence getText() {
            if (this.myFile.getViewProvider().getModificationStamp() != this.myDocument.getModificationStamp()) {
                FileASTNode node = this.myFile.getNode();
                assert (node != null);
                return node.getChars();
            }
            return this.myDocument.getImmutableCharSequence();
        }

        @Override
        public long getModificationStamp() {
            return this.myFile.getViewProvider().getModificationStamp();
        }
    }

    private static class AuthenticContent
    implements DocumentContent {
        private final Document myDocument;

        private AuthenticContent(Document document) {
            this.myDocument = document;
        }

        @Override
        @NotNull
        public CharSequence getText() {
            return this.myDocument.getImmutableCharSequence();
        }

        @Override
        public long getModificationStamp() {
            return this.myDocument.getModificationStamp();
        }
    }

    private static interface DocumentContent {
        @NotNull
        public CharSequence getText();

        public long getModificationStamp();
    }

    public static final class ProjectIndexableFilesFilter
    extends IdFilter {
        private static final int SHIFT = 6;
        private static final int MASK = 63;
        private final long[] myBitMask;
        private final int myModificationCount;
        private final int myMinId;
        private final int myMaxId;

        private ProjectIndexableFilesFilter(@NotNull TIntArrayList set2, int modificationCount) {
            this.myModificationCount = modificationCount;
            int[] minMax = new int[2];
            if (!set2.isEmpty()) {
                minMax[0] = minMax[1] = set2.get(0);
            }
            set2.forEach(value -> {
                minMax[0] = Math.min(minMax[0], value);
                minMax[1] = Math.max(minMax[1], value);
                return true;
            });
            this.myMaxId = minMax[1];
            this.myMinId = minMax[0];
            this.myBitMask = new long[(this.myMaxId - this.myMinId >> 6) + 1];
            set2.forEach(value -> {
                int n = (value -= this.myMinId) >> 6;
                this.myBitMask[n] = this.myBitMask[n] | 1L << (value & 0x3F);
                return true;
            });
        }

        public boolean containsFileId(int id) {
            if (id < this.myMinId) {
                return false;
            }
            if (id > this.myMaxId) {
                return false;
            }
            return (this.myBitMask[(id -= this.myMinId) >> 6] & 1L << (id & 0x3F)) != 0L;
        }
    }

    @FunctionalInterface
    public static interface IdValueProcessor<V> {
        public boolean process(int var1, V var2);
    }
}

